/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.display;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaValue;

public class JavaInspectExpression
extends PlatformObject
implements IExpression,
IDebugEventSetListener {
    private IJavaValue fValue;
    private String fExpression;

    public JavaInspectExpression(String expression, IJavaValue value) {
        this.fValue = value;
        this.fExpression = expression;
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public String getExpressionText() {
        return this.fExpression;
    }

    public IValue getValue() {
        return this.fValue;
    }

    public IDebugTarget getDebugTarget() {
        return this.getValue().getDebugTarget();
    }

    public String getModelIdentifier() {
        return this.getValue().getModelIdentifier();
    }

    public ILaunch getLaunch() {
        return this.getValue().getLaunch();
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getKind() == 8 && event.getSource().equals(this.getDebugTarget())) {
                DebugPlugin.getDefault().getExpressionManager().removeExpression((IExpression)this);
            }
            ++i;
        }
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }
}

