/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.display;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIContentAssistPreference;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.display.ClearDisplayAction;
import org.eclipse.jdt.internal.debug.ui.display.DisplayMessages;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewAction;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.internal.debug.ui.display.IDataDisplay;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IUpdate;

public class DisplayView
extends ViewPart
implements IPropertyChangeListener,
ITextInputListener {
    protected IDataDisplay fDataDisplay = new DataDisplay();
    protected IDocumentListener fDocumentListener = null;
    protected JDISourceViewer fSourceViewer;
    protected IAction fClearDisplayAction;
    protected DisplayViewAction fContentAssistAction;
    protected Map fGlobalActions = new HashMap(4);
    protected List fSelectionActions = new ArrayList(3);
    protected String fRestoredContents = null;
    private Font fFont = null;
    private Color fForegroundColor = null;
    private Color fBackgroundColor = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void createPartControl(Composite parent) {
        int styles = 66306;
        this.fSourceViewer = new JDISourceViewer(parent, null, styles);
        this.fSourceViewer.configure((SourceViewerConfiguration)new DisplayViewerConfiguration());
        this.fSourceViewer.getSelectionProvider().addSelectionChangedListener(this.getSelectionChangedListener());
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        IDocument doc = this.getRestoredDocument();
        this.setViewerFont((ISourceViewer)this.fSourceViewer);
        this.setViewerColors((ISourceViewer)this.fSourceViewer);
        this.fSourceViewer.setDocument(doc);
        this.fSourceViewer.addTextInputListener(this);
        this.fRestoredContents = null;
        this.createActions();
        this.initializeToolBar();
        MenuManager menuMgr = new MenuManager("#PopUp");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                DisplayView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.fSourceViewer.getTextWidget());
        this.fSourceViewer.getTextWidget().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, this.fSourceViewer.getSelectionProvider());
        this.getSite().setSelectionProvider(this.fSourceViewer.getSelectionProvider());
        WorkbenchHelp.setHelp((Control)this.fSourceViewer.getTextWidget(), (String)IJavaDebugHelpContextIds.DISPLAY_VIEW);
    }

    protected IDocument getRestoredDocument() {
        Document doc = null;
        doc = this.fRestoredContents != null ? new Document(this.fRestoredContents) : new Document();
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        IDocumentPartitioner partitioner = tools.createDocumentPartitioner();
        partitioner.connect((IDocument)doc);
        doc.setDocumentPartitioner(partitioner);
        this.fDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                DisplayView.this.updateAction("find");
            }
        };
        doc.addDocumentListener(this.fDocumentListener);
        return doc;
    }

    public void setFocus() {
        if (this.fSourceViewer != null) {
            this.fSourceViewer.getControl().setFocus();
        }
    }

    protected void createActions() {
        this.fClearDisplayAction = new ClearDisplayAction((IWorkbenchPart)this);
        IActionBars actionBars = this.getViewSite().getActionBars();
        DisplayViewAction action = new DisplayViewAction((IAdaptable)this, 3);
        action.setText(DisplayMessages.getString("DisplayView.Cut.label"));
        action.setToolTipText(DisplayMessages.getString("DisplayView.Cut.tooltip"));
        action.setDescription(DisplayMessages.getString("DisplayView.Cut.description"));
        this.setGlobalAction(actionBars, "cut", (IAction)action);
        action = new DisplayViewAction((IAdaptable)this, 4);
        action.setText(DisplayMessages.getString("DisplayView.Copy.label"));
        action.setToolTipText(DisplayMessages.getString("DisplayView.Copy.tooltip"));
        action.setDescription(DisplayMessages.getString("DisplayView.Copy.description"));
        this.setGlobalAction(actionBars, "copy", (IAction)action);
        action = new DisplayViewAction((IAdaptable)this, 5);
        action.setText(DisplayMessages.getString("DisplayView.Paste.label"));
        action.setToolTipText(DisplayMessages.getString("DisplayView.Paste.tooltip"));
        action.setDescription(DisplayMessages.getString("DisplayView.Paste.Description"));
        this.setGlobalAction(actionBars, "paste", (IAction)action);
        action = new DisplayViewAction((IAdaptable)this, 7);
        action.setText(DisplayMessages.getString("DisplayView.SelectAll.label"));
        action.setToolTipText(DisplayMessages.getString("DisplayView.SelectAll.tooltip"));
        action.setDescription(DisplayMessages.getString("DisplayView.SelectAll.description"));
        this.setGlobalAction(actionBars, "selectAll", (IAction)action);
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.jdt.internal.debug.ui.display.DisplayMessages");
        this.setGlobalAction(actionBars, "find", (IAction)new FindReplaceAction(bundle, "find_replace_action.", (IWorkbenchPart)this));
        this.fSelectionActions.add("cut");
        this.fSelectionActions.add("copy");
        this.fSelectionActions.add("paste");
        this.fContentAssistAction = new DisplayViewAction((IAdaptable)this, 13);
        this.fContentAssistAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.fContentAssistAction.setText(DisplayMessages.getString("DisplayView.Co&ntent_Assist@Ctrl+Space_1"));
        this.fContentAssistAction.setDescription(DisplayMessages.getString("DisplayView.Content_Assist_2"));
        this.fContentAssistAction.setToolTipText(DisplayMessages.getString("DisplayView.Content_Assist_2"));
        this.fContentAssistAction.setImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_ELCL_CONTENT_ASSIST"));
        this.fContentAssistAction.setHoverImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_LCL_CONTENT_ASSIST"));
        this.fContentAssistAction.setDisabledImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_DLCL_CONTENT_ASSIST"));
        actionBars.updateActionBars();
        this.addVerifyKeyListener();
        this.getSite().getKeyBindingService().registerAction((IAction)this.fContentAssistAction);
    }

    protected void addVerifyKeyListener() {
        this.fSourceViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.stateMask == 262144 && event.keyCode == 0 && event.character == ' ' && DisplayView.this.fContentAssistAction.isEnabled()) {
                    DisplayView.this.fContentAssistAction.run();
                    event.doit = false;
                }
            }
        });
    }

    protected void setGlobalAction(IActionBars actionBars, String actionID, IAction action) {
        this.fGlobalActions.put(actionID, action);
        actionBars.setGlobalActionHandler(actionID, action);
    }

    protected void initializeToolBar() {
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IContributionItem)new Separator("evaluationGroup"));
        tbm.add(this.fClearDisplayAction);
        this.getViewSite().getActionBars().updateActionBars();
    }

    protected void fillContextMenu(IMenuManager menu) {
        if (this.fSourceViewer.getDocument() == null) {
            return;
        }
        menu.add((IContributionItem)new Separator("evaluationGroup"));
        if (DebugUITools.getDebugContext() != null) {
            menu.add((IAction)this.fContentAssistAction);
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fGlobalActions.get("cut"));
        menu.add((IAction)this.fGlobalActions.get("copy"));
        menu.add((IAction)this.fGlobalActions.get("paste"));
        menu.add((IAction)this.fGlobalActions.get("selectAll"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fGlobalActions.get("find"));
        menu.add(this.fClearDisplayAction);
        menu.add((IContributionItem)new Separator("additions"));
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.fSourceViewer.getTextOperationTarget();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.text.IFindReplaceTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required)) {
            return this.fSourceViewer.getFindReplaceTarget();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jdt.internal.debug.ui.display.IDataDisplay");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(required)) {
            return this.fDataDisplay;
        }
        return super.getAdapter(required);
    }

    protected void updateActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            IAction action = (IAction)this.fGlobalActions.get((String)iterator.next());
            if (!(action instanceof IUpdate)) continue;
            ((IUpdate)action).update();
        }
    }

    public void saveState(IMemento memento) {
        if (this.fSourceViewer != null) {
            IDocument doc = this.fSourceViewer.getDocument();
            String contents = doc.get().trim();
            memento.putTextData(contents);
        } else if (this.fRestoredContents != null) {
            memento.putTextData(this.fRestoredContents);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        if (memento != null) {
            this.fRestoredContents = memento.getTextData();
        }
    }

    protected String getContents() {
        return this.fSourceViewer.getDocument().get();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property;
        IContentAssistant assistant = this.fSourceViewer.getContentAssistant();
        if (assistant instanceof ContentAssistant) {
            JDIContentAssistPreference.changeConfiguration((ContentAssistant)assistant, event);
        }
        if ("org.eclipse.jface.textfont".equals(property = event.getProperty())) {
            this.setViewerFont((ISourceViewer)this.fSourceViewer);
        }
        if ("AbstractTextEditor.Color.Foreground".equals(property) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property)) {
            this.setViewerColors((ISourceViewer)this.fSourceViewer);
        }
        if (this.affectsTextPresentation(event)) {
            this.fSourceViewer.invalidateTextPresentation();
        }
    }

    public void dispose() {
        if (this.getFont() != null) {
            this.getFont().dispose();
            this.setFont(null);
        }
        if (this.getBackgroundColor() != null) {
            this.getBackgroundColor().dispose();
            this.setBackgroundColor(null);
        }
        if (this.getForegroundColor() != null) {
            this.getForegroundColor().dispose();
            this.setForegroundColor(null);
        }
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected IPreferenceStore getPreferenceStore() {
        AbstractUIPlugin p = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.jdt.ui");
        return p.getPreferenceStore();
    }

    private void setViewerFont(ISourceViewer viewer) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            FontData data = null;
            data = store.contains("org.eclipse.jface.textfont") && !store.isDefault("org.eclipse.jface.textfont") ? PreferenceConverter.getFontData((IPreferenceStore)store, (String)"org.eclipse.jface.textfont") : PreferenceConverter.getDefaultFontData((IPreferenceStore)store, (String)"org.eclipse.jface.textfont");
            if (data != null) {
                Font font = new Font((Device)viewer.getTextWidget().getDisplay(), data);
                this.setFont(viewer, font);
                if (this.getFont() != null) {
                    this.getFont().dispose();
                }
                this.setFont(font);
                return;
            }
        }
        this.setFont(viewer, JFaceResources.getTextFont());
    }

    private void setViewerColors(ISourceViewer viewer) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            StyledText styledText = viewer.getTextWidget();
            Color color = store.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
            styledText.setForeground(color);
            if (this.getForegroundColor() != null) {
                this.getForegroundColor().dispose();
            }
            this.setForegroundColor(color);
            color = store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.getBackgroundColor() != null) {
                this.getBackgroundColor().dispose();
            }
            this.setBackgroundColor(color);
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    private void setFont(ISourceViewer sourceViewer, Font font) {
        IDocument doc = sourceViewer.getDocument();
        if (doc != null && doc.getLength() > 0) {
            Point selection = sourceViewer.getSelectedRange();
            int topIndex = sourceViewer.getTopIndex();
            StyledText styledText = sourceViewer.getTextWidget();
            styledText.setRedraw(false);
            styledText.setFont(font);
            sourceViewer.setSelectedRange(selection.x, selection.y);
            sourceViewer.setTopIndex(topIndex);
            styledText.setRedraw(true);
        } else {
            sourceViewer.getTextWidget().setFont(font);
        }
    }

    protected Font getFont() {
        return this.fFont;
    }

    protected void setFont(Font font) {
        this.fFont = font;
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        return textTools.affectsBehavior(event);
    }

    protected final ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DisplayView.this.updateSelectionDependentActions();
            }
        };
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateAction(String actionId) {
        IAction action = (IAction)this.fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected Color getBackgroundColor() {
        return this.fBackgroundColor;
    }

    protected void setBackgroundColor(Color backgroundColor) {
        this.fBackgroundColor = backgroundColor;
    }

    protected Color getForegroundColor() {
        return this.fForegroundColor;
    }

    protected void setForegroundColor(Color foregroundColor) {
        this.fForegroundColor = foregroundColor;
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        oldInput.removeDocumentListener(this.fDocumentListener);
    }

    class DataDisplay
    implements IDataDisplay {
        DataDisplay() {
        }

        public void clear() {
            IDocument document = DisplayView.this.fSourceViewer.getDocument();
            if (document != null) {
                document.set("");
            }
        }

        public void displayExpression(String expression) {
            IDocument document = DisplayView.this.fSourceViewer.getDocument();
            int offset = document.getLength();
            try {
                if (offset != document.getLineInformationOfOffset(offset).getOffset()) {
                    expression = String.valueOf(System.getProperty("line.separator")) + expression.trim();
                }
                DisplayView.this.fSourceViewer.getDocument().replace(offset, 0, expression);
                DisplayView.this.fSourceViewer.setSelectedRange(offset + expression.length(), 0);
                DisplayView.this.fSourceViewer.revealRange(offset, expression.length());
            }
            catch (BadLocationException ble) {
                JDIDebugUIPlugin.log(ble);
            }
        }

        public void displayExpressionValue(String value) {
            value = String.valueOf(System.getProperty("line.separator")) + '\t' + value;
            ITextSelection selection = (ITextSelection)DisplayView.this.fSourceViewer.getSelection();
            int offset = selection.getOffset() + selection.getLength();
            int length = value.length();
            try {
                DisplayView.this.fSourceViewer.getDocument().replace(offset, 0, value);
            }
            catch (BadLocationException ble) {
                JDIDebugUIPlugin.log(ble);
            }
            DisplayView.this.fSourceViewer.setSelectedRange(offset + length, 0);
            DisplayView.this.fSourceViewer.revealRange(offset, length);
        }
    }
}

