/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.console;

import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jdt.internal.debug.ui.console.JavaNativeStackTraceHyperlink;
import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceHyperlink;
import org.eclipse.jdt.internal.debug.ui.console.StringMatcher;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;

public class JavaConsoleTracker
implements IConsoleLineTracker {
    private IConsole fConsole;
    private StringMatcher fJavaMatcher;
    private StringMatcher fNativeMatcher;

    public void init(IConsole console) {
        this.fConsole = console;
        this.fJavaMatcher = new StringMatcher("*(*.java:*)", false, false);
        this.fNativeMatcher = new StringMatcher("*(Native Method)", false, false);
    }

    public void lineAppended(IRegion line) {
        try {
            int offset = line.getOffset();
            int length = line.getLength();
            String text = this.fConsole.getDocument().get(offset, length);
            boolean standardMatch = false;
            int index = -1;
            if (this.fJavaMatcher.match(text)) {
                standardMatch = true;
                index = text.lastIndexOf(32);
            } else if (this.fNativeMatcher.match(text)) {
                index = text.lastIndexOf(32, text.length() - 15);
            }
            if (index >= 0) {
                int linkOffset = offset + index + 1;
                int linkLength = length - index - 1;
                JavaStackTraceHyperlink link = null;
                link = standardMatch ? new JavaStackTraceHyperlink(this.fConsole) : new JavaNativeStackTraceHyperlink(this.fConsole);
                this.fConsole.addLink((IConsoleHyperlink)link, linkOffset, linkLength);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void dispose() {
        this.fConsole = null;
        this.fJavaMatcher = null;
        this.fNativeMatcher = null;
    }
}

