/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaWatchExpression;
import org.eclipse.jdt.internal.debug.ui.actions.InspectAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class WatchAction
extends InspectAction {
    public void run() {
        Object selectedObject = this.getSelectedObject();
        if (selectedObject instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)selectedObject;
            Iterator elements = selection.iterator();
            while (elements.hasNext()) {
                try {
                    this.createWatchExpression(((IJavaVariable)elements.next()).getName());
                }
                catch (DebugException e) {
                    JDIDebugUIPlugin.log(e);
                    return;
                }
            }
            this.showExpressionView();
        } else if (selectedObject instanceof String) {
            this.createWatchExpression((String)selectedObject);
            this.showExpressionView();
        }
    }

    private void createWatchExpression(String snippet) {
        IThread thread;
        JavaWatchExpression expression = new JavaWatchExpression(snippet);
        IJavaStackFrame stackFrame = this.getStackFrameContext();
        if (stackFrame != null && (thread = stackFrame.getThread()) instanceof IJavaThread) {
            expression.evaluateExpression((IJavaThread)thread);
        }
        DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)expression);
    }
}

