/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ThreadFilterViewer
extends FieldEditor {
    private IJavaBreakpoint fBreakpoint;
    private CheckboxTreeViewer fThreadViewer;
    private Composite fOuter;
    private ThreadFilterContentProvider fContentProvider;
    private CheckHandler fCheckHandler;
    private static String MAIN = "main";
    static /* synthetic */ Class class$0;

    public ThreadFilterViewer(Composite parent, IJavaBreakpoint breakpoint) {
        this.fBreakpoint = breakpoint;
        this.fContentProvider = new ThreadFilterContentProvider();
        this.fCheckHandler = new CheckHandler();
        this.init("THREAD_FILTER", ActionMessages.getString("ThreadFilterViewer.Thread_filtering_1"));
        this.createControl(parent);
    }

    protected void createThreadViewer() {
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.fThreadViewer = new CheckboxTreeViewer(this.fOuter, 2048);
        this.fThreadViewer.addCheckStateListener((ICheckStateListener)this.fCheckHandler);
        this.fThreadViewer.getTree().setLayoutData((Object)data);
        this.fThreadViewer.getTree().setFont(this.fOuter.getFont());
        this.fThreadViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fThreadViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        this.fThreadViewer.setInput((Object)DebugPlugin.getDefault().getLaunchManager());
        this.setInitialCheckedState();
    }

    protected void setInitialCheckedState() {
        try {
            IDebugTarget[] targets = this.getDebugTargets();
            int i = 0;
            int numTargets = targets.length;
            while (i < numTargets) {
                IJavaThread filteredThread;
                IJavaDebugTarget target;
                IDebugTarget iDebugTarget = targets[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jdt.debug.core.IJavaDebugTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((target = (IJavaDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null && (filteredThread = this.fBreakpoint.getThreadFilter(target)) != null) {
                    this.fCheckHandler.checkThread((IThread)filteredThread, true);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    protected IDebugTarget[] getDebugTargets() {
        Object input = this.fThreadViewer.getInput();
        if (!(input instanceof ILaunchManager)) {
            return new IJavaDebugTarget[0];
        }
        ILaunchManager launchManager = (ILaunchManager)input;
        return launchManager.getDebugTargets();
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.fOuter.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.fOuter = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = numColumns;
        this.fOuter.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.fOuter.setLayoutData((Object)data);
        this.fOuter.setFont(parent.getFont());
        data = new GridData();
        data.horizontalSpan = numColumns;
        this.getLabelControl(this.fOuter).setLayoutData((Object)data);
        this.createThreadViewer();
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
        IDebugTarget[] targets = this.getDebugTargets();
        int i = 0;
        int numTargets = targets.length;
        while (i < numTargets) {
            block10: {
                IJavaDebugTarget target;
                IDebugTarget iDebugTarget = targets[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jdt.debug.core.IJavaDebugTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((target = (IJavaDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null) {
                    try {
                        if (this.fThreadViewer.getChecked((Object)target)) {
                            IThread[] threads = target.getThreads();
                            int j = 0;
                            int numThreads = threads.length;
                            while (j < numThreads) {
                                IJavaThread thread = (IJavaThread)threads[j];
                                if (this.fThreadViewer.getChecked((Object)thread)) {
                                    this.fBreakpoint.setThreadFilter(thread);
                                    break block10;
                                }
                                ++j;
                            }
                            break block10;
                        }
                        this.fBreakpoint.removeThreadFilter(target);
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log(e);
                    }
                }
            }
            ++i;
        }
    }

    public int getNumberOfControls() {
        return 1;
    }

    class CheckHandler
    implements ICheckStateListener {
        CheckHandler() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (element instanceof IDebugTarget) {
                this.checkTarget((IDebugTarget)element, event.getChecked());
            } else if (element instanceof IThread) {
                this.checkThread((IThread)element, event.getChecked());
            }
            this.verifyCheckedState();
        }

        protected void checkTarget(IDebugTarget target, boolean checked) {
            block11: {
                IThread[] threads;
                block12: {
                    IThread[] threads2;
                    ThreadFilterViewer.this.fThreadViewer.setChecked((Object)target, checked);
                    if (!checked) break block12;
                    ThreadFilterViewer.this.fThreadViewer.expandToLevel((Object)target, -1);
                    try {
                        threads2 = target.getThreads();
                    }
                    catch (DebugException exception) {
                        JDIDebugUIPlugin.log(exception);
                        return;
                    }
                    boolean checkedThread = false;
                    int i = 0;
                    int numThreads = threads2.length;
                    while (i < numThreads) {
                        IThread thread = threads2[i];
                        String name = null;
                        try {
                            name = thread.getName();
                        }
                        catch (DebugException exception) {
                            JDIDebugUIPlugin.log(exception);
                        }
                        if (MAIN.equals(name)) {
                            checkedThread = ThreadFilterViewer.this.fThreadViewer.setChecked((Object)thread, true);
                        }
                        ++i;
                    }
                    if (checkedThread) break block11;
                    i = 0;
                    numThreads = threads2.length;
                    while (i < numThreads) {
                        if (!ThreadFilterViewer.this.fThreadViewer.setChecked((Object)threads2[i], true)) {
                            ++i;
                            continue;
                        }
                        break block11;
                    }
                    break block11;
                }
                try {
                    threads = target.getThreads();
                }
                catch (DebugException exception) {
                    JDIDebugUIPlugin.log(exception);
                    return;
                }
                int i = 0;
                int numThreads = threads.length;
                while (i < numThreads) {
                    ThreadFilterViewer.this.fThreadViewer.setChecked((Object)threads[i], false);
                    ++i;
                }
            }
        }

        protected void checkThread(IThread thread, boolean checked) {
            ThreadFilterViewer.this.fThreadViewer.setChecked((Object)thread, checked);
            IDebugTarget target = thread.getDebugTarget();
            if (checked) {
                IThread[] threads;
                if (!ThreadFilterViewer.this.fThreadViewer.getChecked((Object)target)) {
                    ThreadFilterViewer.this.fThreadViewer.setChecked((Object)target, true);
                }
                try {
                    threads = target.getThreads();
                }
                catch (DebugException exception) {
                    JDIDebugUIPlugin.log(exception);
                    return;
                }
                int i = 0;
                int numThreads = threads.length;
                while (i < numThreads) {
                    if (threads[i] != thread) {
                        ThreadFilterViewer.this.fThreadViewer.setChecked((Object)threads[i], false);
                    }
                    ++i;
                }
            } else {
                ThreadFilterViewer.this.fThreadViewer.setChecked((Object)target, false);
            }
        }

        protected void verifyCheckedState() {
            IDebugTarget[] targets = ThreadFilterViewer.this.getDebugTargets();
            int i = 0;
            int numTargets = targets.length;
            while (i < numTargets) {
                block8: {
                    IDebugTarget target = targets[i];
                    if (ThreadFilterViewer.this.fThreadViewer.getChecked((Object)target)) {
                        IThread[] threads;
                        try {
                            threads = target.getThreads();
                        }
                        catch (DebugException exception) {
                            JDIDebugUIPlugin.log(exception);
                            break block8;
                        }
                        boolean checkedThread = false;
                        int j = 0;
                        int numThreads = threads.length;
                        while (j < numThreads) {
                            if (ThreadFilterViewer.this.fThreadViewer.getChecked((Object)threads[j])) {
                                checkedThread = true;
                                break;
                            }
                            ++j;
                        }
                        if (checkedThread) {
                            ThreadFilterViewer.this.clearErrorMessage();
                        } else {
                            ThreadFilterViewer.this.showErrorMessage(ActionMessages.getString("ThreadFilterViewer.Must_select_a_thread_in_selected_targets_2"));
                        }
                    }
                }
                ++i;
            }
        }
    }

    class ThreadFilterContentProvider
    implements ITreeContentProvider {
        static /* synthetic */ Class class$0;

        ThreadFilterContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof IDebugTarget) {
                IJavaDebugTarget target;
                IDebugTarget iDebugTarget = (IDebugTarget)parent;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaDebugTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((target = (IJavaDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null) {
                    try {
                        return ((IJavaDebugTarget)parent).getThreads();
                    }
                    catch (DebugException e) {
                        JDIDebugUIPlugin.log(e);
                    }
                }
            }
            if (parent instanceof ILaunchManager) {
                ArrayList<IJavaDebugTarget> children = new ArrayList<IJavaDebugTarget>();
                ILaunch[] launches = ((ILaunchManager)parent).getLaunches();
                int i = 0;
                int numLaunches = launches.length;
                while (i < numLaunches) {
                    IDebugTarget[] targets = launches[i].getDebugTargets();
                    int j = 0;
                    int numTargets = targets.length;
                    while (j < numTargets) {
                        IJavaDebugTarget target;
                        IDebugTarget iDebugTarget = targets[j];
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.jdt.debug.core.IJavaDebugTarget");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((target = (IJavaDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null && !target.isDisconnected() && !target.isTerminated()) {
                            children.add(target);
                        }
                        ++j;
                    }
                    ++i;
                }
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IThread) {
                return ((IThread)element).getDebugTarget();
            }
            if (element instanceof IDebugTarget) {
                return ((IDebugElement)element).getLaunch();
            }
            if (element instanceof ILaunch) {
                return DebugPlugin.getDefault().getLaunchManager();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IStackFrame) {
                return false;
            }
            if (element instanceof IDebugElement) {
                return this.getChildren(element).length > 0;
            }
            if (element instanceof ILaunch) {
                return true;
            }
            if (element instanceof ILaunchManager) {
                return ((ILaunchManager)element).getLaunches().length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

