/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ManageMethodBreakpointActionDelegate;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public class StepIntoSelectionHandler
implements IDebugEventFilter {
    private IMethod fMethod;
    private String fResolvedSignature;
    private IJavaThread fThread;
    private String fOriginalName;
    private String fOriginalSignature;
    private String fOriginalTypeName;
    private int fOriginalStackDepth;
    private boolean fFirstStep = true;
    private boolean fStepFilterEnabledState;
    private static final DebugEvent[] fgEmptyEvents = new DebugEvent[0];

    public StepIntoSelectionHandler(IJavaThread thread, IJavaStackFrame frame, IMethod method) {
        this.fMethod = method;
        this.fThread = thread;
        try {
            this.fOriginalName = frame.getName();
            this.fOriginalSignature = frame.getSignature();
            this.fOriginalTypeName = frame.getDeclaringTypeName();
            this.fResolvedSignature = method.isBinary() ? method.getSignature() : ManageMethodBreakpointActionDelegate.resolveMethodSignature(method.getDeclaringType(), method.getSignature());
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    protected IJavaThread getThread() {
        return this.fThread;
    }

    protected IJavaDebugTarget getDebugTarget() {
        return (IJavaDebugTarget)this.getThread().getDebugTarget();
    }

    protected IMethod getMethod() {
        return this.fMethod;
    }

    protected String getSignature() {
        return this.fResolvedSignature;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public DebugEvent[] filterDebugEvents(DebugEvent[] events) {
        i = 0;
        while (i < events.length) {
            event = events[i];
            if (event.getSource() != this.getThread()) ** GOTO lbl63
            if (event.getKind() == 1) {
                if (event.isStepStart()) {
                    if (this.fFirstStep) {
                        this.fFirstStep = false;
                        return events;
                    }
                    return StepIntoSelectionHandler.fgEmptyEvents;
                }
            } else {
                if (event.getKind() == 2) {
                    if (event.getDetail() != 8) {
                        this.cleanup();
                        return events;
                    }
                    if (events.length > 1) {
                        j = 1;
                        while (j < events.length) {
                            debugEvent = events[j];
                            if (debugEvent.getKind() == 2) {
                                this.cleanup();
                                filtered = new DebugEvent[events.length - 1];
                                k = 1;
                                if (k < events.length) {
                                    filtered[k - 1] = events[k];
                                    return filtered;
                                }
                            }
                            ++j;
                        }
                    }
                    try {
                        frame = (IJavaStackFrame)this.getThread().getTopStackFrame();
                        stackDepth = frame.getThread().getStackFrames().length;
                        name = null;
                        if (frame.isConstructor()) {
                            name = frame.getDeclaringTypeName();
                            index = name.lastIndexOf(46);
                            if (index >= 0) {
                                name = name.substring(index + 1);
                            }
                        } else {
                            name = frame.getName();
                        }
                        if (name.equals(this.getMethod().getElementName()) && frame.getSignature().equals(this.getSignature())) {
                            this.cleanup();
                            return events;
                        }
                        r /* !! */  = null;
                        if (stackDepth > this.fOriginalStackDepth) {
                            r /* !! */  = new Runnable(){

                                public void run() {
                                    try {
                                        frame.stepReturn();
                                    }
                                    catch (DebugException e) {
                                        JDIDebugUIPlugin.log(e);
                                        StepIntoSelectionHandler.this.cleanup();
                                        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)StepIntoSelectionHandler.this.getDebugTarget(), 16)});
                                    }
                                }
                            };
                        } else if (stackDepth == this.fOriginalStackDepth) {
                            if (!(frame.getSignature().equals(this.fOriginalSignature) && frame.getName().equals(this.fOriginalName) && frame.getDeclaringTypeName().equals(this.fOriginalTypeName))) {
                                this.missed();
                                return events;
                            }
                            r /* !! */  = new Runnable(){

                                public void run() {
                                    try {
                                        frame.stepInto();
                                    }
                                    catch (DebugException e) {
                                        JDIDebugUIPlugin.log(e);
                                        StepIntoSelectionHandler.this.cleanup();
                                        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)StepIntoSelectionHandler.this.getDebugTarget(), 16)});
                                    }
                                }
                            };
                        } else {
                            this.missed();
                            return events;
                        }
                        DebugPlugin.getDefault().asyncExec(r /* !! */ );
                        return StepIntoSelectionHandler.fgEmptyEvents;
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log(e);
                        this.cleanup();
                        return events;
                    }
                }
                this.cleanup();
                return events;
lbl63:
                // 1 sources

                if (event.getSource() == this.getThread().getDebugTarget()) {
                    this.cleanup();
                    return events;
                }
            }
            ++i;
        }
        return events;
    }

    protected void missed() {
        this.cleanup();
        Runnable r = new Runnable(){

            public void run() {
                String methodName = null;
                try {
                    methodName = Signature.toString((String)StepIntoSelectionHandler.this.getMethod().getSignature(), (String)StepIntoSelectionHandler.this.getMethod().getElementName(), (String[])StepIntoSelectionHandler.this.getMethod().getParameterNames(), (boolean)false, (boolean)false);
                }
                catch (JavaModelException javaModelException) {
                    methodName = StepIntoSelectionHandler.this.getMethod().getElementName();
                }
                Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, MessageFormat.format(ActionMessages.getString("StepIntoSelectionHandler.Execution_did_not_enter___{0}___before_the_current_method_returned._1"), methodName), null);
                ErrorDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)ActionMessages.getString("StepIntoSelectionHandler.Error_2"), null, (IStatus)status);
            }
        };
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(r);
    }

    public void step() {
        DebugPlugin.getDefault().addDebugEventFilter((IDebugEventFilter)this);
        this.fStepFilterEnabledState = this.getDebugTarget().isStepFiltersEnabled();
        this.getDebugTarget().setStepFiltersEnabled(false);
        try {
            this.fOriginalStackDepth = this.getThread().getStackFrames().length;
            this.getThread().stepInto();
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
            this.cleanup();
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this.getDebugTarget(), 16)});
        }
    }

    protected void cleanup() {
        DebugPlugin.getDefault().removeDebugEventFilter((IDebugEventFilter)this);
        this.getDebugTarget().setStepFiltersEnabled(this.fStepFilterEnabledState);
    }
}

