/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.ExceptionHandler;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ManageBreakpointActionDelegate;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookLauncher;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineActionDelegate
extends ManageBreakpointActionDelegate
implements IEditorActionDelegate {
    public void run(IAction action) {
        try {
            IDebugTarget target = this.getContext();
            if (target == null) {
                if (this.getTextEditor() != null) {
                    this.getTextEditor().getSite().getShell().getDisplay().beep();
                }
                return;
            }
            ITextSelection selection = (ITextSelection)this.getTextEditor().getSelectionProvider().getSelection();
            this.setLineNumber(selection.getStartLine() + 1);
            IType type = this.getType(this.getTextEditor().getEditorInput());
            if (type == null) {
                return;
            }
            IJavaLineBreakpoint breakpoint = null;
            try {
                HashMap attributes = new HashMap(4);
                BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)type);
                BreakpointUtils.addRunToLineAttributes(attributes);
                breakpoint = JDIDebugModel.createLineBreakpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)type), (String)type.getFullyQualifiedName(), (int)this.getLineNumber(), (int)-1, (int)-1, (int)1, (boolean)false, attributes);
            }
            catch (CoreException ce) {
                ExceptionHandler.handle(ce, ActionMessages.getString("RunToLine.error.title1"), ActionMessages.getString("RunToLine.error.message1"));
                return;
            }
            target.breakpointAdded((IBreakpoint)breakpoint);
            IThread[] threads = target.getThreads();
            int i = 0;
            while (i < threads.length) {
                IThread thread = threads[i];
                if (thread.canResume()) {
                    try {
                        thread.resume();
                    }
                    catch (DebugException de) {
                        JDIDebugUIPlugin.log(de);
                    }
                    break;
                }
                ++i;
            }
        }
        catch (DebugException de) {
            ExceptionHandler.handle((CoreException)((Object)de), ActionMessages.getString("RunToLine.error.title1"), ActionMessages.getString("RunToLine.error.message1"));
        }
    }

    protected IDebugTarget getContext() throws DebugException {
        IDebugTarget target = this.getContextFromUI();
        if (target == null) {
            target = this.getContextFromModel();
            return target;
        }
        if (target == null) {
            return null;
        }
        if (target.getLaunch().getAttribute(ScrapbookLauncher.SCRAPBOOK_LAUNCH) != null) {
            return null;
        }
        IThread[] threads = target.getThreads();
        int i = 0;
        while (i < threads.length) {
            IThread thread = threads[i];
            if (thread.canResume()) {
                return target;
            }
            ++i;
        }
        return null;
    }

    protected IDebugTarget getContextFromModel() throws DebugException {
        IDebugTarget[] dts = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int i = 0;
        while (i < dts.length) {
            IDebugTarget dt = dts[i];
            if (this.getContextFromDebugTarget(dt) != null) {
                return dt;
            }
            ++i;
        }
        return null;
    }

    protected IDebugTarget getContextFromThread(IThread thread) throws DebugException {
        if (thread.isSuspended()) {
            return thread.getDebugTarget();
        }
        return null;
    }

    protected IDebugTarget getContextFromUI() throws DebugException {
        IAdaptable de = DebugUITools.getDebugContext();
        if (de != null) {
            if (de instanceof IThread) {
                return this.getContextFromThread((IThread)de);
            }
            if (de instanceof IDebugElement) {
                return ((IDebugElement)de).getDebugTarget();
            }
        }
        return null;
    }

    protected void update() {
        this.setEnabledState(this.getTextEditor());
    }

    protected IDebugTarget getContextFromDebugTarget(IDebugTarget dt) throws DebugException {
        if (dt.isTerminated() || dt.isDisconnected()) {
            return null;
        }
        IThread[] threads = dt.getThreads();
        int i = 0;
        while (i < threads.length) {
            IThread thread = threads[i];
            if (thread.isSuspended()) {
                return dt;
            }
            ++i;
        }
        return null;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setAction(action);
        if (targetEditor instanceof ITextEditor) {
            this.setTextEditor((ITextEditor)targetEditor);
        }
        if (!action.isEnabled()) {
            return;
        }
        this.setEnabledState(this.getTextEditor());
    }

    protected void initialize(IAction action) {
        boolean enabled = action.isEnabled();
        super.initialize(action);
        action.setEnabled(enabled);
    }
}

