/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.ui.JavaUISourceLocator;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.launching.sourcelookup.IJavaSourceLocation;
import org.eclipse.jdt.launching.sourcelookup.JavaSourceLocator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;

public abstract class OpenTypeAction
extends ObjectActionDelegate {
    static /* synthetic */ Class class$0;

    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        Iterator iterator = selection.iterator();
        try {
            while (iterator.hasNext()) {
                Object element = iterator.next();
                this.doAction(element);
            }
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    protected abstract IDebugElement getDebugElement(IAdaptable var1);

    protected abstract String getTypeNameToOpen(IDebugElement var1) throws DebugException;

    protected void doAction(Object e) throws DebugException {
        IAdaptable element = (IAdaptable)e;
        IDebugElement dbgElement = this.getDebugElement(element);
        if (dbgElement != null) {
            Object sourceElement = this.getSourceElement(dbgElement);
            if (sourceElement == null) {
                try {
                    String typeName = this.getTypeNameToOpen(dbgElement);
                    sourceElement = this.findTypeInWorkspace(typeName);
                }
                catch (CoreException x) {
                    JDIDebugUIPlugin.log(x);
                }
            }
            if (sourceElement != null) {
                this.openInEditor(sourceElement);
            }
        }
    }

    protected void openInEditor(Object sourceElement) {
        try {
            IEditorPart part = EditorUtility.openInEditor((Object)sourceElement);
            if (part != null && sourceElement instanceof IJavaElement) {
                EditorUtility.revealInEditor((IEditorPart)part, (IJavaElement)((IJavaElement)sourceElement));
            }
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    protected IType findTypeInWorkspace(String typeName) throws JavaModelException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
        int i = 0;
        while (i < projects.length) {
            IType type = this.findType(projects[i], typeName);
            if (type != null) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private IType findType(IJavaProject jproject, String fullyQualifiedName) throws JavaModelException {
        String pathStr = String.valueOf(fullyQualifiedName.replace('.', '/')) + ".java";
        IJavaElement jelement = jproject.findElement((IPath)new Path(pathStr));
        if (jelement == null) {
            IType res;
            IType type;
            String qualifier = Signature.getQualifier((String)fullyQualifiedName);
            if (qualifier.length() > 0 && (type = this.findType(jproject, qualifier)) != null && (res = type.getType(Signature.getSimpleName((String)fullyQualifiedName))).exists()) {
                return res;
            }
        } else {
            if (jelement.getElementType() == 5) {
                String simpleName = Signature.getSimpleName((String)fullyQualifiedName);
                return ((ICompilationUnit)jelement).getType(simpleName);
            }
            if (jelement.getElementType() == 6) {
                return ((IClassFile)jelement).getType();
            }
        }
        return null;
    }

    protected Object getSourceElement(Object e) {
        if (e instanceof IDebugElement) {
            JavaUISourceLocator javaSourceLocator;
            IStackFrame stackFrame;
            IDebugElement de = (IDebugElement)e;
            ISourceLocator sourceLocator = de.getLaunch().getSourceLocator();
            IAdaptable element = (IAdaptable)de;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((stackFrame = (IStackFrame)element.getAdapter((Class)clazz)) != null) {
                return sourceLocator.getSourceElement(stackFrame);
            }
            IJavaSourceLocation[] locations = null;
            if (sourceLocator instanceof JavaUISourceLocator) {
                javaSourceLocator = (JavaUISourceLocator)sourceLocator;
                locations = javaSourceLocator.getSourceLocations();
            } else if (sourceLocator instanceof JavaSourceLocator) {
                javaSourceLocator = (JavaSourceLocator)sourceLocator;
                locations = javaSourceLocator.getSourceLocations();
            }
            if (locations != null) {
                try {
                    String typeName = this.getTypeNameToOpen(de);
                    int i = 0;
                    while (i < locations.length) {
                        IJavaSourceLocation location = locations[i];
                        Object sourceElement = location.findSourceElement(typeName);
                        if (sourceElement != null) {
                            return sourceElement;
                        }
                        ++i;
                    }
                }
                catch (CoreException ex) {
                    JDIDebugUIPlugin.log(ex);
                }
            }
        }
        return null;
    }
}

