/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoRequestor;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.AbstractManageBreakpointActionDelegate;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ManageWatchpointActionDelegate
extends AbstractManageBreakpointActionDelegate {
    public void run(IAction action) {
        this.updateForRun();
        this.report(null);
        if (this.getBreakpoint() == null) {
            try {
                IMember element = this.getMember();
                if (element == null || !this.enableForMember(element)) {
                    this.report(ActionMessages.getString("ManageWatchpointActionDelegate.CantAdd"));
                    return;
                }
                IType type = element.getDeclaringType();
                int start = -1;
                int end = -1;
                ISourceRange range = element.getNameRange();
                if (range != null) {
                    start = range.getOffset();
                    end = start + range.getLength();
                }
                HashMap attributes = new HashMap(10);
                BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)element);
                this.setBreakpoint(this.createBreakpoint(BreakpointUtils.getBreakpointResource((IMember)type), type.getFullyQualifiedName(), element.getElementName(), -1, start, end, 0, true, attributes));
            }
            catch (JavaModelException e) {
                JDIDebugUIPlugin.log(e);
                MessageDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)ActionMessages.getString("ManageWatchpointAction.Problems_adding_watchpoint_7"), (String)ActionMessages.getString("ManageWatchpointAction.The_selected_field_is_not_visible_in_the_currently_selected_debug_context._A_stack_frame_or_suspended_thread_which_contains_the_declaring_type_of_this_field_must_be_selected_1"));
            }
            catch (CoreException x) {
                JDIDebugUIPlugin.log(x);
                MessageDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)ActionMessages.getString("ManageWatchpointAction.Problems_adding_watchpoint_7"), (String)x.getMessage());
            }
        } else {
            try {
                IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                breakpointManager.removeBreakpoint((IBreakpoint)this.getBreakpoint(), true);
            }
            catch (CoreException x) {
                JDIDebugUIPlugin.log(x);
                MessageDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)ActionMessages.getString("ManageWatchpointAction.Problems_removing_watchpoint_8"), (String)x.getMessage());
            }
        }
    }

    protected IJavaBreakpoint createBreakpoint(IResource resource, String typeName, String fieldName, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes) throws CoreException {
        return JDIDebugModel.createWatchpoint((IResource)resource, (String)typeName, (String)fieldName, (int)lineNumber, (int)charStart, (int)charEnd, (int)hitCount, (boolean)register, (Map)attributes);
    }

    protected IJavaBreakpoint getBreakpoint(IMember selectedField) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (breakpoint instanceof IJavaWatchpoint) {
                try {
                    if (this.equalFields(selectedField, (IJavaWatchpoint)breakpoint)) {
                        return (IJavaBreakpoint)breakpoint;
                    }
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
            ++i;
        }
        return null;
    }

    private boolean equalFields(IMember breakpointField, IJavaWatchpoint watchpoint) throws CoreException {
        return breakpointField.getElementName().equals(watchpoint.getFieldName()) && breakpointField.getDeclaringType().getFullyQualifiedName().equals(watchpoint.getTypeName());
    }

    protected IMember getMember(ISelection s) {
        IStructuredSelection ss;
        if (s instanceof IStructuredSelection && (ss = (IStructuredSelection)s).size() == 1) {
            Object o = ss.getFirstElement();
            if (o instanceof IField) {
                return (IField)o;
            }
            if (o instanceof IJavaFieldVariable) {
                return this.getField((IJavaFieldVariable)o);
            }
        }
        return null;
    }

    private IField getField(IJavaFieldVariable variable) {
        String varName = null;
        try {
            varName = variable.getName();
        }
        catch (DebugException x) {
            JDIDebugUIPlugin.log(x);
            return null;
        }
        List types = ManageWatchpointActionDelegate.searchForDeclaringType(variable);
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            IType type = (IType)iter.next();
            IField field = type.getField(varName);
            if (!field.exists()) continue;
            return field;
        }
        return null;
    }

    protected static List searchForDeclaringType(IJavaFieldVariable variable) {
        ArrayList<IType> types = new ArrayList<IType>();
        ILaunch launch = variable.getDebugTarget().getLaunch();
        if (launch == null) {
            return types;
        }
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        IJavaProject[] javaProjects = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (configuration != null) {
            try {
                String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                if (projectName.length() != 0) {
                    javaProjects = new IJavaProject[]{JavaCore.create((IProject)workspace.getRoot().getProject(projectName))};
                } else {
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    ArrayList<IJavaProject> projectList = new ArrayList<IJavaProject>();
                    int i = 0;
                    int numProjects = projects.length;
                    while (i < numProjects) {
                        IProject project = projects[i];
                        if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                            projectList.add(JavaCore.create((IProject)project));
                        }
                        ++i;
                    }
                    javaProjects = new IJavaProject[projectList.size()];
                    projectList.toArray(javaProjects);
                }
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        if (javaProjects == null) {
            return types;
        }
        SearchEngine engine = new SearchEngine();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope(javaProjects, (boolean)true);
        String declaringType = null;
        try {
            declaringType = variable.getDeclaringType().getName();
        }
        catch (DebugException x) {
            JDIDebugUIPlugin.log(x);
            return types;
        }
        ArrayList typeRefsFound = new ArrayList(3);
        TypeInfoRequestor requestor = new TypeInfoRequestor(typeRefsFound);
        try {
            engine.searchAllTypeNames(workspace, ManageWatchpointActionDelegate.getPackage(declaringType), ManageWatchpointActionDelegate.getTypeName(declaringType), 0, true, 5, scope, (ITypeNameRequestor)requestor, 3, null);
        }
        catch (JavaModelException x) {
            JDIDebugUIPlugin.log(x);
            return types;
        }
        Iterator iter = ((AbstractList)typeRefsFound).iterator();
        TypeInfo typeInfo = null;
        while (iter.hasNext()) {
            typeInfo = (TypeInfo)iter.next();
            try {
                types.add(typeInfo.resolveType(scope));
            }
            catch (JavaModelException jme) {
                JDIDebugUIPlugin.log(jme);
            }
        }
        return types;
    }

    protected static char[] getPackage(String fullyQualifiedName) {
        int index = fullyQualifiedName.lastIndexOf(46);
        if (index == -1) {
            return new char[0];
        }
        return fullyQualifiedName.substring(0, index).toCharArray();
    }

    protected static char[] getTypeName(String fullyQualifiedName) {
        int index = fullyQualifiedName.lastIndexOf(46);
        String typeName = fullyQualifiedName.substring(index + 1);
        int lastInnerClass = typeName.lastIndexOf(36);
        if (lastInnerClass != -1) {
            typeName = typeName.substring(lastInnerClass + 1);
        }
        return typeName.toCharArray();
    }

    protected boolean enableForMember(IMember member) {
        return member instanceof IField;
    }

    protected void setEnabledState(ITextEditor editor) {
        if (this.getAction() != null && this.getPage() != null) {
            IWorkbenchPart part = this.getPage().getActivePart();
            if (part == null) {
                this.getAction().setEnabled(false);
            } else if (part != this.getPage().getActiveEditor()) {
                ISelectionProvider sp = part.getSite().getSelectionProvider();
                this.getAction().setEnabled(sp != null && this.enableForMember(this.getMember(sp.getSelection())));
            } else if (this.getPage().getActiveEditor() instanceof ITextEditor) {
                super.setEnabledState((ITextEditor)this.getPage().getActiveEditor());
            }
        }
    }
}

