/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.AbstractManageBreakpointActionDelegate;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ManageMethodBreakpointActionDelegate
extends AbstractManageBreakpointActionDelegate {
    protected IJavaBreakpoint getBreakpoint(IMember method) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (breakpoint instanceof IJavaMethodBreakpoint) {
                IMember container = null;
                try {
                    container = BreakpointUtils.getMember((IJavaLineBreakpoint)((IJavaMethodBreakpoint)breakpoint));
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.log(e);
                    return null;
                }
                if (method.getDeclaringType().getFullyQualifiedName().equals(container.getDeclaringType().getFullyQualifiedName()) && method instanceof IMethod && container instanceof IMethod && ((IMethod)method).isSimilar((IMethod)container)) {
                    return (IJavaBreakpoint)breakpoint;
                }
            }
            ++i;
        }
        return null;
    }

    protected IMember getMember(ISelection s) {
        Object o;
        IStructuredSelection ss;
        if (s instanceof IStructuredSelection && (ss = (IStructuredSelection)s).size() == 1 && (o = ss.getFirstElement()) instanceof IMethod) {
            return (IMethod)o;
        }
        return null;
    }

    public void run(IAction action) {
        this.updateForRun();
        this.report(null);
        if (this.getBreakpoint() == null) {
            try {
                IMember member = this.getMember();
                if (member == null || !this.enableForMember(member)) {
                    this.report(ActionMessages.getString("ManageMethodBreakpointActionDelegate.CantAdd"));
                    return;
                }
                IMethod method = (IMethod)member;
                int start = -1;
                int end = -1;
                ISourceRange range = method.getNameRange();
                if (range != null) {
                    start = range.getOffset();
                    end = start + range.getLength();
                }
                HashMap attributes = new HashMap(10);
                BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)method);
                String methodName = method.getElementName();
                if (method.isConstructor()) {
                    methodName = "<init>";
                }
                IType type = method.getDeclaringType();
                String methodSignature = method.getSignature();
                if (!type.isBinary() && (methodSignature = ManageMethodBreakpointActionDelegate.resolveMethodSignature(type, methodSignature)) == null) {
                    Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, "Source method signature could not be resolved", null);
                    JDIDebugUIPlugin.errorDialog(ActionMessages.getString("ManageMethodBreakpointActionDelegate.Add_Method_Breakpoint_Failed_2"), (IStatus)status);
                    return;
                }
                this.setBreakpoint((IJavaBreakpoint)JDIDebugModel.createMethodBreakpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)method), (String)type.getFullyQualifiedName(), (String)methodName, (String)methodSignature, (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)start, (int)end, (int)0, (boolean)true, attributes));
            }
            catch (CoreException x) {
                JDIDebugUIPlugin.log(x);
                MessageDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)ActionMessages.getString("ManageMethodBreakpointAction.Problems_creating_breakpoint_7"), (String)x.getMessage());
            }
        } else {
            try {
                IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                breakpointManager.removeBreakpoint((IBreakpoint)this.getBreakpoint(), true);
            }
            catch (CoreException x) {
                JDIDebugUIPlugin.log(x);
                MessageDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)ActionMessages.getString("ManageMethodBreakpointAction.Problems_removing_breakpoint_8"), (String)x.getMessage());
            }
        }
    }

    public static String resolveMethodSignature(IType type, String methodSignature) throws JavaModelException {
        String[] parameterTypes = Signature.getParameterTypes((String)methodSignature);
        StringBuffer resolvedSig = new StringBuffer("(");
        int i = 0;
        while (i < parameterTypes.length) {
            String parameterType = parameterTypes[i];
            if (parameterType.length() > 1) {
                if (!ManageMethodBreakpointActionDelegate.generateQualifiedName(type, resolvedSig, parameterType)) {
                    return null;
                }
                resolvedSig.append(';');
            } else {
                resolvedSig.append(parameterType);
            }
            ++i;
        }
        resolvedSig.append(')');
        String returnType = Signature.getReturnType((String)methodSignature);
        if (returnType.length() > 1) {
            if (!ManageMethodBreakpointActionDelegate.generateQualifiedName(type, resolvedSig, returnType)) {
                return null;
            }
            resolvedSig.append(';');
        } else {
            resolvedSig.append(returnType);
        }
        methodSignature = resolvedSig.toString();
        return methodSignature;
    }

    protected static boolean generateQualifiedName(IType type, StringBuffer resolvedSig, String typeName) throws JavaModelException {
        int count = Signature.getArrayCount((String)typeName);
        String[][] resolvedType = type.resolveType(typeName = Signature.getElementType((String)typeName.substring(1 + count, typeName.length() - 1)));
        if (resolvedType != null && resolvedType.length == 1) {
            String[] typeNames = resolvedType[0];
            String qualifiedName = Signature.toQualifiedName((String[])typeNames);
            if (qualifiedName.startsWith(".")) {
                qualifiedName = qualifiedName.substring(1);
            }
            int j = 0;
            while (j < count) {
                resolvedSig.append('[');
                ++j;
            }
            resolvedSig.append('L');
            resolvedSig.append(qualifiedName.replace('.', '/'));
            return true;
        }
        return false;
    }

    protected boolean enableForMember(IMember member) {
        try {
            return member instanceof IMethod && !Flags.isAbstract((int)member.getFlags());
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
            return false;
        }
    }

    protected void setEnabledState(ITextEditor editor) {
        if (this.getAction() != null && this.getPage() != null) {
            IWorkbenchPart part = this.getPage().getActivePart();
            if (part == null) {
                this.getAction().setEnabled(false);
            } else if (part == this.getPage().getActiveEditor()) {
                if (this.getPage().getActiveEditor() instanceof ITextEditor) {
                    super.setEnabledState((ITextEditor)this.getPage().getActiveEditor());
                } else {
                    this.getAction().setEnabled(false);
                }
            }
        }
    }
}

