/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointLocationVerifier;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class ManageBreakpointRulerAction
extends Action
implements IUpdate {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private String fMarkerType;
    private List fMarkers;
    private String fAddLabel;
    private String fRemoveLabel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ManageBreakpointRulerAction(IVerticalRulerInfo ruler, ITextEditor editor) {
        this.fRuler = ruler;
        this.fTextEditor = editor;
        this.fMarkerType = IBreakpoint.BREAKPOINT_MARKER;
        this.fAddLabel = ActionMessages.getString("ManageBreakpointRulerAction.add.label");
        this.fRemoveLabel = ActionMessages.getString("ManageBreakpointRulerAction.remove.label");
    }

    protected IResource getResource() {
        IResource resource;
        IEditorInput input = this.fTextEditor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)input.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)input.getAdapter((Class)clazz2);
        }
        return resource;
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    public void update() {
        this.fMarkers = this.getMarkers();
        this.setText(this.fMarkers.isEmpty() ? this.fAddLabel : this.fRemoveLabel);
    }

    public void run() {
        if (this.fMarkers.isEmpty()) {
            this.addMarker();
        } else {
            this.removeMarkers(this.fMarkers);
        }
    }

    protected List getMarkers() {
        ArrayList<IMarker> breakpoints = new ArrayList<IMarker>();
        IResource resource = this.getResource();
        IDocument document = this.getDocument();
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (model != null) {
            try {
                IMarker[] markers = null;
                if (resource instanceof IFile) {
                    markers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                } else {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    markers = root.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                }
                if (markers != null) {
                    IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    int i = 0;
                    while (i < markers.length) {
                        IBreakpoint breakpoint = breakpointManager.getBreakpoint(markers[i]);
                        if (breakpoint != null && breakpointManager.isRegistered(breakpoint) && this.includesRulerLine(model.getMarkerPosition(markers[i]), document)) {
                            breakpoints.add(markers[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException x) {
                JDIDebugUIPlugin.log(x.getStatus());
            }
        }
        return breakpoints;
    }

    protected void addMarker() {
        block20: {
            IEditorInput editorInput = this.getTextEditor().getEditorInput();
            IDocument document = this.getDocument();
            int rulerLine = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
            try {
                IWorkingCopyManager manager;
                ICompilationUnit unit;
                int end;
                int start2;
                IClassFile classFile;
                BreakpointLocationVerifier bv = new BreakpointLocationVerifier();
                int lineNumber = bv.getValidBreakpointLocation(document, rulerLine);
                if (lineNumber <= 0) break block20;
                IRegion line = document.getLineInformation(lineNumber - 1);
                IType type = null;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.jdt.core.IClassFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((classFile = (IClassFile)editorInput.getAdapter((Class)clazz)) != null) {
                    type = classFile.getType();
                    if (type.getDeclaringType() != null) {
                        ISourceRange sourceRange = type.getSourceRange();
                        int offset = line.getOffset();
                        start2 = sourceRange.getOffset();
                        end = start2 + sourceRange.getLength();
                        if (offset < start2 || offset > end) {
                            IStatusLineManager manager2 = this.getTextEditor().getEditorSite().getActionBars().getStatusLineManager();
                            manager2.setErrorMessage(MessageFormat.format(ActionMessages.getString("ManageBreakpointRulerAction.Breakpoints_can_only_be_created_within_the_type_associated_with_the_editor__{0}._1"), type.getTypeQualifiedName()));
                            Display.getCurrent().beep();
                            return;
                        }
                    }
                } else if (editorInput instanceof IFileEditorInput && (unit = (manager = JavaUI.getWorkingCopyManager()).getWorkingCopy(editorInput)) != null) {
                    ICompilationUnit start2 = unit;
                    synchronized (start2) {
                        unit.reconcile();
                    }
                    IJavaElement e = unit.getElementAt(line.getOffset());
                    if (e instanceof IType) {
                        type = (IType)e;
                    } else if (e instanceof IMember) {
                        type = ((IMember)e).getDeclaringType();
                    }
                }
                if (type != null) {
                    IJavaProject project = type.getJavaProject();
                    if (type.exists() && project != null && project.isOnClasspath((IJavaElement)type) && JDIDebugModel.lineBreakpointExists((String)type.getFullyQualifiedName(), (int)lineNumber) == null) {
                        HashMap attributes = new HashMap(10);
                        start2 = line.getOffset();
                        end = start2 + line.getLength() - 1;
                        BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(attributes, (IJavaElement)type, start2, end);
                        JDIDebugModel.createLineBreakpoint((IResource)this.getBreakpointResource((IMember)type), (String)type.getFullyQualifiedName(), (int)lineNumber, (int)-1, (int)-1, (int)0, (boolean)true, attributes);
                    }
                }
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.errorDialog(ActionMessages.getString("ManageBreakpointRulerAction.error.adding.message1"), e);
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.errorDialog(ActionMessages.getString("ManageBreakpointRulerAction.error.adding.message1"), e);
            }
            catch (BadLocationException e) {
                JDIDebugUIPlugin.errorDialog(ActionMessages.getString("ManageBreakpointRulerAction.error.adding.message1"), e);
            }
        }
    }

    protected void removeMarkers(List markers) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        try {
            Iterator e = markers.iterator();
            while (e.hasNext()) {
                IBreakpoint breakpoint = breakpointManager.getBreakpoint((IMarker)e.next());
                breakpointManager.removeBreakpoint(breakpoint, true);
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog(ActionMessages.getString("ManageBreakpointRulerAction.error.removing.message1"), e);
        }
    }

    public IResource getBreakpointResource(IMember member) throws CoreException {
        IResource res;
        ICompilationUnit cu = member.getCompilationUnit();
        if (cu != null && cu.isWorkingCopy()) {
            member = (IMember)cu.getOriginal((IJavaElement)member);
        }
        if ((res = member.getUnderlyingResource()) == null) {
            res = member.getJavaProject().getProject();
        }
        return res;
    }
}

