/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.ExceptionHandler;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointLocationVerifier;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class ManageBreakpointActionDelegate
implements IWorkbenchWindowActionDelegate,
IPartListener {
    protected boolean fInitialized = false;
    private IAction fAction = null;
    private int fLineNumber;
    private IType fType = null;
    private ITextEditor fTextEditor = null;
    private IWorkbenchWindow fWorkbenchWindow = null;
    static /* synthetic */ Class class$0;

    protected void manageBreakpoint(IEditorInput editorInput) {
        IDocument document;
        BreakpointLocationVerifier bv;
        int lineNumber;
        ISelectionProvider sp = this.getTextEditor().getSelectionProvider();
        if (sp == null || this.getType() == null) {
            this.report(ActionMessages.getString("ManageBreakpointActionDelegate.No_Breakpoint"));
            return;
        }
        this.report(null);
        ISelection selection = sp.getSelection();
        if (selection instanceof ITextSelection && (lineNumber = (bv = new BreakpointLocationVerifier()).getValidBreakpointLocation(document = this.getTextEditor().getDocumentProvider().getDocument((Object)editorInput), ((ITextSelection)selection).getStartLine())) > -1) {
            try {
                IJavaLineBreakpoint breakpoint = JDIDebugModel.lineBreakpointExists((String)this.getType().getFullyQualifiedName(), (int)lineNumber);
                if (breakpoint != null) {
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
                } else {
                    try {
                        IRegion line = document.getLineInformation(lineNumber - 1);
                        HashMap attributes = new HashMap(10);
                        int start = line.getOffset();
                        int end = start + line.getLength() - 1;
                        BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(attributes, (IJavaElement)this.getType(), start, end);
                        JDIDebugModel.createLineBreakpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)this.getType()), (String)this.getType().getFullyQualifiedName(), (int)lineNumber, (int)-1, (int)-1, (int)0, (boolean)true, attributes);
                    }
                    catch (BadLocationException ble) {
                        JDIDebugUIPlugin.log(ble);
                    }
                }
            }
            catch (CoreException ce) {
                ExceptionHandler.handle(ce, ActionMessages.getString("ManageBreakpointActionDelegate.error.title1"), ActionMessages.getString("ManageBreakpointActionDelegate.error.message1"));
            }
        }
    }

    protected boolean breakpointExists(IEditorInput editorInput) {
        IType type = this.getType(editorInput);
        if (type != null) {
            try {
                return JDIDebugModel.lineBreakpointExists((String)type.getFullyQualifiedName(), (int)this.getLineNumber()) == null;
            }
            catch (CoreException ce) {
                JDIDebugUIPlugin.log(ce);
            }
        }
        return false;
    }

    protected IType getType(IEditorInput editorInput) {
        ISelection s;
        IType type = null;
        ISelectionProvider sp = this.getTextEditor().getSelectionProvider();
        if (sp != null && (s = sp.getSelection()) instanceof ITextSelection) {
            ITextSelection selection = (ITextSelection)s;
            this.setLineNumber(selection.getStartLine() + 1);
            type = this.getType();
            if (type != null && type.exists()) {
                try {
                    ISourceRange sourceRange = type.getSourceRange();
                    if (selection.getOffset() >= sourceRange.getOffset() && selection.getOffset() <= sourceRange.getOffset() + sourceRange.getLength() - 1) {
                        return type;
                    }
                }
                catch (JavaModelException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
            type = this.getType0(selection, editorInput);
        }
        return type;
    }

    protected IType getType0(ITextSelection selection, IEditorInput editorInput) {
        IMember member = ActionDelegateHelper.getDefault().getCurrentMember((ISelection)selection);
        IType type = null;
        if (member instanceof IType) {
            type = (IType)member;
        } else if (member != null) {
            type = member.getDeclaringType();
        }
        this.setType(type);
        return type;
    }

    public void run(IAction action) {
        if (this.getTextEditor() != null) {
            this.update();
            this.manageBreakpoint(this.getTextEditor().getEditorInput());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!this.fInitialized) {
            this.initialize(action);
        }
    }

    protected void initialize(IAction action) {
        IEditorPart part;
        IWorkbenchPage page;
        this.setAction(action);
        if (this.getWorkbenchWindow() != null && (page = this.getWorkbenchWindow().getActivePage()) != null && (part = page.getActiveEditor()) instanceof ITextEditor && !(part instanceof JavaSnippetEditor)) {
            this.setTextEditor((ITextEditor)part);
        }
        this.fInitialized = true;
    }

    protected void update() {
        IAction action = this.getAction();
        if (action != null && this.getTextEditor() != null) {
            this.breakpointExists(this.getTextEditor().getEditorInput());
        }
    }

    protected int getLineNumber() {
        return this.fLineNumber;
    }

    protected void setLineNumber(int lineNumber) {
        this.fLineNumber = lineNumber;
    }

    protected IType getType() {
        return this.fType;
    }

    protected void setType(IType type) {
        this.fType = type;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            if (part instanceof JavaSnippetEditor) {
                this.setTextEditor(null);
            } else {
                this.setTextEditor((ITextEditor)part);
            }
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.getTextEditor()) {
            this.setTextEditor(null);
            if (this.getAction() != null) {
                this.getAction().setEnabled(false);
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof ITextEditor && this.getTextEditor() == null && !(part instanceof JavaSnippetEditor)) {
            this.setTextEditor((ITextEditor)part);
        }
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected void setTextEditor(ITextEditor editor) {
        this.fTextEditor = editor;
        this.setType(null);
        this.setEnabledState(editor);
    }

    protected void setEnabledState(ITextEditor editor) {
        if (this.getAction() != null) {
            this.getAction().setEnabled(editor != null && (editor.getSite().getId().equals("org.eclipse.jdt.ui.ClassFileEditor") || editor.getSite().getId().equals("org.eclipse.jdt.ui.CompilationUnitEditor")));
        }
    }

    public void init(IWorkbenchWindow window) {
        this.setWorkbenchWindow(window);
        window.getPartService().addPartListener((IPartListener)this);
    }

    public void dispose() {
        this.getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.fWorkbenchWindow;
    }

    protected void setWorkbenchWindow(IWorkbenchWindow workbenchWindow) {
        this.fWorkbenchWindow = workbenchWindow;
    }

    protected void report(String message) {
        if (this.getTextEditor() != null) {
            IEditorStatusLine statusLine;
            ITextEditor iTextEditor = this.getTextEditor();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((statusLine = (IEditorStatusLine)iTextEditor.getAdapter((Class)clazz)) != null) {
                if (message != null) {
                    statusLine.setMessage(true, message, null);
                } else {
                    statusLine.setMessage(true, null, null);
                }
            }
        }
        if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
            JDIDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
        }
    }
}

