/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.JavaBreakpointPreferencePage;
import org.eclipse.jdt.internal.debug.ui.actions.JavaBreakpointPreferenceStore;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class JavaBreakpointPropertiesDialog
extends Dialog
implements IPreferencePageContainer {
    private Composite fTitleArea;
    private Label fTitleImage;
    private CLabel fMessageLabel;
    private String fMessage;
    private Color fNormalMsgAreaBackground;
    private Image fErrorMsgImage;
    private JavaBreakpointPreferencePage fPage;
    private Button fOkButton;
    protected static final String PREF_DLG_TITLE_IMG = "breakpoint_preference_dialog_title_image";
    protected static final String PREF_DLG_IMG_TITLE_ERROR = "breakpoint_preference_dialog_title_error_image";
    private Composite fPageContainer;
    private Point fMinimumPageSize = new Point(200, 200);
    private IJavaBreakpoint fBreakpoint;
    private JavaBreakpointPreferenceStore fJavaBreakpointPreferenceStore;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        ImageRegistry reg = JDIDebugUIPlugin.getDefault().getImageRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.preference.PreferenceDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        reg.put(PREF_DLG_TITLE_IMG, ImageDescriptor.createFromFile((Class)clazz, (String)"images/pref_dialog_title.gif"));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.dialogs.Dialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        reg.put(PREF_DLG_IMG_TITLE_ERROR, ImageDescriptor.createFromFile((Class)clazz2, (String)"images/message_error.gif"));
    }

    public JavaBreakpointPropertiesDialog(Shell parentShell, IJavaBreakpoint breakpoint) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.setBreakpoint(breakpoint);
        this.fJavaBreakpointPreferenceStore = new JavaBreakpointPreferenceStore();
    }

    protected void okPressed() {
        final ArrayList changedProperties = new ArrayList(5);
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                changedProperties.add(event.getProperty());
            }
        });
        this.fPage.performOk();
        this.setBreakpointProperties(changedProperties);
        super.okPressed();
    }

    protected void setBreakpointProperties(final List changedProperties) {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                boolean newEnabled = false;
                IJavaBreakpoint breakpoint = JavaBreakpointPropertiesDialog.this.getBreakpoint();
                Iterator changed = changedProperties.iterator();
                block15: while (changed.hasNext()) {
                    String property = (String)changed.next();
                    switch (property.charAt(0)) {
                        case 'A': {
                            IJavaWatchpoint jWatchpoint = (IJavaWatchpoint)breakpoint;
                            jWatchpoint.setAccess(JavaBreakpointPropertiesDialog.this.getPreferenceStore().getBoolean("ACCESS"));
                            break;
                        }
                        case 'C': {
                            switch (property.charAt(property.length() - 1)) {
                                case 'T': {
                                    IJavaExceptionBreakpoint jeBreakpoint = (IJavaExceptionBreakpoint)breakpoint;
                                    jeBreakpoint.setCaught(JavaBreakpointPropertiesDialog.this.getPreferenceStore().getBoolean("CAUGHT"));
                                    break;
                                }
                                case 'N': {
                                    IJavaLineBreakpoint lineBreakpoint = (IJavaLineBreakpoint)breakpoint;
                                    lineBreakpoint.setCondition(JavaBreakpointPropertiesDialog.this.getPreferenceStore().getString("CONDITION"));
                                    break;
                                }
                                case 'D': {
                                    IJavaLineBreakpoint lineBreakpoint = (IJavaLineBreakpoint)breakpoint;
                                    lineBreakpoint.setConditionEnabled(JavaBreakpointPropertiesDialog.this.getPreferenceStore().getBoolean("CONDITION_ENABLED"));
                                    break;
                                }
                                case 'E': {
                                    IJavaLineBreakpoint lineBreakpoint = (IJavaLineBreakpoint)breakpoint;
                                    lineBreakpoint.setConditionSuspendOnTrue(JavaBreakpointPropertiesDialog.this.getPreferenceStore().getString("CONDITION_SUSPEND_ON_TRUE") == "CONDITION_SUSPEND_ON_TRUE");
                                }
                            }
                            continue block15;
                        }
                        case 'E': {
                            newEnabled = true;
                            break;
                        }
                        case 'H': {
                            if (property.charAt(property.length() - 1) == 'T') {
                                breakpoint.setHitCount(JavaBreakpointPropertiesDialog.this.getPreferenceStore().getInt("HIT_COUNT"));
                                break;
                            }
                            if (JavaBreakpointPropertiesDialog.this.getPreferenceStore().getBoolean("HIT_COUNT_ENABLED")) {
                                if (changedProperties.contains("HIT_COUNT")) break;
                                breakpoint.setHitCount(JavaBreakpointPropertiesDialog.this.getPreferenceStore().getInt("HIT_COUNT"));
                                break;
                            }
                            breakpoint.setHitCount(0);
                            break;
                        }
                        case 'M': {
                            IJavaMethodBreakpoint jmBreakpoint;
                            char lastChar = property.charAt(property.length() - 1);
                            if (lastChar == 'T') {
                                jmBreakpoint = (IJavaMethodBreakpoint)breakpoint;
                                jmBreakpoint.setExit(JavaBreakpointPropertiesDialog.this.getPreferenceStore().getBoolean("METHOD_EXIT"));
                                break;
                            }
                            if (lastChar == 'Y') {
                                jmBreakpoint = (IJavaMethodBreakpoint)breakpoint;
                                jmBreakpoint.setEntry(JavaBreakpointPropertiesDialog.this.getPreferenceStore().getBoolean("METHOD_ENTRY"));
                                break;
                            }
                            IJavaWatchpoint jWatchpoint = (IJavaWatchpoint)breakpoint;
                            jWatchpoint.setModification(JavaBreakpointPropertiesDialog.this.getPreferenceStore().getBoolean("MODIFICATION"));
                            break;
                        }
                        case 'S': {
                            String value = JavaBreakpointPropertiesDialog.this.getPreferenceStore().getString("SUSPEND_POLICY");
                            if (value.equals("VM")) {
                                breakpoint.setSuspendPolicy(1);
                                break;
                            }
                            breakpoint.setSuspendPolicy(2);
                            break;
                        }
                        case 'U': {
                            IJavaExceptionBreakpoint jeBreakpoint = (IJavaExceptionBreakpoint)breakpoint;
                            jeBreakpoint.setUncaught(JavaBreakpointPropertiesDialog.this.getPreferenceStore().getBoolean("UNCAUGHT"));
                        }
                    }
                }
                if (newEnabled) {
                    breakpoint.setEnabled(JavaBreakpointPropertiesDialog.this.getPreferenceStore().getBoolean("ENABLED"));
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    public void setTitle(String title) {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setText(title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 1;
        composite.setFont(font);
        Composite titleComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        titleComposite.setLayout((Layout)layout);
        titleComposite.setLayoutData((Object)new GridData(768));
        titleComposite.setFont(font);
        this.createTitleArea(titleComposite);
        Label titleBarSeparator = new Label(titleComposite, 258);
        GridData gd = new GridData(768);
        titleBarSeparator.setLayoutData((Object)gd);
        this.fPageContainer = this.createPageContainer(composite);
        this.fPageContainer.setLayoutData((Object)new GridData(1808));
        this.fPage = new JavaBreakpointPreferencePage(this.getBreakpoint());
        this.fPage.setContainer(this);
        this.fPage.createControl(this.fPageContainer);
        Label separator = new Label(composite, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Composite createTitleArea(Composite parent) {
        Font font = parent.getFont();
        this.fTitleArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 2;
        Display display = parent.getDisplay();
        Color bg = JFaceColors.getBannerBackground((Display)display);
        Color fg = JFaceColors.getBannerForeground((Display)display);
        GridData layoutData = new GridData(1808);
        this.fTitleArea.setLayout((Layout)layout);
        this.fTitleArea.setLayoutData((Object)layoutData);
        this.fTitleArea.setFont(font);
        this.fTitleArea.setBackground(bg);
        this.fMessageLabel = new CLabel(this.fTitleArea, 16384);
        this.fMessageLabel.setBackground(bg);
        this.fMessageLabel.setForeground(fg);
        this.fMessageLabel.setText(" ");
        this.fMessageLabel.setFont(JFaceResources.getBannerFont());
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.bannerfont".equals(event.getProperty()) || "org.eclipse.jface.dialogfont".equals(event.getProperty())) {
                    JavaBreakpointPropertiesDialog.this.updateMessage();
                }
            }
        };
        this.fMessageLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                JFaceResources.getFontRegistry().removeListener(fontListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(fontListener);
        GridData gd = new GridData(1808);
        this.fMessageLabel.setLayoutData((Object)gd);
        this.fTitleImage = new Label(this.fTitleArea, 16384);
        this.fTitleImage.setBackground(bg);
        this.fTitleImage.setImage(JDIDebugUIPlugin.getDefault().getImageRegistry().get(PREF_DLG_TITLE_IMG));
        gd = new GridData();
        gd.horizontalAlignment = 3;
        this.fTitleImage.setLayoutData((Object)gd);
        return this.fTitleArea;
    }

    private Composite createPageContainer(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new PageLayout());
        result.setFont(parent.getFont());
        return result;
    }

    public void setMinimumPageSize(Point size) {
        this.fMinimumPageSize.x = size.x;
        this.fMinimumPageSize.y = size.y;
    }

    public void setErrorMessage(String errorMessage) {
        if (errorMessage == null) {
            if (this.fMessageLabel.getImage() != null) {
                this.fMessageLabel.setBackground(this.fNormalMsgAreaBackground);
                this.fMessageLabel.setImage(null);
                this.fTitleImage.setImage(JDIDebugUIPlugin.getDefault().getImageRegistry().get(PREF_DLG_TITLE_IMG));
                this.fTitleArea.layout(true);
            }
            this.setMessage(this.fMessage);
        } else {
            this.fMessageLabel.setText(errorMessage);
            if (this.fMessageLabel.getImage() == null) {
                if (this.fErrorMsgImage == null) {
                    this.fErrorMsgImage = JDIDebugUIPlugin.getDefault().getImageRegistry().get(PREF_DLG_IMG_TITLE_ERROR);
                }
                this.fNormalMsgAreaBackground = this.fMessageLabel.getBackground();
                this.fMessageLabel.setBackground(JFaceColors.getErrorBackground((Display)this.fMessageLabel.getDisplay()));
                this.fMessageLabel.setImage(this.fErrorMsgImage);
                this.fTitleImage.setImage(null);
                this.fTitleArea.layout(true);
            }
        }
    }

    public void setMessage(String newMessage) {
        this.fMessage = newMessage;
        if (this.fMessage == null) {
            this.fMessage = "";
        }
        if (this.fMessageLabel.getImage() == null) {
            this.fMessageLabel.setText(this.fMessage);
        }
    }

    public void updateMessage() {
        String pageMessage = this.fPage.getMessage();
        String pageErrorMessage = this.fPage.getErrorMessage();
        if (pageMessage == null && pageErrorMessage == null) {
            this.fMessageLabel.setFont(JFaceResources.getBannerFont());
        } else {
            this.fMessageLabel.setFont(JFaceResources.getDialogFont());
        }
        if (pageMessage == null) {
            this.setMessage(this.fPage.getTitle());
        } else {
            this.setMessage(pageMessage);
        }
        this.setErrorMessage(pageErrorMessage);
    }

    protected IJavaBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(IJavaBreakpoint breakpoint) {
        this.fBreakpoint = breakpoint;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fJavaBreakpointPreferenceStore;
    }

    public void updateButtons() {
        if (this.fOkButton != null) {
            this.fOkButton.setEnabled(this.fPage.isValid());
        }
    }

    public void updateTitle() {
        this.setTitle(this.fPage.getTitle());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fOkButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private class PageLayout
    extends Layout {
        PageLayout() {
        }

        public void layout(Composite composite, boolean force) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setSize(rect.width, rect.height);
                ++i;
            }
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = ((JavaBreakpointPropertiesDialog)JavaBreakpointPropertiesDialog.this).fMinimumPageSize.x;
            int y = ((JavaBreakpointPropertiesDialog)JavaBreakpointPropertiesDialog.this).fMinimumPageSize.y;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Point size = children[i].computeSize(-1, -1, force);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++i;
            }
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }
    }
}

