/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPatternBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.internal.debug.ui.BreakpointConditionCompletionProcessor;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ExceptionBreakpointFilterEditor;
import org.eclipse.jdt.internal.debug.ui.actions.InstanceFilterViewer;
import org.eclipse.jdt.internal.debug.ui.actions.ThreadFilterViewer;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavaBreakpointPreferencePage
extends FieldEditorPreferencePage {
    private Text fHitCountTextControl;
    private BooleanFieldEditor fHitCountEnabler;
    private BreakpointIntegerFieldEditor fHitCount;
    private BooleanFieldEditor fConditionEnabler;
    private BreakpointConditionFieldEditor fCondition;
    private RadioGroupFieldEditor fConditionSuspendRadio;
    private IJavaBreakpoint fBreakpoint;
    protected static final String VM_SUSPEND_POLICY = "VM";
    protected static final String THREAD_SUSPEND_POLICY = "THREAD";
    protected JavaElementLabelProvider fJavaLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);

    protected JavaBreakpointPreferencePage(IJavaBreakpoint breakpoint) {
        super(1);
        this.setBreakpoint(breakpoint);
    }

    protected void initialize() {
        super.initialize();
        this.fHitCountEnabler.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                boolean enabled = JavaBreakpointPreferencePage.this.fHitCountEnabler.getBooleanValue();
                JavaBreakpointPreferencePage.this.fHitCountTextControl.setEnabled(enabled);
                JavaBreakpointPreferencePage.this.fHitCount.refreshValidState();
                if (JavaBreakpointPreferencePage.this.fHitCount.isValid() && JavaBreakpointPreferencePage.this.fCondition != null) {
                    JavaBreakpointPreferencePage.this.fCondition.refreshValidState();
                }
                JavaBreakpointPreferencePage.this.checkState();
            }
        });
        if (this.fConditionEnabler == null) {
            return;
        }
        this.fConditionEnabler.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                boolean enabled = JavaBreakpointPreferencePage.this.fConditionEnabler.getBooleanValue();
                JavaBreakpointPreferencePage.this.fCondition.setEnabled(enabled);
                JavaBreakpointPreferencePage.this.fConditionSuspendRadio.setEnabled(enabled, JavaBreakpointPreferencePage.this.getFieldEditorParent());
                JavaBreakpointPreferencePage.this.fCondition.refreshValidState();
                if (JavaBreakpointPreferencePage.this.fCondition.isValid() && JavaBreakpointPreferencePage.this.fHitCount != null) {
                    JavaBreakpointPreferencePage.this.fHitCount.refreshValidState();
                }
                JavaBreakpointPreferencePage.this.checkState();
            }
        });
    }

    protected void createFieldEditors() {
        IJavaBreakpoint breakpoint = this.getBreakpoint();
        try {
            String typeName = breakpoint.getTypeName();
            if (typeName != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), ActionMessages.getString("JavaBreakpointPreferencePage.Type___4"), typeName));
            }
            this.createTypeSpecificLabelFieldEditors(breakpoint);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        if (breakpoint instanceof ILineBreakpoint) {
            ILineBreakpoint lBreakpoint = (ILineBreakpoint)breakpoint;
            StringBuffer lineNumber = new StringBuffer(4);
            try {
                int lNumber = lBreakpoint.getLineNumber();
                if (lNumber > 0) {
                    lineNumber.append(lNumber);
                }
            }
            catch (CoreException ce) {
                JDIDebugUIPlugin.log(ce);
            }
            if (lineNumber.length() > 0) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), ActionMessages.getString("JavaBreakpointPreferencePage.Line_Number___5"), lineNumber.toString()));
            }
        }
        IPreferenceStore store = this.getPreferenceStore();
        try {
            store.setValue("ENABLED", breakpoint.isEnabled());
            int hitCount = breakpoint.getHitCount();
            if (hitCount > 0) {
                store.setValue("HIT_COUNT", hitCount);
                store.setValue("HIT_COUNT_ENABLED", true);
            } else {
                store.setValue("HIT_COUNT_ENABLED", false);
            }
            String policy = "";
            policy = breakpoint.getSuspendPolicy() == 2 ? THREAD_SUSPEND_POLICY : VM_SUSPEND_POLICY;
            store.setValue("SUSPEND_POLICY", policy);
            this.addField(this.createEnabledEditor(this.getFieldEditorParent()));
            this.createHitCountEditor(this.getFieldEditorParent());
            this.addField(this.createSuspendPolicyEditor(this.getFieldEditorParent()));
            this.createTypeSpecificFieldEditors();
            this.addField(this.createThreadFilterViewer(this.getFieldEditorParent()));
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        try {
            IJavaObject[] instances = breakpoint.getInstanceFilters();
            if (instances.length > 0) {
                this.addField(this.createInstanceFilterViewer(this.getFieldEditorParent()));
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    protected void createTypeSpecificLabelFieldEditors(IJavaBreakpoint breakpoint) throws CoreException {
        if (breakpoint instanceof IJavaLineBreakpoint) {
            IMember member = BreakpointUtils.getMember((IJavaLineBreakpoint)breakpoint);
            if (member == null) {
                return;
            }
            String label = ActionMessages.getString("JavaBreakpointPreferencePage.Member");
            String memberName = this.fJavaLabelProvider.getText((Object)member);
            if (breakpoint instanceof IJavaMethodBreakpoint) {
                label = ActionMessages.getString("JavaBreakpointPreferencePage.Method");
            } else if (breakpoint instanceof IJavaWatchpoint) {
                label = ActionMessages.getString("JavaBreakpointPreferencePage.Field");
            }
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), label, memberName));
        }
    }

    protected FieldEditor createThreadFilterViewer(Composite parent) {
        return new ThreadFilterViewer(parent, this.getBreakpoint());
    }

    protected FieldEditor createInstanceFilterViewer(Composite parent) {
        return new InstanceFilterViewer(parent, this.getBreakpoint());
    }

    protected FieldEditor createFilterEditor(Composite parent) {
        return new ExceptionBreakpointFilterEditor(parent, (IJavaExceptionBreakpoint)this.getBreakpoint());
    }

    protected void createTypeSpecificFieldEditors() throws CoreException {
        IJavaBreakpoint breakpoint = this.getBreakpoint();
        IPreferenceStore store = this.getPreferenceStore();
        if (breakpoint instanceof IJavaExceptionBreakpoint) {
            IJavaExceptionBreakpoint jeBreakpoint = (IJavaExceptionBreakpoint)breakpoint;
            this.setTitle(ActionMessages.getString("JavaBreakpointPreferencePage.Java_Exception_Breakpoint_Properties_8"));
            store.setValue("UNCAUGHT", jeBreakpoint.isUncaught());
            store.setValue("CAUGHT", jeBreakpoint.isCaught());
            this.addField(this.createUncaughtEditor(this.getFieldEditorParent()));
            this.addField(this.createCaughtEditor(this.getFieldEditorParent()));
            this.addField(this.createFilterEditor(this.getFieldEditorParent()));
        } else if (breakpoint instanceof IJavaLineBreakpoint) {
            IJavaLineBreakpoint lineBreakpoint = (IJavaLineBreakpoint)breakpoint;
            if (lineBreakpoint.supportsCondition()) {
                this.createConditionEditor(this.getFieldEditorParent());
                String condition = lineBreakpoint.getCondition();
                if (condition == null) {
                    condition = "";
                }
                store.setValue("CONDITION", condition);
                if (lineBreakpoint.isConditionEnabled()) {
                    store.setValue("CONDITION_ENABLED", true);
                } else {
                    store.setValue("CONDITION_ENABLED", false);
                }
                if (lineBreakpoint.isConditionSuspendOnTrue()) {
                    store.setValue("CONDITION_SUSPEND_ON_TRUE", "CONDITION_SUSPEND_ON_TRUE");
                } else {
                    store.setValue("CONDITION_SUSPEND_ON_TRUE", "CONDITION_SUSPEND_ON_CHANGES");
                }
            }
            if (breakpoint instanceof IJavaMethodBreakpoint) {
                IJavaMethodBreakpoint jmBreakpoint = (IJavaMethodBreakpoint)breakpoint;
                this.setTitle(ActionMessages.getString("JavaBreakpointPreferencePage.Java_Method_Breakpoint_Properties_10"));
                store.setValue("METHOD_ENTRY", jmBreakpoint.isEntry());
                store.setValue("METHOD_EXIT", jmBreakpoint.isExit());
                this.addField(this.createMethodEntryEditor(this.getFieldEditorParent()));
                this.addField(this.createMethodExitEditor(this.getFieldEditorParent()));
            } else if (breakpoint instanceof IJavaWatchpoint) {
                IJavaWatchpoint jWatchpoint = (IJavaWatchpoint)breakpoint;
                this.setTitle(ActionMessages.getString("JavaBreakpointPreferencePage.Java_Watchpoint_Properties_12"));
                store.setValue("ACCESS", jWatchpoint.isAccess());
                store.setValue("MODIFICATION", jWatchpoint.isModification());
                this.addField(this.createAccessEditor(this.getFieldEditorParent()));
                this.addField(this.createModificationEditor(this.getFieldEditorParent()));
            } else if (breakpoint instanceof IJavaPatternBreakpoint) {
                this.setTitle(ActionMessages.getString("JavaBreakpointPreferencePage.Java_Pattern_Breakpoint_Properties_14"));
            } else {
                this.setTitle(ActionMessages.getString("JavaBreakpointPreferencePage.Java_Line_Breakpoint_Properties_16"));
            }
        }
    }

    public void createControl(Composite parent) {
        super.createContents(parent);
        this.setControl((Control)this.getFieldEditorParent());
        WorkbenchHelp.setHelp((Control)parent, (String)IJavaDebugHelpContextIds.JAVA_BREAKPOINT_PREFERENCE_PAGE);
    }

    protected FieldEditor createAccessEditor(Composite parent) {
        BooleanFieldEditor bfe = new BooleanFieldEditor("ACCESS", ActionMessages.getString("JavaBreakpointPreferencePage.Access_18"), parent);
        return bfe;
    }

    protected void createHitCountEditor(Composite parent) {
        this.fHitCountEnabler = new BooleanFieldEditor("HIT_COUNT_ENABLED", ActionMessages.getString("JavaBreakpointPreferencePage.Enable_&Hit_Count_19"), parent);
        this.addField((FieldEditor)this.fHitCountEnabler);
        this.fHitCount = new BreakpointIntegerFieldEditor("HIT_COUNT", ActionMessages.getString("JavaBreakpointPreferencePage.H&it_Count__20"), parent);
        this.fHitCount.setValidRange(1, Integer.MAX_VALUE);
        this.fHitCountTextControl = this.fHitCount.getTextControl(parent);
        try {
            this.fHitCountTextControl.setEnabled(this.getBreakpoint().getHitCount() > 0);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.addField((FieldEditor)this.fHitCount);
    }

    protected void createConditionEditor(Composite parent) {
        IType type = null;
        try {
            type = BreakpointUtils.getType(this.fBreakpoint);
        }
        catch (CoreException coreException) {}
        String label = null;
        label = type == null ? ActionMessages.getString("JavaBreakpointPreferencePage.Enable_Condition_(code_assist_not_available)_1") : ActionMessages.getString("JavaBreakpointPreferencePage.Enable_condition_1");
        this.fConditionEnabler = new BooleanFieldEditor("CONDITION_ENABLED", label, parent);
        this.addField((FieldEditor)this.fConditionEnabler);
        this.fCondition = new BreakpointConditionFieldEditor("CONDITION", ActionMessages.getString("JavaBreakpointPreferencePage.Condition_2"), parent);
        this.fConditionSuspendRadio = new RadioGroupFieldEditor("CONDITION_SUSPEND_ON_TRUE", ActionMessages.getString("JavaBreakpointPreferencePage.Suspend_when_1"), 1, (String[][])new String[][]{{ActionMessages.getString("JavaBreakpointPreferencePage.condition_is___true__._2"), "CONDITION_SUSPEND_ON_TRUE"}, {ActionMessages.getString("JavaBreakpointPreferencePage.value_of_condition_change._3"), "CONDITION_SUSPEND_ON_CHANGES"}}, parent);
        try {
            boolean enabled = ((IJavaLineBreakpoint)this.getBreakpoint()).isConditionEnabled();
            this.fCondition.setEnabled(enabled);
            this.fConditionSuspendRadio.setEnabled(enabled, this.getFieldEditorParent());
        }
        catch (CoreException coreException) {}
        this.addField(this.fCondition);
        this.addField((FieldEditor)this.fConditionSuspendRadio);
    }

    protected FieldEditor createLabelEditor(Composite parent, String title, String value) {
        return new LabelFieldEditor(parent, title, value);
    }

    protected IJavaBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(IJavaBreakpoint breakpoint) {
        this.fBreakpoint = breakpoint;
    }

    protected FieldEditor createCaughtEditor(Composite parent) {
        BooleanFieldEditor bfe = new BooleanFieldEditor("CAUGHT", ActionMessages.getString("JavaBreakpointPreferencePage.&Caught_21"), parent);
        return bfe;
    }

    protected FieldEditor createEnabledEditor(Composite parent) {
        BooleanFieldEditor bfe = new BooleanFieldEditor("ENABLED", ActionMessages.getString("JavaBreakpointPreferencePage.&Enabled_22"), parent);
        return bfe;
    }

    protected FieldEditor createMethodEntryEditor(Composite parent) {
        BooleanFieldEditor bfe = new BooleanFieldEditor("METHOD_ENTRY", ActionMessages.getString("JavaBreakpointPreferencePage.E&ntry_25"), parent);
        return bfe;
    }

    protected FieldEditor createMethodExitEditor(Composite parent) {
        BooleanFieldEditor bfe = new BooleanFieldEditor("METHOD_EXIT", ActionMessages.getString("JavaBreakpointPreferencePage.E&xit_26"), parent);
        return bfe;
    }

    protected FieldEditor createModificationEditor(Composite parent) {
        BooleanFieldEditor bfe = new BooleanFieldEditor("MODIFICATION", ActionMessages.getString("JavaBreakpointPreferencePage.&Modification_27"), parent);
        return bfe;
    }

    protected FieldEditor createSuspendPolicyEditor(Composite parent) {
        RadioGroupFieldEditor editor = new RadioGroupFieldEditor("SUSPEND_POLICY", ActionMessages.getString("JavaBreakpointPreferencePage.Suspend_Policy_29"), 1, (String[][])new String[][]{{ActionMessages.getString("JavaBreakpointPreferencePage.Suspend_&Thread_30"), THREAD_SUSPEND_POLICY}, {ActionMessages.getString("JavaBreakpointPreferencePage.Suspend_&VM_31"), VM_SUSPEND_POLICY}}, parent);
        return editor;
    }

    protected FieldEditor createUncaughtEditor(Composite parent) {
        BooleanFieldEditor bfe = new BooleanFieldEditor("UNCAUGHT", ActionMessages.getString("JavaBreakpointPreferencePage.&Uncaught_32"), parent);
        return bfe;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                if (this.fHitCount != null && event.getSource() != this.fHitCount) {
                    this.fHitCount.refreshValidState();
                }
                if (this.fCondition != null && event.getSource() != this.fCondition) {
                    this.fCondition.refreshValidState();
                }
                this.checkState();
            } else {
                super.propertyChange(event);
            }
        } else {
            super.propertyChange(event);
        }
    }

    class BreakpointIntegerFieldEditor
    extends IntegerFieldEditor {
        public BreakpointIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setErrorMessage(ActionMessages.getString("BreakpointHitCountAction.Value_must_be_positive_integer"));
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void clearErrorMessage() {
            if (this.getPreferencePage() != null) {
                String message = this.getPreferencePage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class BreakpointStringFieldEditor
    extends StringFieldEditor {
        public BreakpointStringFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (this.getPreferencePage() != null) {
                String message = this.getPreferencePage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class BreakpointConditionFieldEditor
    extends FieldEditor {
        private SourceViewer fViewer;
        private BreakpointConditionCompletionProcessor fCompletionProcessor;
        private boolean fIsValid;
        private String fOldValue;
        private String fErrorMessage;
        private Composite fParent;

        public BreakpointConditionFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setDefaults();
            this.fErrorMessage = ActionMessages.getString("JavaBreakpointPreferencePage.Invalid_condition");
            this.fOldValue = "";
        }

        protected void doStore() {
            this.getPreferenceStore().setValue(this.getPreferenceName(), this.fViewer.getDocument().get());
        }

        protected void refreshValidState() {
            if (!this.fViewer.isEditable()) {
                this.clearErrorMessage();
                this.fIsValid = true;
            } else {
                String text = this.fViewer.getDocument().get();
                boolean bl = this.fIsValid = text != null && text.trim().length() > 0;
                if (!this.fIsValid) {
                    this.showErrorMessage(this.fErrorMessage);
                } else {
                    this.clearErrorMessage();
                }
            }
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (this.getPreferencePage() != null) {
                String message = this.getPreferencePage().getErrorMessage();
                if (message != null) {
                    if (this.fErrorMessage.equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            this.fParent = parent;
            this.getLabelControl(parent).setLayoutData((Object)new GridData(2));
            this.fViewer = new SourceViewer(parent, null, 2816);
            this.fViewer.setInput((Object)parent);
            JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
            Document document = new Document();
            IDocumentPartitioner partitioner = tools.createDocumentPartitioner();
            document.setDocumentPartitioner(partitioner);
            partitioner.connect((IDocument)document);
            this.fViewer.configure((SourceViewerConfiguration)new DisplayViewerConfiguration(this){
                private final /* synthetic */ BreakpointConditionFieldEditor this$1;
                {
                    this.this$1 = breakpointConditionFieldEditor;
                }

                public IContentAssistProcessor getContentAssistantProcessor() {
                    return BreakpointConditionFieldEditor.access$0(this.this$1);
                }
            });
            this.fViewer.setEditable(true);
            this.fViewer.setDocument((IDocument)document);
            this.fViewer.getTextWidget().setFont(JFaceResources.getTextFont());
            Control control = this.fViewer.getControl();
            GridData gd = new GridData(1808);
            gd.horizontalSpan = numColumns - 1;
            control.setLayoutData((Object)gd);
            this.fViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(this){
                private final /* synthetic */ BreakpointConditionFieldEditor this$1;
                {
                    this.this$1 = breakpointConditionFieldEditor;
                }

                public void verifyKey(VerifyEvent event) {
                    if (event.stateMask == 262144 && event.keyCode == 0 && event.character == ' ') {
                        BreakpointConditionFieldEditor.access$1(this.this$1).doOperation(13);
                        event.doit = false;
                    }
                }
            });
            this.fViewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(this){
                private final /* synthetic */ BreakpointConditionFieldEditor this$1;
                {
                    this.this$1 = breakpointConditionFieldEditor;
                }

                public void keyReleased(KeyEvent e) {
                    this.this$1.valueChanged();
                }
            });
        }

        protected void adjustForNumColumns(int numColumns) {
            GridData gd = (GridData)this.fViewer.getControl().getLayoutData();
            gd.horizontalSpan = numColumns - 1;
            gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
        }

        protected void doLoad() {
            this.fViewer.getDocument().set(this.getPreferenceStore().getString(this.getPreferenceName()));
            this.valueChanged();
        }

        protected void doLoadDefault() {
            this.fViewer.getDocument().set(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
            this.valueChanged();
        }

        public int getNumberOfControls() {
            return 0;
        }

        private BreakpointConditionCompletionProcessor getCompletionProcessor() {
            if (this.fCompletionProcessor == null) {
                this.fCompletionProcessor = new BreakpointConditionCompletionProcessor(null);
            }
            return this.fCompletionProcessor;
        }

        public void setDefaults() {
            IType type = null;
            try {
                type = BreakpointUtils.getType(JavaBreakpointPreferencePage.this.fBreakpoint);
            }
            catch (CoreException coreException) {}
            if (type != null) {
                try {
                    this.getCompletionProcessor().setType(type);
                    String source = null;
                    ICompilationUnit compilationUnit = type.getCompilationUnit();
                    if (compilationUnit != null) {
                        source = compilationUnit.getSource();
                    } else {
                        IClassFile classFile = type.getClassFile();
                        if (classFile != null) {
                            source = classFile.getSource();
                        }
                    }
                    int lineNumber = JavaBreakpointPreferencePage.this.fBreakpoint.getMarker().getAttribute("lineNumber", -1);
                    int position = -1;
                    if (source != null && lineNumber != -1) {
                        try {
                            position = new Document(source).getLineOffset(lineNumber - 1);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    this.getCompletionProcessor().setPosition(position);
                }
                catch (CoreException coreException) {}
            }
            GridData gd = (GridData)this.fViewer.getControl().getLayoutData();
            gd.heightHint = JavaBreakpointPreferencePage.this.convertHeightInCharsToPixels(10);
            gd.widthHint = JavaBreakpointPreferencePage.this.convertWidthInCharsToPixels(40);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled, this.fParent);
            this.fViewer.setEditable(enabled);
            Color color = null;
            color = enabled ? this.fViewer.getControl().getDisplay().getSystemColor(25) : this.fViewer.getControl().getDisplay().getSystemColor(22);
            this.fViewer.getTextWidget().setBackground(color);
            this.valueChanged();
        }

        public boolean isValid() {
            return this.fIsValid;
        }

        public void valueChanged() {
            String newValue;
            boolean oldState = this.fIsValid;
            this.refreshValidState();
            if (this.fIsValid != oldState) {
                this.fireStateChanged("field_editor_is_valid", oldState, this.fIsValid);
            }
            if (!(newValue = this.fViewer.getDocument().get()).equals(this.fOldValue)) {
                this.fireValueChanged("field_editor_value", this.fOldValue, newValue);
                this.fOldValue = newValue;
            }
        }

        static /* synthetic */ BreakpointConditionCompletionProcessor access$0(BreakpointConditionFieldEditor breakpointConditionFieldEditor) {
            return breakpointConditionFieldEditor.getCompletionProcessor();
        }

        static /* synthetic */ SourceViewer access$1(BreakpointConditionFieldEditor breakpointConditionFieldEditor) {
            return breakpointConditionFieldEditor.fViewer;
        }
    }

    class LabelFieldEditor
    extends FieldEditor {
        private Label fTitleLabel;
        private Label fValueLabel;
        private Composite fBasicComposite;
        private String fValue;
        private String fTitle;

        public LabelFieldEditor(Composite parent, String title, String value) {
            this.fValue = value;
            this.fTitle = title;
            this.createControl(parent);
        }

        protected void adjustForNumColumns(int numColumns) {
            ((GridData)this.fBasicComposite.getLayoutData()).horizontalSpan = numColumns;
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            Font font = parent.getFont();
            this.fBasicComposite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.numColumns = 2;
            this.fBasicComposite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.horizontalAlignment = 4;
            this.fBasicComposite.setLayoutData((Object)data);
            this.fTitleLabel = new Label(this.fBasicComposite, 0);
            this.fTitleLabel.setText(this.fTitle);
            GridData gd = new GridData();
            gd.verticalAlignment = 128;
            this.fTitleLabel.setLayoutData((Object)gd);
            this.fTitleLabel.setFont(font);
            this.fValueLabel = new Label(this.fBasicComposite, 64);
            this.fValueLabel.setText(this.fValue);
            gd = new GridData();
            this.fValueLabel.setLayoutData((Object)gd);
            this.fValueLabel.setFont(font);
        }

        public int getNumberOfControls() {
            return 1;
        }

        protected void doLoad() {
        }

        protected void doLoadDefault() {
        }

        protected void doStore() {
        }
    }
}

