/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class InstanceFilterViewer
extends FieldEditor {
    private IJavaBreakpoint fBreakpoint;
    private CheckboxTableViewer fInstanceViewer;
    private Composite fOuter;
    private InstanceFilterContentProvider fContentProvider;
    private CheckHandler fCheckHandler;

    public InstanceFilterViewer(Composite parent, IJavaBreakpoint breakpoint) {
        this.fBreakpoint = breakpoint;
        this.fContentProvider = new InstanceFilterContentProvider();
        this.fCheckHandler = new CheckHandler();
        this.init("INSTANCE_FILTER", ActionMessages.getString("InstanceFilterViewer.Restricted_to_Selected_Ob&ject(s)_1"));
        this.createControl(parent);
    }

    protected void createViewer() {
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.fInstanceViewer = CheckboxTableViewer.newCheckList((Composite)this.fOuter, (int)2048);
        this.fInstanceViewer.addCheckStateListener((ICheckStateListener)this.fCheckHandler);
        this.fInstanceViewer.getTable().setLayoutData((Object)data);
        this.fInstanceViewer.setContentProvider((IContentProvider)this.fContentProvider);
        IDebugModelPresentation pres = DebugUITools.newDebugModelPresentation();
        pres.setAttribute("DISPLAY_QUALIFIED_NAMES", (Object)new Boolean(true));
        this.fInstanceViewer.setLabelProvider((IBaseLabelProvider)pres);
        this.fInstanceViewer.setInput((Object)this.fBreakpoint);
        this.setInitialCheckedState();
    }

    protected void setInitialCheckedState() {
        try {
            IJavaObject[] objects = this.fBreakpoint.getInstanceFilters();
            int i = 0;
            while (i < objects.length) {
                this.fCheckHandler.checkObject(objects[i], true);
                ++i;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.fOuter.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.fOuter = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = numColumns;
        this.fOuter.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.fOuter.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = numColumns;
        this.getLabelControl(this.fOuter).setLayoutData((Object)data);
        this.createViewer();
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
        try {
            IJavaObject[] objects = this.fBreakpoint.getInstanceFilters();
            int i = 0;
            while (i < objects.length) {
                if (!this.fInstanceViewer.getChecked((Object)objects[i])) {
                    this.fBreakpoint.removeInstanceFilter(objects[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    public int getNumberOfControls() {
        return 1;
    }

    class CheckHandler
    implements ICheckStateListener {
        CheckHandler() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            InstanceFilterViewer.this.fInstanceViewer.setChecked(event.getElement(), event.getChecked());
        }

        public void checkObject(IJavaObject object, boolean checked) {
            InstanceFilterViewer.this.fInstanceViewer.setChecked((Object)object, checked);
        }
    }

    class InstanceFilterContentProvider
    implements ITreeContentProvider {
        InstanceFilterContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof IJavaBreakpoint) {
                try {
                    return ((IJavaBreakpoint)parent).getInstanceFilters();
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IJavaObject) {
                return InstanceFilterViewer.this.fBreakpoint;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IJavaBreakpoint) {
                return this.getChildren(element).length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

