/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.EvaluateAction;
import org.eclipse.jdt.internal.debug.ui.display.IDataDisplay;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class InspectAction
extends EvaluateAction {
    protected void displayResult(final IEvaluationResult result) {
        final IJavaValue value = result.getValue();
        final Display display = JDIDebugUIPlugin.getStandardDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (!display.isDisposed()) {
                    InspectAction.this.showExpressionView();
                    JavaInspectExpression exp = new JavaInspectExpression(result.getSnippet().trim(), value);
                    DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)exp);
                }
                InspectAction.this.evaluationCleanup();
            }
        });
    }

    protected void showExpressionView() {
        if (this.getTargetPart().getSite().getId().equals("org.eclipse.debug.ui.ExpressionView")) {
            return;
        }
        IWorkbenchPage page = JDIDebugUIPlugin.getActivePage();
        if (page != null) {
            IViewPart part = page.findView("org.eclipse.debug.ui.ExpressionView");
            if (part == null) {
                try {
                    page.showView("org.eclipse.debug.ui.ExpressionView");
                }
                catch (PartInitException e) {
                    this.reportError(e.getStatus().getMessage());
                }
            } else {
                page.bringToTop((IWorkbenchPart)part);
            }
        }
    }

    protected void run() {
        IWorkbenchPart part = this.getTargetPart();
        if (part instanceof JavaSnippetEditor) {
            ((JavaSnippetEditor)part).evalSelection(3);
            return;
        }
        Object selection = this.getSelectedObject();
        if (!(selection instanceof IStructuredSelection)) {
            super.run();
            return;
        }
        Iterator variables = ((IStructuredSelection)selection).iterator();
        while (variables.hasNext()) {
            IJavaVariable var = (IJavaVariable)variables.next();
            try {
                JavaInspectExpression expr = new JavaInspectExpression(var.getName(), (IJavaValue)var.getValue());
                DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)expr);
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.errorDialog(ActionMessages.getString("InspectAction.Exception_occurred_inspecting_variable"), e);
            }
        }
        this.showExpressionView();
    }

    protected IDataDisplay getDataDisplay() {
        return this.getDirectDataDisplay();
    }
}

