/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.internal.debug.ui.ExceptionHandler;
import org.eclipse.jdt.internal.debug.ui.Filter;
import org.eclipse.jdt.internal.debug.ui.FilterLabelProvider;
import org.eclipse.jdt.internal.debug.ui.FilterViewerSorter;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ExceptionBreakpointFilterEditor
extends FieldEditor {
    private IJavaExceptionBreakpoint fBreakpoint;
    private Button fAddFilterButton;
    private Button fAddPackageButton;
    private Button fAddTypeButton;
    private Button fRemoveFilterButton;
    private Text fEditorText;
    private String fInvalidEditorText = null;
    private TableEditor fTableEditor;
    private TableItem fNewTableItem;
    private Filter fNewFilter;
    private CheckboxTableViewer fFilterViewer;
    private Table fFilterTable;
    private Composite fOuter;
    private FilterContentProvider fFilterContentProvider;
    protected static final String DEFAULT_PACKAGE = "(default package)";

    public ExceptionBreakpointFilterEditor(Composite parent, IJavaExceptionBreakpoint breakpoint) {
        this.fBreakpoint = breakpoint;
        this.init("EXCEPTION_FILTER", ActionMessages.getString("ExceptionBreakpointFilterEditor.Re&strict_to_Selected_Location(s)__nChecked_locations_are_inclusive_(stop_in_the_specified_location)_nUnchecked_locations_are_exclusive_(do_not_stop_in_the_specified_location)_1"));
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.fOuter.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.fOuter = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fOuter.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        this.fOuter.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = numColumns;
        this.getLabelControl(this.fOuter).setLayoutData((Object)gd);
        this.fFilterTable = new Table(this.fOuter, 67618);
        TableLayout tableLayout = new TableLayout();
        ColumnLayoutData[] columnLayoutData = new ColumnLayoutData[]{new ColumnWeightData(100)};
        tableLayout.addColumnData(columnLayoutData[0]);
        this.fFilterTable.setLayout((Layout)tableLayout);
        new TableColumn(this.fFilterTable, 0);
        this.fFilterViewer = new CheckboxTableViewer(this.fFilterTable);
        this.fTableEditor = new TableEditor(this.fFilterTable);
        this.fFilterViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.fFilterViewer.setSorter((ViewerSorter)new FilterViewerSorter());
        this.fFilterContentProvider = new FilterContentProvider(this.fFilterViewer);
        this.fFilterViewer.setContentProvider((IContentProvider)this.fFilterContentProvider);
        this.fFilterViewer.setInput((Object)this);
        gd = new GridData(1808);
        gd.widthHint = 100;
        this.fFilterViewer.getTable().setLayoutData((Object)gd);
        this.fFilterViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Filter filter = (Filter)event.getElement();
                ExceptionBreakpointFilterEditor.this.fFilterContentProvider.toggleFilter(filter);
            }
        });
        this.fFilterViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    ExceptionBreakpointFilterEditor.this.fRemoveFilterButton.setEnabled(false);
                } else {
                    ExceptionBreakpointFilterEditor.this.fRemoveFilterButton.setEnabled(true);
                }
            }
        });
        this.fFilterViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    ExceptionBreakpointFilterEditor.this.removeFilters();
                }
            }
        });
        this.createFilterButtons(this.fOuter);
    }

    private void createFilterButtons(Composite container) {
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddFilterButton = new Button(buttonContainer, 8);
        this.fAddFilterButton.setText(ActionMessages.getString("ExceptionBreakpointFilterEditor.&Add_2"));
        this.fAddFilterButton.setToolTipText(ActionMessages.getString("ExceptionBreakpointFilterEditor.Key_in_the_name_of_a_new_scope_expression_3"));
        gd = new GridData(770);
        this.fAddFilterButton.setLayoutData((Object)gd);
        this.fAddFilterButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                ExceptionBreakpointFilterEditor.this.editFilter();
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        this.fAddTypeButton = new Button(buttonContainer, 8);
        this.fAddTypeButton.setText(ActionMessages.getString("ExceptionBreakpointFilterEditor.Add_&Class_4"));
        this.fAddTypeButton.setToolTipText(ActionMessages.getString("ExceptionBreakpointFilterEditor.Choose_a_Java_Class_to_Add_It_to_the_Breakpoint_Scope_5"));
        gd = this.getButtonGridData(this.fAddTypeButton);
        this.fAddTypeButton.setLayoutData((Object)gd);
        this.fAddTypeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                ExceptionBreakpointFilterEditor.this.addType();
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        this.fAddPackageButton = new Button(buttonContainer, 8);
        this.fAddPackageButton.setText(ActionMessages.getString("ExceptionBreakpointFilterEditor.Add_&Package_6"));
        this.fAddPackageButton.setToolTipText(ActionMessages.getString("ExceptionBreakpointFilterEditor.Choose_a_Package_to_Add_to_the_Breakpoint_Scope_7"));
        gd = this.getButtonGridData(this.fAddPackageButton);
        this.fAddPackageButton.setLayoutData((Object)gd);
        this.fAddPackageButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                ExceptionBreakpointFilterEditor.this.addPackage();
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        this.fRemoveFilterButton = new Button(buttonContainer, 8);
        this.fRemoveFilterButton.setText(ActionMessages.getString("ExceptionBreakpointFilterEditor.&Remove_8"));
        this.fRemoveFilterButton.setToolTipText(ActionMessages.getString("ExceptionBreakpointFilterEditor.Remove_all_selected_scoping_elements_9"));
        gd = this.getButtonGridData(this.fRemoveFilterButton);
        this.fRemoveFilterButton.setLayoutData((Object)gd);
        this.fRemoveFilterButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                ExceptionBreakpointFilterEditor.this.removeFilters();
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        this.fRemoveFilterButton.setEnabled(false);
    }

    private GridData getButtonGridData(Button button) {
        GridData gd = new GridData(770);
        GC gc = new GC((Drawable)button);
        gc.setFont(button.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        gd.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        gd.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)14);
        return gd;
    }

    private void editFilter() {
        if (this.fEditorText != null) {
            this.validateChangeAndCleanup();
        }
        this.fNewFilter = this.fFilterContentProvider.addFilter("");
        this.fNewTableItem = this.fFilterTable.getItem(0);
        int textStyles = 16388;
        if (!SWT.getPlatform().equals("motif")) {
            textStyles |= 0x800;
        }
        this.fEditorText = new Text((Composite)this.fFilterTable, textStyles);
        GridData gd = new GridData(1808);
        this.fEditorText.setLayoutData((Object)gd);
        this.fTableEditor.horizontalAlignment = 16384;
        this.fTableEditor.grabHorizontal = true;
        this.fTableEditor.setEditor((Control)this.fEditorText, this.fNewTableItem, 0);
        this.fEditorText.setText(this.fNewFilter.getName());
        this.fEditorText.selectAll();
        this.setEditorListeners(this.fEditorText);
        this.fEditorText.setFocus();
    }

    private void setEditorListeners(Text text) {
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\r') {
                    if (ExceptionBreakpointFilterEditor.this.fInvalidEditorText != null) {
                        ExceptionBreakpointFilterEditor.this.fEditorText.setText(ExceptionBreakpointFilterEditor.this.fInvalidEditorText);
                        ExceptionBreakpointFilterEditor.this.fInvalidEditorText = null;
                    } else {
                        ExceptionBreakpointFilterEditor.this.validateChangeAndCleanup();
                    }
                } else if (event.character == '\u001b') {
                    ExceptionBreakpointFilterEditor.this.removeNewFilter();
                    ExceptionBreakpointFilterEditor.this.cleanupEditor();
                }
            }
        });
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                if (ExceptionBreakpointFilterEditor.this.fInvalidEditorText != null) {
                    ExceptionBreakpointFilterEditor.this.fEditorText.setText(ExceptionBreakpointFilterEditor.this.fInvalidEditorText);
                    ExceptionBreakpointFilterEditor.this.fInvalidEditorText = null;
                } else {
                    ExceptionBreakpointFilterEditor.this.validateChangeAndCleanup();
                }
            }
        });
        text.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
    }

    private void validateChangeAndCleanup() {
        String trimmedValue = this.fEditorText.getText().trim();
        if (trimmedValue.length() < 1) {
            this.removeNewFilter();
        } else {
            if (!this.validateEditorInput(trimmedValue)) {
                this.fInvalidEditorText = trimmedValue;
                this.fEditorText.setText(ActionMessages.getString("ExceptionBreakpointFilterEditor.Invalid_expression._Return_to_continue;_escape_to_exit_11"));
                this.fEditorText.getDisplay().beep();
                return;
            }
            Object[] filters = this.fFilterContentProvider.getElements(null);
            int i = 0;
            while (i < filters.length) {
                Filter filter = (Filter)filters[i];
                if (filter.getName().equals(trimmedValue)) {
                    this.removeNewFilter();
                    this.cleanupEditor();
                    return;
                }
                ++i;
            }
            this.fNewTableItem.setText(trimmedValue);
            this.fNewFilter.setName(trimmedValue);
            this.fFilterViewer.refresh();
        }
        this.cleanupEditor();
    }

    private boolean validateEditorInput(String trimmedValue) {
        char firstChar = trimmedValue.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar) && firstChar != '*') {
            return false;
        }
        int length = trimmedValue.length();
        int i = 1;
        while (i < length) {
            char c = trimmedValue.charAt(i);
            if (!(Character.isJavaIdentifierPart(c) || c == '.' && i != length - 1 || c == '*' && i == length - 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void cleanupEditor() {
        if (this.fEditorText != null) {
            this.fNewFilter = null;
            this.fNewTableItem = null;
            this.fTableEditor.setEditor(null, null, 0);
            this.fEditorText.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ExceptionBreakpointFilterEditor.this.fEditorText.dispose();
                    ExceptionBreakpointFilterEditor.this.fEditorText = null;
                }
            });
        }
    }

    private void removeFilters() {
        IStructuredSelection selection = (IStructuredSelection)this.fFilterViewer.getSelection();
        this.fFilterContentProvider.removeFilters(selection.toArray());
    }

    private void removeNewFilter() {
        this.fFilterContentProvider.removeFilters(new Object[]{this.fNewFilter});
    }

    private void addPackage() {
        Shell shell = this.fAddPackageButton.getDisplay().getActiveShell();
        ElementListSelectionDialog dialog = null;
        try {
            dialog = JDIDebugUIPlugin.createAllPackagesDialog(shell, null, true);
        }
        catch (JavaModelException jme) {
            String title = ActionMessages.getString("ExceptionBreakpointFilterEditor.Add_Package_to_Scope_14");
            String message = ActionMessages.getString("ExceptionBreakpointFilterEditor.Could_not_open_package_selection_dialog_for_scope_definition_13");
            ExceptionHandler.handle((CoreException)((Object)jme), title, message);
            return;
        }
        dialog.setTitle(ActionMessages.getString("ExceptionBreakpointFilterEditor.Add_Package_to_Scope_14"));
        dialog.setMessage(ActionMessages.getString("ExceptionBreakpointFilterEditor.&Select_a_package_to_add_to_the_scope_of_the_breakpoint_15"));
        dialog.setMultipleSelection(true);
        if (dialog.open() == 1) {
            return;
        }
        Object[] packages = dialog.getResult();
        if (packages != null) {
            int i = 0;
            while (i < packages.length) {
                IJavaElement pkg = (IJavaElement)packages[i];
                String filter = pkg.getElementName();
                filter = filter.length() < 1 ? DEFAULT_PACKAGE : String.valueOf(filter) + ".*";
                Filter f = this.fFilterContentProvider.addFilter(filter);
                this.fFilterContentProvider.checkFilter(f, true);
                ++i;
            }
        }
    }

    private void addType() {
        Shell shell = this.fAddTypeButton.getDisplay().getActiveShell();
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false);
        }
        catch (JavaModelException jme) {
            String title = ActionMessages.getString("ExceptionBreakpointFilterEditor.Add_Class_to_Scope_17");
            String message = ActionMessages.getString("ExceptionBreakpointFilterEditor.Could_not_open_class_selection_dialog_for_scope_definition_18");
            ExceptionHandler.handle((CoreException)((Object)jme), title, message);
            return;
        }
        dialog.setTitle(ActionMessages.getString("ExceptionBreakpointFilterEditor.Add_Class_to_Scope_17"));
        dialog.setMessage(ActionMessages.getString("ExceptionBreakpointFilterEditor.&Select_a_class_to_add_to_the_scope_of_the_breakpoint_20"));
        if (dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                IType type = (IType)types[i];
                Filter f = this.fFilterContentProvider.addFilter(type.getFullyQualifiedName());
                this.fFilterContentProvider.checkFilter(f, true);
                ++i;
            }
        }
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
        Object[] filters = this.fFilterContentProvider.getElements(null);
        ArrayList<String> inclusionFilters = new ArrayList<String>(filters.length);
        ArrayList<String> exclusionFilters = new ArrayList<String>(filters.length);
        int i = 0;
        while (i < filters.length) {
            Filter filter = (Filter)filters[i];
            String name = filter.getName();
            if (name.equals(DEFAULT_PACKAGE)) {
                name = "";
            }
            if (filter.isChecked()) {
                inclusionFilters.add(name);
            } else {
                exclusionFilters.add(name);
            }
            ++i;
        }
        try {
            this.fBreakpoint.setInclusionFilters(inclusionFilters.toArray(new String[inclusionFilters.size()]));
            this.fBreakpoint.setExclusionFilters(exclusionFilters.toArray(new String[exclusionFilters.size()]));
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected class FilterContentProvider
    implements IStructuredContentProvider {
        private CheckboxTableViewer fViewer;
        private List fFilters;

        public FilterContentProvider(CheckboxTableViewer viewer) {
            this.fViewer = viewer;
            this.populateFilters();
        }

        protected void populateFilters() {
            String[] iFilters = null;
            String[] eFilters = null;
            try {
                iFilters = ExceptionBreakpointFilterEditor.this.fBreakpoint.getInclusionFilters();
                eFilters = ExceptionBreakpointFilterEditor.this.fBreakpoint.getExclusionFilters();
            }
            catch (CoreException ce) {
                JDIDebugUIPlugin.log(ce);
                iFilters = new String[]{};
                eFilters = new String[]{};
            }
            this.fFilters = new ArrayList();
            this.populateFilters(iFilters, true);
            this.populateFilters(eFilters, false);
        }

        protected void populateFilters(String[] filters, boolean checked) {
            int i = 0;
            while (i < filters.length) {
                String name = filters[i];
                if (name.length() == 0) {
                    name = ExceptionBreakpointFilterEditor.DEFAULT_PACKAGE;
                }
                Filter filter = this.addFilter(name);
                this.checkFilter(filter, checked);
                ++i;
            }
        }

        public Filter addFilter(String name) {
            Filter filter = new Filter(name, false);
            if (!this.fFilters.contains(filter)) {
                this.fFilters.add(filter);
                this.fViewer.add((Object)filter);
            }
            return filter;
        }

        public void removeFilters(Object[] filters) {
            int i = 0;
            while (i < filters.length) {
                Filter filter = (Filter)filters[i];
                this.fFilters.remove(filter);
                ++i;
            }
            this.fViewer.remove(filters);
        }

        public void toggleFilter(Filter filter) {
            boolean newState = !filter.isChecked();
            filter.setChecked(newState);
            this.fViewer.setChecked((Object)filter, newState);
        }

        public void checkFilter(Filter filter, boolean checked) {
            filter.setChecked(checked);
            this.fViewer.setChecked((Object)filter, checked);
        }

        public Object[] getElements(Object inputElement) {
            return this.fFilters.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

