/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class BreakpointLocationVerifier {
    public int getValidBreakpointLocation(IDocument doc, int lineNumber) {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        boolean found = false;
        int start = 0;
        int length = 0;
        int token = 0;
        int lastToken = 0;
        while (!found) {
            try {
                start = doc.getLineOffset(lineNumber);
                length = doc.getLineLength(lineNumber);
                char[] txt = doc.get(start, length).toCharArray();
                scanner.setSource(txt);
                token = scanner.getNextToken();
                if (token == 167) break;
                lastToken = 0;
                while (token != 158) {
                    if (token == 309) {
                        ++lineNumber;
                        break;
                    }
                    if (token == 5) {
                        if (lastToken == 5 || this.isPrimitiveTypeToken(lastToken) || lastToken == 166) {
                            lastToken = token;
                            token = scanner.getNextToken();
                            if (token == 167) {
                                found = true;
                                break;
                            }
                        }
                        if (lastToken == 8) {
                            break;
                        }
                    } else {
                        if (this.isNonIdentifierValidToken(token)) {
                            found = true;
                            break;
                        }
                        if (lastToken == 5 && token != 15) {
                            found = true;
                            break;
                        }
                        if (lastToken == 15 && token == 166) {
                            lastToken = token;
                            token = scanner.getNextToken();
                            if (token == 64) break;
                            if (token != 167) continue;
                            found = true;
                            break;
                        }
                    }
                    lastToken = token;
                    token = scanner.getNextToken();
                }
                if (found) continue;
                ++lineNumber;
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            catch (InvalidInputException invalidInputException) {
                ++lineNumber;
            }
        }
        return lineNumber + 1;
    }

    protected boolean isPrimitiveTypeToken(int token) {
        switch (token) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return true;
            }
        }
        return false;
    }

    protected boolean isNonIdentifierValidToken(int token) {
        switch (token) {
            case 33: 
            case 34: 
            case 119: 
            case 120: 
            case 124: {
                return true;
            }
        }
        return false;
    }
}

