/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectFilter;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.launcher.RuntimeClasspathViewer;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class AddJarAction
extends RuntimeClasspathAction {
    public AddJarAction(RuntimeClasspathViewer viewer) {
        super(ActionMessages.getString("AddJarAction.Add_&JARs_1"), viewer);
    }

    public void run() {
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                int i = 0;
                while (i < selection.length) {
                    if (selection[i] instanceof IFile) {
                        IFile file = (IFile)selection[i];
                        String ext = file.getFileExtension();
                        if (!ext.equalsIgnoreCase("jar") && !ext.equalsIgnoreCase("zip")) {
                            return new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 150, ActionMessages.getString("AddJarAction.Selection_must_be_a_jar_or_zip_4"), null);
                        }
                    } else {
                        return new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 150, ActionMessages.getString("AddJarAction.Selection_must_be_a_jar_or_zip_4"), null);
                    }
                    ++i;
                }
                return new Status(0, JDIDebugPlugin.getUniqueIdentifier(), 0, "", null);
            }
        };
        ObjectFilter filter = new ObjectFilter(this.getSelectedJars());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator(validator);
        dialog.setTitle(ActionMessages.getString("AddJarAction.JAR_Selection_7"));
        dialog.setMessage(ActionMessages.getString("AddJarAction.Choose_jars_to_add__8"));
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IRuntimeClasspathEntry[] res = new IRuntimeClasspathEntry[elements.length];
            int i = 0;
            while (i < res.length) {
                IResource elem = (IResource)elements[i];
                res[i] = JavaRuntime.newArchiveRuntimeClasspathEntry((IResource)elem);
                ++i;
            }
            this.getViewer().addEntries(res);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return this.getViewer().isEnabled();
    }

    protected List getSelectedJars() {
        List list = this.getEntiresAsList();
        ArrayList<IResource> jars = new ArrayList<IResource>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IResource res;
            IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)iter.next();
            if (entry.getType() != 2 || (res = entry.getResource()) == null || !(res instanceof IFile)) continue;
            jars.add(res);
        }
        return jars;
    }
}

