/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.OpenDialogAction;
import org.eclipse.jdt.internal.debug.ui.launcher.RuntimeClasspathViewer;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;

public class AddExternalJarAction
extends OpenDialogAction {
    public AddExternalJarAction(RuntimeClasspathViewer viewer, String dialogSettingsPrefix) {
        super(ActionMessages.getString("AddExternalJar.Add_E&xternal_JARs_1"), viewer, dialogSettingsPrefix);
    }

    public void run() {
        String lastUsedPath = this.getDialogSetting("LAST_PATH_SETTING");
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(this.getShell(), 2);
        dialog.setText(ActionMessages.getString("AddExternalJar.Jar_Selection_3"));
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        Path filterPath = new Path(dialog.getFilterPath());
        IRuntimeClasspathEntry[] elems = new IRuntimeClasspathEntry[nChosen];
        int i = 0;
        while (i < nChosen) {
            IPath path = filterPath.append(fileNames[i]).makeAbsolute();
            elems[i] = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path);
            ++i;
        }
        this.setDialogSetting("LAST_PATH_SETTING", filterPath.toOSString());
        this.getViewer().addEntries(elems);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return this.getViewer().isEnabled();
    }
}

