/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.TypeInfoLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class AddExceptionDialog
extends StatusDialog {
    private static final String DIALOG_SETTINGS = "AddExceptionDialog";
    private static final String SETTING_CAUGHT_CHECKED = "caughtChecked";
    private static final String SETTING_UNCAUGHT_CHECKED = "uncaughtChecked";
    private Text fFilterText;
    private FilteredList fTypeList;
    private boolean fTypeListInitialized = false;
    private IType fResolvedType = null;
    private Button fCaughtBox;
    private Button fUncaughtBox;
    public static final int CHECKED_EXCEPTION = 0;
    public static final int UNCHECKED_EXCEPTION = 1;
    public static final int NO_EXCEPTION = -1;
    private int fExceptionType = -1;
    private boolean fIsCaughtSelected = true;
    private boolean fIsUncaughtSelected = true;
    IBreakpoint[] fBreakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugModel.getPluginIdentifier());
    private static final float TYPE_LIST_HEIGHT_PERCENT = 0.4f;
    private SelectionListener fListListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent evt) {
            AddExceptionDialog.this.validateListSelection();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            AddExceptionDialog.this.validateListSelection();
            if (AddExceptionDialog.this.getStatus().isOK()) {
                AddExceptionDialog.this.okPressed();
            }
        }
    };

    public AddExceptionDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle(ActionMessages.getString("AddExceptionDialog.title"));
    }

    protected Control createDialogArea(Composite ancestor) {
        int typeListHeight;
        Font font = ancestor.getFont();
        this.initFromDialogSettings();
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        parent.setFont(font);
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(ActionMessages.getString("AddExceptionDialog.message"));
        l.setFont(font);
        this.setFilterText(new Text(parent, 2048));
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this.getFilterText().setLayoutData((Object)data);
        this.getFilterText().setFont(font);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                AddExceptionDialog.this.getTypeList().setFilter(AddExceptionDialog.this.getFilterText().getText());
            }
        };
        this.getFilterText().addListener(24, listener);
        this.setTypeList(new FilteredList(parent, 2052, (ILabelProvider)new TypeInfoLabelProvider(2), true, false, true));
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(65);
        int displayHeight = this.getDisplayHeight();
        gd.heightHint = typeListHeight = Math.round((float)displayHeight * 0.4f);
        this.getTypeList().setLayoutData((Object)gd);
        this.setCaughtBox(new Button(parent, 32));
        this.getCaughtBox().setLayoutData((Object)new GridData());
        this.getCaughtBox().setFont(font);
        this.getCaughtBox().setText(ActionMessages.getString("AddExceptionDialog.caught"));
        this.getCaughtBox().setSelection(this.fIsCaughtSelected);
        this.setUncaughtBox(new Button(parent, 32));
        this.getUncaughtBox().setLayoutData((Object)new GridData());
        this.getUncaughtBox().setFont(font);
        this.getUncaughtBox().setText(ActionMessages.getString("AddExceptionDialog.uncaught"));
        this.getUncaughtBox().setSelection(this.isUncaughtSelected());
        this.addFromListSelected(true);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected int getDisplayHeight() {
        Display display = this.getShell().getDisplay();
        if (display == null) {
            display = Display.getDefault();
        }
        return display.getBounds().height;
    }

    protected void addFromListSelected(boolean selected) {
        this.getTypeList().setEnabled(selected);
        if (selected) {
            if (!this.isTypeListInitialized()) {
                this.initializeTypeList();
                if (!this.isTypeListInitialized()) {
                    return;
                }
            }
            this.getTypeList().addSelectionListener(this.getListListener());
        } else {
            this.getTypeList().removeSelectionListener(this.getListListener());
        }
    }

    protected void okPressed() {
        TypeInfo typeRef = (TypeInfo)this.getTypeList().getSelection()[0];
        if (this.fResolvedType == null || !typeRef.getFullyQualifiedName().equals(this.fResolvedType.getFullyQualifiedName())) {
            this.resolveType(typeRef);
            if (this.fResolvedType == null) {
                this.updateStatus((IStatus)new StatusInfo(4, MessageFormat.format(ActionMessages.getString("AddExceptionDialog.An_exception_type_could_not_be_resolved_for_{0}_1"), typeRef.getFullyQualifiedName())));
                return;
            }
        }
        this.resolveExceptionType(this.fResolvedType);
        if (this.getExceptionType() == -1) {
            this.updateStatus((IStatus)new StatusInfo(4, ActionMessages.getString("AddExceptionDialog.error.notThrowable")));
            return;
        }
        this.setIsCaughtSelected(this.getCaughtBox().getSelection());
        this.setIsUncaughtSelected(this.getUncaughtBox().getSelection());
        this.saveDialogSettings();
        super.okPressed();
    }

    protected void resolveType(TypeInfo typeRef) {
        this.fResolvedType = null;
        try {
            this.fResolvedType = typeRef.resolveType(SearchEngine.createWorkspaceScope());
        }
        catch (JavaModelException e) {
            this.updateStatus(e.getStatus());
            JDIDebugUIPlugin.log(e);
        }
    }

    private void resolveExceptionType(final IType type) {
        this.fExceptionType = -1;
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) {
                try {
                    ITypeHierarchy hierarchy = type.newSupertypeHierarchy(pm);
                    IType curr = type;
                    while (curr != null) {
                        String name = JavaModelUtil.getFullyQualifiedName((IType)curr);
                        if ("java.lang.Throwable".equals(name)) {
                            AddExceptionDialog.this.fExceptionType = 0;
                            return;
                        }
                        if ("java.lang.RuntimeException".equals(name) || "java.lang.Error".equals(name)) {
                            AddExceptionDialog.this.fExceptionType = 1;
                            return;
                        }
                        curr = hierarchy.getSuperclass(curr);
                    }
                }
                catch (JavaModelException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
        };
        try {
            context.run(false, false, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    public IType getType() {
        return this.fResolvedType;
    }

    public int getExceptionType() {
        return this.fExceptionType;
    }

    public boolean isCaughtSelected() {
        return this.fIsCaughtSelected;
    }

    public boolean isUncaughtSelected() {
        return this.fIsUncaughtSelected;
    }

    protected void initializeTypeList() {
        this.getFilterText().setText("*Exception*");
        final ArrayList results = new ArrayList();
        if (AllTypesCache.isCacheUpToDate()) {
            try {
                AllTypesCache.getTypes((IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)5, null, results);
            }
            catch (JavaModelException e) {
                JDIDebugUIPlugin.log(e);
            }
        } else {
            ProgressMonitorDialog context = new ProgressMonitorDialog(this.getShell());
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InvocationTargetException {
                    try {
                        AllTypesCache.getTypes((IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)5, (IProgressMonitor)pm, (Collection)results);
                    }
                    catch (JavaModelException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                context.run(false, false, runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        this.getTypeList().setElements(results.toArray());
        this.setTypeListInitialized(true);
    }

    private void validateListSelection() {
        StatusInfo status = new StatusInfo();
        if (this.fTypeList.getSelection().length != 1) {
            status.setError("");
            this.updateStatus((IStatus)status);
            return;
        }
        this.updateStatus((IStatus)status);
    }

    private void initFromDialogSettings() {
        IDialogSettings allSetttings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = allSetttings.getSection(DIALOG_SETTINGS);
        if (section == null) {
            section = allSetttings.addNewSection(DIALOG_SETTINGS);
            section.put(SETTING_CAUGHT_CHECKED, true);
            section.put(SETTING_UNCAUGHT_CHECKED, true);
        }
        this.setIsCaughtSelected(section.getBoolean(SETTING_CAUGHT_CHECKED));
        this.setIsUncaughtSelected(section.getBoolean(SETTING_UNCAUGHT_CHECKED));
    }

    private void saveDialogSettings() {
        IDialogSettings allSetttings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = allSetttings.getSection(DIALOG_SETTINGS);
        section.put(SETTING_CAUGHT_CHECKED, this.isCaughtSelected());
        section.put(SETTING_UNCAUGHT_CHECKED, this.isUncaughtSelected());
    }

    public void create() {
        super.create();
        this.getFilterText().setFocus();
    }

    protected Button getCaughtBox() {
        return this.fCaughtBox;
    }

    protected void setCaughtBox(Button caughtBox) {
        this.fCaughtBox = caughtBox;
    }

    protected void setExceptionType(int exceptionType) {
        this.fExceptionType = exceptionType;
    }

    protected Text getFilterText() {
        return this.fFilterText;
    }

    protected void setFilterText(Text filterText) {
        this.fFilterText = filterText;
    }

    protected void setIsCaughtSelected(boolean isCaughtSelected) {
        this.fIsCaughtSelected = isCaughtSelected;
    }

    protected void setIsUncaughtSelected(boolean isUncaughtSelected) {
        this.fIsUncaughtSelected = isUncaughtSelected;
    }

    protected SelectionListener getListListener() {
        return this.fListListener;
    }

    protected void setListListener(SelectionListener listListener) {
        this.fListListener = listListener;
    }

    protected FilteredList getTypeList() {
        return this.fTypeList;
    }

    protected void setTypeList(FilteredList typeList) {
        this.fTypeList = typeList;
    }

    protected boolean isTypeListInitialized() {
        return this.fTypeListInitialized;
    }

    protected void setTypeListInitialized(boolean typeListInitialized) {
        this.fTypeListInitialized = typeListInitialized;
    }

    protected Button getUncaughtBox() {
        return this.fUncaughtBox;
    }

    protected void setUncaughtBox(Button uncaughtBox) {
        this.fUncaughtBox = uncaughtBox;
    }
}

