/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jdt.internal.debug.ui.actions.ManageBreakpointActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractManageBreakpointActionDelegate
extends ManageBreakpointActionDelegate
implements IObjectActionDelegate {
    private IMember fMember;
    private IJavaBreakpoint fBreakpoint;
    private IWorkbenchPart fTargetPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.setTargetPart(targetPart);
    }

    protected IMember getMember() {
        return this.fMember;
    }

    protected void setMember(IMember element) {
        this.fMember = element;
    }

    protected abstract IMember getMember(ISelection var1);

    protected void updateForRun() {
        IMember member = null;
        IWorkbenchPage page = this.getPage();
        if (page != null) {
            ISelection selection = page.getSelection();
            if (selection instanceof ITextSelection) {
                member = ActionDelegateHelper.getDefault().getCurrentMember(selection);
            } else {
                member = this.getMember(selection);
                if (member != null) {
                    IJavaProject project = member.getJavaProject();
                    if (!member.exists() || project == null || !project.isOnClasspath((IJavaElement)member)) {
                        member = null;
                    }
                }
            }
        }
        this.setMember(member);
        this.update();
    }

    protected IWorkbenchPage getPage() {
        if (this.getWorkbenchWindow() != null) {
            return this.getWorkbenchWindow().getActivePage();
        }
        if (this.getTargetPart() != null) {
            return this.getTargetPart().getSite().getPage();
        }
        return null;
    }

    protected abstract IJavaBreakpoint getBreakpoint(IMember var1);

    protected void update() {
        if (this.enableForMember(this.getMember())) {
            this.setBreakpoint(this.getBreakpoint(this.getMember()));
        } else {
            this.setBreakpoint(null);
        }
    }

    protected IJavaBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(IJavaBreakpoint breakpoint) {
        this.fBreakpoint = breakpoint;
    }

    protected abstract boolean enableForMember(IMember var1);

    protected IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    protected void setTargetPart(IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
        this.setEnabledState(null);
    }

    protected void update(ISelection selection) {
        this.setEnabledState(null);
    }
}

