/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.JavaWatchExpression;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class WatchExpressionDialog
extends StatusDialog {
    private JavaWatchExpression fWatchExpression;
    private JDISourceViewer fSnippetViewer;
    private Button fCheckBox;

    public WatchExpressionDialog(Shell parent, JavaWatchExpression watchExpression, boolean editDialog) {
        super(parent);
        this.fWatchExpression = watchExpression;
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        String helpContextId = null;
        if (editDialog) {
            this.setTitle(DebugUIMessages.getString("WatchExpressionDialog.Edit_Watch_Expression_1"));
            helpContextId = IJavaDebugHelpContextIds.EDIT_WATCH_EXPRESSION_DIALOG;
        } else {
            this.setTitle(DebugUIMessages.getString("WatchExpressionDialog.Add_Watch_Expression_2"));
            helpContextId = IJavaDebugHelpContextIds.ADD_WATCH_EXPRESSION_DIALOG;
        }
        WorkbenchHelp.setHelp((Control)parent, (String)helpContextId);
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText(DebugUIMessages.getString("WatchExpressionDialog.E&xpression_3"));
        gd = new GridData(1);
        label.setLayoutData((Object)gd);
        label.setFont(font);
        this.fSnippetViewer = new JDISourceViewer(container, null, 2816);
        this.fSnippetViewer.setInput((Object)this);
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        Document document = new Document();
        IDocumentPartitioner partitioner = tools.createDocumentPartitioner();
        document.setDocumentPartitioner(partitioner);
        partitioner.connect((IDocument)document);
        this.fSnippetViewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools(), null));
        this.fSnippetViewer.setEditable(true);
        this.fSnippetViewer.setDocument((IDocument)document);
        document.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                WatchExpressionDialog.this.checkValues();
            }
        });
        this.fSnippetViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        Control control = this.fSnippetViewer.getControl();
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        control.setLayoutData((Object)gd);
        document.set(this.fWatchExpression.getExpressionText());
        this.fCheckBox = new Button(container, 16416);
        this.fCheckBox.setText(DebugUIMessages.getString("WatchExpressionDialog.&Enable_4"));
        this.fCheckBox.setSelection(this.fWatchExpression.isEnabled());
        this.fCheckBox.setFont(font);
        Dialog.applyDialogFont((Control)container);
        this.fSnippetViewer.getControl().setFocus();
        return container;
    }

    protected void okPressed() {
        this.fWatchExpression.setEnabled(this.fCheckBox.getSelection());
        this.fWatchExpression.setExpressionText(this.fSnippetViewer.getDocument().get());
        super.okPressed();
    }

    private void checkValues() {
        StatusInfo status = new StatusInfo();
        if (this.fSnippetViewer.getDocument().get().trim().length() == 0) {
            status.setError(DebugUIMessages.getString("WatchExpressionDialog.Expression_must_not_be_empty_5"));
        }
        this.updateStatus((IStatus)status);
    }
}

