/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;

public class JavaWatchExpression
extends PlatformObject
implements IExpression,
IDebugEventSetListener {
    public static final int STATUS_ENABLE = 1;
    public static final int STATUS_PENDING = 2;
    public static final int STATUS_HAS_ERROR = 4;
    public static final int STATUS_OBSOLETE = 8;
    private String fExpressionText;
    private IJavaDebugTarget fDebugTarget;
    private IJavaValue fResultValue;
    private int fStatus;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JavaWatchExpression(String expressionText) {
        this.fExpressionText = expressionText;
        this.fStatus = 1;
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public String getExpressionText() {
        return this.fExpressionText;
    }

    public IValue getValue() {
        return this.fResultValue;
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        int length = events.length;
        while (i < length) {
            DebugEvent event = events[i];
            Object source = event.getSource();
            switch (event.getKind()) {
                case 2: {
                    IJavaThread javaThread;
                    if (event.getDetail() == 128 || !(source instanceof IThread)) break;
                    IAdaptable iAdaptable = (IAdaptable)source;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.jdt.debug.core.IJavaThread");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((javaThread = (IJavaThread)iAdaptable.getAdapter((Class)clazz)) == null || !this.preEvaluationCheck(javaThread, true)) break;
                    Runnable runnable = new Runnable(){

                        public void run() {
                            DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(this, javaThread){
                                private final /* synthetic */ IJavaThread val$javaThread;
                                private final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$javaThread = iJavaThread;
                                }

                                public void run() {
                                    2.access$0(this.this$1).evaluateExpression(this.val$javaThread, true);
                                }
                            });
                        }

                        static /* synthetic */ JavaWatchExpression access$0(2 var0) {
                            return var0.JavaWatchExpression.this;
                        }
                    };
                    DebugPlugin.getDefault().asyncExec(runnable);
                    break;
                }
                case 8: {
                    IJavaDebugTarget target;
                    if (!(source instanceof IDebugTarget)) break;
                    IAdaptable iAdaptable = (IAdaptable)source;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.jdt.debug.core.IJavaDebugTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((target = (IJavaDebugTarget)iAdaptable.getAdapter((Class)clazz)) == null || !target.equals(this.fDebugTarget)) break;
                    this.fResultValue = null;
                    this.setHasError(false);
                    this.setObsolete(false);
                    this.refresh();
                }
            }
            ++i;
        }
    }

    public String getModelIdentifier() {
        return JDIDebugModel.getPluginIdentifier();
    }

    public ILaunch getLaunch() {
        return this.fDebugTarget.getLaunch();
    }

    public void evaluateExpression(IJavaThread javaThread) {
        this.evaluateExpression(javaThread, false);
    }

    public void evaluateExpression(IJavaThread javaThread, boolean implicit) {
        if (this.preEvaluationCheck(javaThread, implicit)) {
            this.fDebugTarget = (IJavaDebugTarget)javaThread.getDebugTarget();
            javaThread.queueRunnable((Runnable)new EvaluationRunnable(javaThread));
        }
    }

    private boolean preEvaluationCheck(IJavaThread javaThread, boolean implicit) {
        if (javaThread == null) {
            this.refresh();
            return false;
        }
        if (javaThread.isSuspended() && ((JDIThread)javaThread).isInvokingMethod()) {
            this.refreshForError();
            return false;
        }
        if (implicit && !this.isEnabled()) {
            if (this.fResultValue != null || this.hasError()) {
                this.setObsolete(true);
                this.refresh();
            }
            return false;
        }
        this.fResultValue = null;
        this.setHasError(false);
        this.setObsolete(false);
        this.setPending(true);
        this.refresh();
        return true;
    }

    private IJavaProject getProject(IJavaStackFrame javaStackFrame) {
        ILaunch launch = javaStackFrame.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        Object sourceElement = locator.getSourceElement((IStackFrame)javaStackFrame);
        if (sourceElement instanceof IJavaElement) {
            return ((IJavaElement)sourceElement).getJavaProject();
        }
        return null;
    }

    public boolean isEnabled() {
        return (this.fStatus & 1) != 0;
    }

    public boolean isPending() {
        return (this.fStatus & 2) != 0;
    }

    public boolean isObsolete() {
        return (this.fStatus & 8) != 0;
    }

    public boolean hasError() {
        return (this.fStatus & 4) != 0;
    }

    public int getStatus() {
        return this.fStatus;
    }

    public void setEnabled(boolean isEnabled) {
        this.setStatus(1, isEnabled);
    }

    protected void setPending(boolean isPending) {
        this.setStatus(2, isPending);
    }

    protected void setHasError(boolean hasError) {
        this.setStatus(4, hasError);
    }

    protected void setObsolete(boolean isObsolete) {
        this.setStatus(8, isObsolete);
    }

    protected void setStatus(int flag, boolean value) {
        this.fStatus = value ? (this.fStatus |= flag) : (this.fStatus &= ~flag);
    }

    public void setExpressionText(String expressionText) {
        this.fExpressionText = expressionText;
    }

    public void refresh() {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 16)});
    }

    private void refreshForError() {
        this.setHasError(true);
        this.setPending(false);
        this.refresh();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("JavaWatchExpression \"");
        result.append(this.fExpressionText).append('\"');
        if (this.isEnabled()) {
            result.append(" enabled");
        }
        if (this.hasError()) {
            result.append(" has_error");
        }
        if (this.isObsolete()) {
            result.append(" obsolete");
        }
        if (this.isPending()) {
            result.append(" pending");
        }
        return result.toString();
    }

    static /* synthetic */ void access$3(JavaWatchExpression javaWatchExpression, IJavaValue iJavaValue) {
        javaWatchExpression.fResultValue = iJavaValue;
    }

    private final class EvaluationRunnable
    implements Runnable {
        private final IJavaThread fJavaThread;

        EvaluationRunnable(IJavaThread javaThread) {
            this.fJavaThread = javaThread;
        }

        public void run() {
            IJavaProject project;
            IJavaStackFrame topStackFrame = null;
            try {
                topStackFrame = (IJavaStackFrame)this.fJavaThread.getTopStackFrame();
            }
            catch (DebugException e) {
                JDIDebugPlugin.log((Throwable)e);
                JavaWatchExpression.this.refreshForError();
                return;
            }
            if (topStackFrame == null || (project = JavaWatchExpression.this.getProject(topStackFrame)) == null) {
                JavaWatchExpression.this.refreshForError();
                return;
            }
            IAstEvaluationEngine evaluationEngine = JDIDebugUIPlugin.getDefault().getEvaluationEngine(project, JavaWatchExpression.this.fDebugTarget);
            IEvaluationListener listener = new IEvaluationListener(this){
                private final /* synthetic */ EvaluationRunnable this$1;
                {
                    this.this$1 = evaluationRunnable;
                }

                public void evaluationComplete(IEvaluationResult result) {
                    if (result.hasErrors()) {
                        EvaluationRunnable.access$0(this.this$1).setHasError(true);
                    } else {
                        JavaWatchExpression.access$3(EvaluationRunnable.access$0(this.this$1), result.getValue());
                    }
                    EvaluationRunnable.access$0(this.this$1).setPending(false);
                    EvaluationRunnable.access$0(this.this$1).refresh();
                }
            };
            try {
                evaluationEngine.evaluate(JavaWatchExpression.this.fExpressionText, topStackFrame, listener, 128, false);
            }
            catch (DebugException e) {
                JDIDebugPlugin.log((Throwable)e);
                JavaWatchExpression.this.refreshForError();
            }
        }

        static /* synthetic */ JavaWatchExpression access$0(EvaluationRunnable evaluationRunnable) {
            return evaluationRunnable.JavaWatchExpression.this;
        }
    }
}

