/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDINullValue;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDetailFormattersManager;
import org.eclipse.jdt.internal.debug.ui.actions.OpenVariableTypeAction;
import org.eclipse.ui.IActionFilter;

public class JavaVariableActionFilter
implements IActionFilter {
    private static final Set fgPrimitiveTypes = JavaVariableActionFilter.initPrimitiveTypes();

    private static Set initPrimitiveTypes() {
        HashSet<String> set = new HashSet<String>(8);
        set.add("short");
        set.add("int");
        set.add("long");
        set.add("float");
        set.add("double");
        set.add("boolean");
        set.add("byte");
        set.add("char");
        set.add("null");
        return set;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof IJavaVariable) {
            IJavaVariable var = (IJavaVariable)target;
            if (name.equals("PrimitiveVariableActionFilter")) {
                if (value.equals("isPrimitive")) {
                    return this.isPrimitiveType(var);
                }
                if (value.equals("isValuePrimitive")) {
                    return this.isValuePrimitiveType(var);
                }
            } else if (name.equals("ConcreteVariableActionFilter") && value.equals("isConcrete")) {
                try {
                    return this.isDeclaredSameAsConcrete(var);
                }
                catch (DebugException de) {
                    JDIDebugUIPlugin.log(de);
                }
            } else if (name.equals("JavaVariableActionFilter") && value.equals("instanceFilter")) {
                try {
                    return !var.isStatic() && var.getValue() instanceof IJavaObject && ((IJavaDebugTarget)var.getDebugTarget()).supportsInstanceBreakpoints();
                }
                catch (DebugException exception) {
                    JDIDebugUIPlugin.log(exception);
                }
            } else if (name.equals("DetailFormatterFilter") && value.equals("isDefined")) {
                try {
                    IValue varValue = var.getValue();
                    return varValue instanceof IJavaObject && JavaDetailFormattersManager.getDefault().hasAssociatedDetailFormatter(((IJavaObject)varValue).getJavaType());
                }
                catch (DebugException exception) {
                    JDIDebugUIPlugin.log(exception);
                }
            }
        }
        return false;
    }

    protected boolean isDeclaredSameAsConcrete(IJavaVariable var) throws DebugException {
        IValue value = var.getValue();
        if (value instanceof JDINullValue) {
            return false;
        }
        return !var.getReferenceTypeName().equals(value.getReferenceTypeName());
    }

    protected String getTypeNameToOpen(String refType) throws DebugException {
        if (fgPrimitiveTypes.contains(refType = OpenVariableTypeAction.removeArray(refType))) {
            return null;
        }
        return refType;
    }

    protected boolean isPrimitiveType(IJavaVariable var) {
        try {
            return this.getTypeNameToOpen(var.getReferenceTypeName()) != null;
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
            return false;
        }
    }

    protected boolean isValuePrimitiveType(IJavaVariable var) {
        try {
            return this.getTypeNameToOpen(var.getValue().getReferenceTypeName()) != null;
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
            return false;
        }
    }
}

