/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.ExceptionHandler;
import org.eclipse.jdt.internal.debug.ui.Filter;
import org.eclipse.jdt.internal.debug.ui.FilterLabelProvider;
import org.eclipse.jdt.internal.debug.ui.FilterViewerSorter;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavaStepFilterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DEFAULT_NEW_FILTER_TEXT = "";
    private CheckboxTableViewer fFilterViewer;
    private Table fFilterTable;
    private Button fAddPackageButton;
    private Button fAddTypeButton;
    private Button fRemoveFilterButton;
    private Button fAddFilterButton;
    private Button fFilterSyntheticButton;
    private Button fFilterStaticButton;
    private Button fFilterConstructorButton;
    private Button fEnableAllButton;
    private Button fDisableAllButton;
    private Text fEditorText;
    private String fInvalidEditorText = null;
    private TableEditor fTableEditor;
    private TableItem fNewTableItem;
    private Filter fNewStepFilter;
    private Label fTableLabel;
    private StepFilterContentProvider fStepFilterContentProvider;

    public JavaStepFilterPreferencePage() {
        this.setPreferenceStore(JDIDebugUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(DebugUIMessages.getString("JavaStepFilterPreferencePage.description"));
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IJavaDebugHelpContextIds.JAVA_STEP_FILTER_PREFERENCE_PAGE);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createStepFilterPreferences(composite);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    private void handleFilterViewerKeyPress(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            this.removeFilters();
        }
    }

    private void createStepFilterPreferences(Composite parent) {
        Font font = parent.getFont();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        container.setFont(font);
        this.fTableLabel = new Label(container, 0);
        this.fTableLabel.setText(DebugUIMessages.getString("JavaStepFilterPreferencePage.Defined_step_fi&lters__8"));
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fTableLabel.setLayoutData((Object)gd);
        this.fTableLabel.setFont(font);
        this.fFilterTable = new Table(container, 67618);
        gd = new GridData(768);
        this.fFilterTable.setLayoutData((Object)gd);
        this.fFilterTable.setFont(font);
        TableLayout tableLayout = new TableLayout();
        ColumnLayoutData[] columnLayoutData = new ColumnLayoutData[]{new ColumnWeightData(100)};
        tableLayout.addColumnData(columnLayoutData[0]);
        this.fFilterTable.setLayout((Layout)tableLayout);
        new TableColumn(this.fFilterTable, 0);
        this.fFilterViewer = new CheckboxTableViewer(this.fFilterTable);
        this.fTableEditor = new TableEditor(this.fFilterTable);
        this.fFilterViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.fFilterViewer.setSorter((ViewerSorter)new FilterViewerSorter());
        this.fStepFilterContentProvider = new StepFilterContentProvider(this.fFilterViewer);
        this.fFilterViewer.setContentProvider((IContentProvider)this.fStepFilterContentProvider);
        this.fFilterViewer.setInput((Object)this);
        gd = new GridData(1808);
        this.fFilterViewer.getTable().setLayoutData((Object)gd);
        this.fFilterViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Filter filter = (Filter)event.getElement();
                JavaStepFilterPreferencePage.this.fStepFilterContentProvider.toggleFilter(filter);
            }
        });
        this.fFilterViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    JavaStepFilterPreferencePage.this.fRemoveFilterButton.setEnabled(false);
                } else {
                    JavaStepFilterPreferencePage.this.fRemoveFilterButton.setEnabled(true);
                }
            }
        });
        this.fFilterViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                JavaStepFilterPreferencePage.this.handleFilterViewerKeyPress(event);
            }
        });
        this.createStepFilterButtons(container);
        this.createStepFilterCheckboxes(container);
    }

    private void createStepFilterCheckboxes(Composite container) {
        Font font = container.getFont();
        this.fFilterSyntheticButton = new Button(container, 32);
        this.fFilterSyntheticButton.setText(DebugUIMessages.getString("JavaStepFilterPreferencePage.Filter_s&ynthetic_methods_(requires_VM_support)_17"));
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fFilterSyntheticButton.setLayoutData((Object)gd);
        this.fFilterSyntheticButton.setFont(font);
        this.fFilterStaticButton = new Button(container, 32);
        this.fFilterStaticButton.setText(DebugUIMessages.getString("JavaStepFilterPreferencePage.Filter_static_&initializers_18"));
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fFilterStaticButton.setLayoutData((Object)gd);
        this.fFilterStaticButton.setFont(font);
        this.fFilterConstructorButton = new Button(container, 32);
        this.fFilterConstructorButton.setText(DebugUIMessages.getString("JavaStepFilterPreferencePage.Filter_co&nstructors_19"));
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fFilterConstructorButton.setLayoutData((Object)gd);
        this.fFilterConstructorButton.setFont(font);
        this.fFilterSyntheticButton.setSelection(this.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_FILTER_SYNTHETICS));
        this.fFilterStaticButton.setSelection(this.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_FILTER_STATIC_INITIALIZERS));
        this.fFilterConstructorButton.setSelection(this.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_FILTER_CONSTRUCTORS));
    }

    private void createStepFilterButtons(Composite container) {
        Font font = container.getFont();
        this.initializeDialogUnits((Control)container);
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddFilterButton = new Button(buttonContainer, 8);
        this.fAddFilterButton.setText(DebugUIMessages.getString("JavaStepFilterPreferencePage.Add_&Filter_9"));
        this.fAddFilterButton.setToolTipText(DebugUIMessages.getString("JavaStepFilterPreferencePage.Key_in_the_name_of_a_new_step_filter_10"));
        this.setButtonLayoutData(this.fAddFilterButton);
        this.fAddFilterButton.setFont(font);
        this.fAddFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaStepFilterPreferencePage.this.editFilter();
            }
        });
        this.fAddTypeButton = new Button(buttonContainer, 8);
        this.fAddTypeButton.setText(DebugUIMessages.getString("JavaStepFilterPreferencePage.Add_&Type..._11"));
        this.fAddTypeButton.setToolTipText(DebugUIMessages.getString("JavaStepFilterPreferencePage.Choose_a_Java_type_and_add_it_to_step_filters_12"));
        this.fAddTypeButton.setFont(font);
        this.setButtonLayoutData(this.fAddTypeButton);
        this.fAddTypeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaStepFilterPreferencePage.this.addType();
            }
        });
        this.fAddPackageButton = new Button(buttonContainer, 8);
        this.fAddPackageButton.setText(DebugUIMessages.getString("JavaStepFilterPreferencePage.Add_&Package..._13"));
        this.fAddPackageButton.setToolTipText(DebugUIMessages.getString("JavaStepFilterPreferencePage.Choose_a_package_and_add_it_to_step_filters_14"));
        this.fAddPackageButton.setFont(font);
        this.setButtonLayoutData(this.fAddPackageButton);
        this.fAddPackageButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaStepFilterPreferencePage.this.addPackage();
            }
        });
        this.fRemoveFilterButton = new Button(buttonContainer, 8);
        this.fRemoveFilterButton.setText(DebugUIMessages.getString("JavaStepFilterPreferencePage.&Remove_15"));
        this.fRemoveFilterButton.setToolTipText(DebugUIMessages.getString("JavaStepFilterPreferencePage.Remove_all_selected_step_filters_16"));
        this.fRemoveFilterButton.setFont(font);
        this.setButtonLayoutData(this.fRemoveFilterButton);
        this.fRemoveFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaStepFilterPreferencePage.this.removeFilters();
            }
        });
        this.fRemoveFilterButton.setEnabled(false);
        this.fEnableAllButton = new Button(buttonContainer, 8);
        this.fEnableAllButton.setText(DebugUIMessages.getString("JavaStepFilterPreferencePage.&Enable_All_1"));
        this.fEnableAllButton.setToolTipText(DebugUIMessages.getString("JavaStepFilterPreferencePage.Enables_all_step_filters_2"));
        this.fEnableAllButton.setFont(font);
        this.setButtonLayoutData(this.fEnableAllButton);
        this.fEnableAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaStepFilterPreferencePage.this.checkAllFilters(true);
            }
        });
        this.fDisableAllButton = new Button(buttonContainer, 8);
        this.fDisableAllButton.setText(DebugUIMessages.getString("JavaStepFilterPreferencePage.Disa&ble_All_3"));
        this.fDisableAllButton.setToolTipText(DebugUIMessages.getString("JavaStepFilterPreferencePage.Disables_all_step_filters_4"));
        this.fDisableAllButton.setFont(font);
        this.setButtonLayoutData(this.fDisableAllButton);
        this.fDisableAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaStepFilterPreferencePage.this.checkAllFilters(false);
            }
        });
    }

    private void checkAllFilters(boolean check) {
        Object[] filters = this.fStepFilterContentProvider.getElements(null);
        int i = 0;
        while (i != filters.length) {
            ((Filter)filters[i]).setChecked(check);
            ++i;
        }
        this.fFilterViewer.setAllChecked(check);
    }

    private void editFilter() {
        if (this.fEditorText != null) {
            this.validateChangeAndCleanup();
        }
        this.fNewStepFilter = this.fStepFilterContentProvider.addFilter(DEFAULT_NEW_FILTER_TEXT, true);
        this.fNewTableItem = this.fFilterTable.getItem(0);
        int textStyles = 16388;
        if (!SWT.getPlatform().equals("motif")) {
            textStyles |= 0x800;
        }
        this.fEditorText = new Text((Composite)this.fFilterTable, textStyles);
        GridData gd = new GridData(1808);
        this.fEditorText.setLayoutData((Object)gd);
        this.fEditorText.setFont(this.fFilterTable.getFont());
        this.fTableEditor.horizontalAlignment = 16384;
        this.fTableEditor.grabHorizontal = true;
        this.fTableEditor.setEditor((Control)this.fEditorText, this.fNewTableItem, 0);
        this.fEditorText.setText(this.fNewStepFilter.getName());
        this.fEditorText.selectAll();
        this.setEditorListeners(this.fEditorText);
        this.fEditorText.setFocus();
    }

    private void setEditorListeners(Text text) {
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\r') {
                    if (JavaStepFilterPreferencePage.this.fInvalidEditorText != null) {
                        JavaStepFilterPreferencePage.this.fEditorText.setText(JavaStepFilterPreferencePage.this.fInvalidEditorText);
                        JavaStepFilterPreferencePage.this.fInvalidEditorText = null;
                    } else {
                        JavaStepFilterPreferencePage.this.validateChangeAndCleanup();
                    }
                } else if (event.character == '\u001b') {
                    JavaStepFilterPreferencePage.this.removeNewFilter();
                    JavaStepFilterPreferencePage.this.cleanupEditor();
                }
            }
        });
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                if (JavaStepFilterPreferencePage.this.fInvalidEditorText != null) {
                    JavaStepFilterPreferencePage.this.fEditorText.setText(JavaStepFilterPreferencePage.this.fInvalidEditorText);
                    JavaStepFilterPreferencePage.this.fInvalidEditorText = null;
                } else {
                    JavaStepFilterPreferencePage.this.validateChangeAndCleanup();
                }
            }
        });
        text.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
    }

    private void validateChangeAndCleanup() {
        String trimmedValue = this.fEditorText.getText().trim();
        if (trimmedValue.length() < 1) {
            this.removeNewFilter();
        } else {
            if (!this.validateEditorInput(trimmedValue)) {
                this.fInvalidEditorText = trimmedValue;
                this.fEditorText.setText(DebugUIMessages.getString("JavaStepFilterPreferencePage.Invalid_step_filter._Return_to_continue;_escape_to_exit._1"));
                this.getShell().getDisplay().beep();
                return;
            }
            Object[] filters = this.fStepFilterContentProvider.getElements(null);
            int i = 0;
            while (i < filters.length) {
                Filter filter = (Filter)filters[i];
                if (filter.getName().equals(trimmedValue)) {
                    this.removeNewFilter();
                    this.cleanupEditor();
                    return;
                }
                ++i;
            }
            this.fNewTableItem.setText(trimmedValue);
            this.fNewStepFilter.setName(trimmedValue);
            this.fFilterViewer.refresh();
        }
        this.cleanupEditor();
    }

    private void cleanupEditor() {
        if (this.fEditorText != null) {
            this.fNewStepFilter = null;
            this.fNewTableItem = null;
            this.fTableEditor.setEditor(null, null, 0);
            this.fEditorText.dispose();
            this.fEditorText = null;
        }
    }

    private void removeNewFilter() {
        this.fStepFilterContentProvider.removeFilters(new Object[]{this.fNewStepFilter});
    }

    private boolean validateEditorInput(String trimmedValue) {
        char firstChar = trimmedValue.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar) && firstChar != '*') {
            return false;
        }
        int length = trimmedValue.length();
        int i = 1;
        while (i < length) {
            char c = trimmedValue.charAt(i);
            if (!(Character.isJavaIdentifierPart(c) || c == '.' && i != length - 1 || c == '*' && i == length - 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addType() {
        Shell shell = this.getShell();
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false);
        }
        catch (JavaModelException jme) {
            String title = DebugUIMessages.getString("JavaStepFilterPreferencePage.Add_type_to_step_filters_20");
            String message = DebugUIMessages.getString("JavaStepFilterPreferencePage.Could_not_open_type_selection_dialog_for_step_filters_21");
            ExceptionHandler.handle((CoreException)((Object)jme), title, message);
            return;
        }
        dialog.setTitle(DebugUIMessages.getString("JavaStepFilterPreferencePage.Add_type_to_step_filters_20"));
        dialog.setMessage(DebugUIMessages.getString("JavaStepFilterPreferencePage.Select_a_type_to_filter_when_stepping_23"));
        if (dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IType type = (IType)types[0];
            this.fStepFilterContentProvider.addFilter(type.getFullyQualifiedName(), true);
        }
    }

    private void addPackage() {
        Shell shell = this.getShell();
        ElementListSelectionDialog dialog = null;
        try {
            dialog = JDIDebugUIPlugin.createAllPackagesDialog(shell, null, false);
        }
        catch (JavaModelException jme) {
            String title = DebugUIMessages.getString("JavaStepFilterPreferencePage.Add_package_to_step_filters_24");
            String message = DebugUIMessages.getString("JavaStepFilterPreferencePage.Could_not_open_package_selection_dialog_for_step_filters_25");
            ExceptionHandler.handle((CoreException)((Object)jme), title, message);
            return;
        }
        dialog.setTitle(DebugUIMessages.getString("JavaStepFilterPreferencePage.Add_package_to_step_filters_24"));
        dialog.setMessage(DebugUIMessages.getString("JavaStepFilterPreferencePage.Select_a_package_to_filter_when_stepping_27"));
        dialog.setMultipleSelection(true);
        if (dialog.open() == 1) {
            return;
        }
        Object[] packages = dialog.getResult();
        if (packages != null) {
            int i = 0;
            while (i < packages.length) {
                IJavaElement pkg = (IJavaElement)packages[i];
                String filter = String.valueOf(pkg.getElementName()) + ".*";
                this.fStepFilterContentProvider.addFilter(filter, true);
                ++i;
            }
        }
    }

    private void removeFilters() {
        IStructuredSelection selection = (IStructuredSelection)this.fFilterViewer.getSelection();
        this.fStepFilterContentProvider.removeFilters(selection.toArray());
    }

    public boolean performOk() {
        this.fStepFilterContentProvider.saveFilters();
        JDIDebugUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    private void setDefaultValues() {
        this.fStepFilterContentProvider.setDefaults();
    }

    protected List createActiveStepFiltersList() {
        String[] strings = JavaDebugOptionsManager.parseList(this.getPreferenceStore().getString(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST));
        return Arrays.asList(strings);
    }

    protected List createInactiveStepFiltersList() {
        String[] strings = JavaDebugOptionsManager.parseList(this.getPreferenceStore().getString(IJDIPreferencesConstants.PREF_INACTIVE_FILTERS_LIST));
        return Arrays.asList(strings);
    }

    protected List createDefaultActiveStepFiltersList() {
        String[] strings = JavaDebugOptionsManager.parseList(this.getPreferenceStore().getDefaultString(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST));
        return Arrays.asList(strings);
    }

    protected List createDefaultInactiveStepFiltersList() {
        String[] strings = JavaDebugOptionsManager.parseList(this.getPreferenceStore().getDefaultString(IJDIPreferencesConstants.PREF_INACTIVE_FILTERS_LIST));
        return Arrays.asList(strings);
    }

    protected void updateActions() {
        if (this.fEnableAllButton != null) {
            boolean enabled = this.fFilterViewer.getTable().getItemCount() > 0;
            this.fEnableAllButton.setEnabled(enabled);
            this.fDisableAllButton.setEnabled(enabled);
        }
    }

    protected class StepFilterContentProvider
    implements IStructuredContentProvider {
        private CheckboxTableViewer fViewer;
        private List fFilters;

        public StepFilterContentProvider(CheckboxTableViewer viewer) {
            this.fViewer = viewer;
            List active = JavaStepFilterPreferencePage.this.createActiveStepFiltersList();
            List inactive = JavaStepFilterPreferencePage.this.createInactiveStepFiltersList();
            this.populateFilters(active, inactive);
            JavaStepFilterPreferencePage.this.updateActions();
        }

        public void setDefaults() {
            this.fViewer.remove(this.fFilters.toArray());
            List active = JavaStepFilterPreferencePage.this.createDefaultActiveStepFiltersList();
            List inactive = JavaStepFilterPreferencePage.this.createDefaultInactiveStepFiltersList();
            this.populateFilters(active, inactive);
            JavaStepFilterPreferencePage.this.fFilterSyntheticButton.setSelection(JavaStepFilterPreferencePage.this.getPreferenceStore().getDefaultBoolean(IJDIPreferencesConstants.PREF_FILTER_SYNTHETICS));
            JavaStepFilterPreferencePage.this.fFilterStaticButton.setSelection(JavaStepFilterPreferencePage.this.getPreferenceStore().getDefaultBoolean(IJDIPreferencesConstants.PREF_FILTER_STATIC_INITIALIZERS));
            JavaStepFilterPreferencePage.this.fFilterConstructorButton.setSelection(JavaStepFilterPreferencePage.this.getPreferenceStore().getDefaultBoolean(IJDIPreferencesConstants.PREF_FILTER_CONSTRUCTORS));
        }

        protected void populateFilters(List activeList, List inactiveList) {
            this.fFilters = new ArrayList(activeList.size() + inactiveList.size());
            this.populateList(activeList, true);
            this.populateList(inactiveList, false);
        }

        protected void populateList(List list, boolean checked) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                this.addFilter(name, checked);
            }
        }

        public Filter addFilter(String name, boolean checked) {
            Filter filter = new Filter(name, checked);
            if (!this.fFilters.contains(filter)) {
                this.fFilters.add(filter);
                this.fViewer.add((Object)filter);
                this.fViewer.setChecked((Object)filter, checked);
            }
            JavaStepFilterPreferencePage.this.updateActions();
            return filter;
        }

        public void saveFilters() {
            JavaStepFilterPreferencePage.this.getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_FILTER_CONSTRUCTORS, JavaStepFilterPreferencePage.this.fFilterConstructorButton.getSelection());
            JavaStepFilterPreferencePage.this.getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_FILTER_STATIC_INITIALIZERS, JavaStepFilterPreferencePage.this.fFilterStaticButton.getSelection());
            JavaStepFilterPreferencePage.this.getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_FILTER_SYNTHETICS, JavaStepFilterPreferencePage.this.fFilterSyntheticButton.getSelection());
            ArrayList<String> active = new ArrayList<String>(this.fFilters.size());
            ArrayList<String> inactive = new ArrayList<String>(this.fFilters.size());
            Iterator iterator = this.fFilters.iterator();
            while (iterator.hasNext()) {
                Filter filter = (Filter)iterator.next();
                String name = filter.getName();
                if (filter.isChecked()) {
                    active.add(name);
                    continue;
                }
                inactive.add(name);
            }
            String pref = JavaDebugOptionsManager.serializeList(active.toArray(new String[active.size()]));
            JavaStepFilterPreferencePage.this.getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST, pref);
            pref = JavaDebugOptionsManager.serializeList(inactive.toArray(new String[inactive.size()]));
            JavaStepFilterPreferencePage.this.getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_INACTIVE_FILTERS_LIST, pref);
        }

        public void removeFilters(Object[] filters) {
            int i = 0;
            while (i < filters.length) {
                Filter filter = (Filter)filters[i];
                this.fFilters.remove(filter);
                ++i;
            }
            this.fViewer.remove(filters);
            JavaStepFilterPreferencePage.this.updateActions();
        }

        public void toggleFilter(Filter filter) {
            boolean newState = !filter.isChecked();
            filter.setChecked(newState);
            this.fViewer.setChecked((Object)filter, newState);
        }

        public Object[] getElements(Object inputElement) {
            return this.fFilters.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

