/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;

class JavaModelListener
implements IElementChangedListener {
    JavaModelListener() {
    }

    public void elementChanged(ElementChangedEvent e) {
        if (e.getType() != 1) {
            return;
        }
        ArrayList removedElements = new ArrayList();
        this.getRemovedElements(e.getDelta(), removedElements);
        if (removedElements.isEmpty()) {
            return;
        }
        final ArrayList<IJavaBreakpoint> breakpointsToRemove = new ArrayList<IJavaBreakpoint>();
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugPlugin.getUniqueIdentifier());
        IJavaBreakpoint breakpoint = null;
        int i = 0;
        int numBreakpoints = breakpoints.length;
        while (i < numBreakpoints) {
            breakpoint = (IJavaBreakpoint)breakpoints[i];
            if (breakpoint instanceof IJavaBreakpoint) {
                if (breakpoint instanceof IJavaMethodBreakpoint) {
                    IJavaMethodBreakpoint methodBreakpoint = (IJavaMethodBreakpoint)breakpoint;
                    IMethod method = null;
                    try {
                        method = BreakpointUtils.getMethod(methodBreakpoint);
                    }
                    catch (CoreException x) {
                        JDIDebugUIPlugin.log(x);
                    }
                    if (method != null && this.containedInCollection((IJavaElement)method, removedElements)) {
                        breakpointsToRemove.add(breakpoint);
                    }
                } else {
                    try {
                        IType type = BreakpointUtils.getType(breakpoint);
                        if (type != null && this.containedInCollection((IJavaElement)type, removedElements)) {
                            breakpointsToRemove.add(breakpoint);
                        }
                    }
                    catch (CoreException x) {
                        JDIDebugUIPlugin.log(x);
                    }
                }
            }
            ++i;
        }
        if (!breakpointsToRemove.isEmpty()) {
            IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    Iterator itr = breakpointsToRemove.iterator();
                    while (itr.hasNext()) {
                        IBreakpoint breakpoint = (IBreakpoint)itr.next();
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, true);
                    }
                }
            };
            this.fork(wr);
        }
    }

    protected void getRemovedElements(IJavaElementDelta delta, List removedElements) {
        if ((delta.getKind() & 2) != 0 || (delta.getFlags() & 0x400) != 0 || (delta.getFlags() & 0x80) != 0) {
            removedElements.add(delta.getElement());
        }
        IJavaElementDelta[] subdeltas = delta.getAffectedChildren();
        int i = 0;
        int numDeltas = subdeltas.length;
        while (i < numDeltas) {
            this.getRemovedElements(subdeltas[i], removedElements);
            ++i;
        }
    }

    protected void fork(final IWorkspaceRunnable wRunnable) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ResourcesPlugin.getWorkspace().run(wRunnable, null);
                }
                catch (CoreException ce) {
                    DebugPlugin.log((Throwable)ce);
                }
            }
        };
        new Thread(runnable).start();
    }

    protected boolean containedInCollection(IJavaElement element, List removedElements) {
        if (removedElements.contains(element)) {
            return true;
        }
        IJavaElement parent = element.getParent();
        while (parent != null) {
            if (removedElements.contains(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

