/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDetailFormattersManager;
import org.eclipse.jdt.internal.debug.ui.actions.OpenVariableTypeAction;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.ui.IActionFilter;

public class JavaInspectExpressionActionFilter
implements IActionFilter {
    private static final Set fgPrimitiveTypes = JavaInspectExpressionActionFilter.initPrimitiveTypes();

    private static Set initPrimitiveTypes() {
        HashSet<String> set = new HashSet<String>(8);
        set.add("short");
        set.add("int");
        set.add("long");
        set.add("float");
        set.add("double");
        set.add("boolean");
        set.add("byte");
        set.add("char");
        set.add("null");
        return set;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof JavaInspectExpression) {
            JavaInspectExpression exp = (JavaInspectExpression)((Object)target);
            if (name.equals("PrimitiveVariableActionFilter") && value.equals("isNotPrimitive")) {
                return this.isNotPrimitiveType(exp);
            }
            if (name.equals("DetailFormatterFilter") && value.equals("isDefined")) {
                try {
                    IValue varValue = exp.getValue();
                    return varValue instanceof IJavaObject && JavaDetailFormattersManager.getDefault().hasAssociatedDetailFormatter(((IJavaObject)varValue).getJavaType());
                }
                catch (DebugException exception) {
                    JDIDebugUIPlugin.log(exception);
                }
            }
        }
        return false;
    }

    private boolean isNotPrimitiveType(JavaInspectExpression exp) {
        try {
            String refType = OpenVariableTypeAction.removeArray(exp.getValue().getReferenceTypeName());
            return !fgPrimitiveTypes.contains(refType);
        }
        catch (DebugException debugException) {
            return false;
        }
    }
}

