/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaHotCodeReplaceListener;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.ErrorDialogWithToggle;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookLauncher;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JavaHotCodeReplaceListener
implements IJavaHotCodeReplaceListener {
    private ILabelProvider fLabelProvider = DebugUITools.newDebugModelPresentation();

    public void hotCodeReplaceSucceeded(IJavaDebugTarget target) {
    }

    public void hotCodeReplaceFailed(IJavaDebugTarget target, DebugException exception) {
        String alertMessage;
        String preference;
        IStatus status;
        if (exception != null && !JDIDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_FAILED) || exception == null && !JDIDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_NOT_SUPPORTED)) {
            return;
        }
        ILaunch launch = target.getLaunch();
        if (launch.getAttribute(ScrapbookLauncher.SCRAPBOOK_LAUNCH) != null && !target.supportsHotCodeReplace()) {
            return;
        }
        final Display display = JDIDebugUIPlugin.getStandardDisplay();
        if (display.isDisposed()) {
            return;
        }
        String vmName = this.fLabelProvider.getText((Object)target);
        if (exception == null) {
            status = new Status(2, JDIDebugUIPlugin.getUniqueIdentifier(), 2, DebugUIMessages.getString("JDIDebugUIPlugin.The_target_VM_does_not_support_hot_code_replace_1"), null);
            preference = IJDIPreferencesConstants.PREF_ALERT_HCR_NOT_SUPPORTED;
            alertMessage = DebugUIMessages.getString("JDIDebugUIPlugin.Always_alert_me_when_hot_code_replace_is_not_supported_1");
        } else {
            status = exception.getStatus();
            preference = IJDIPreferencesConstants.PREF_ALERT_HCR_FAILED;
            alertMessage = DebugUIMessages.getString("JDIDebugUIPlugin.Always_alert_me_of_hot_code_replace_failure_1");
        }
        final String title = DebugUIMessages.getString("JDIDebugUIPlugin.Hot_code_replace_failed_1");
        final String message = MessageFormat.format(DebugUIMessages.getString("JDIDebugUIPlugin.{0}_was_unable_to_replace_the_running_code_with_the_code_in_the_workspace._2"), vmName);
        display.asyncExec(new Runnable(){

            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                Shell shell = JDIDebugUIPlugin.getActiveWorkbenchShell();
                ErrorDialogWithToggle dialog = new ErrorDialogWithToggle(shell, title, message, status, preference, alertMessage, JDIDebugUIPlugin.getDefault().getPreferenceStore());
                dialog.setBlockOnOpen(false);
                dialog.open();
            }
        });
    }

    public void obsoleteMethods(IJavaDebugTarget target) {
        if (!JDIDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_ALERT_OBSOLETE_METHODS)) {
            return;
        }
        final Display display = JDIDebugUIPlugin.getStandardDisplay();
        if (display.isDisposed()) {
            return;
        }
        String vmName = this.fLabelProvider.getText((Object)target);
        final String dialogTitle = DebugUIMessages.getString("JDIDebugUIPlugin.Obsolete_methods_remain_1");
        final String message = MessageFormat.format(DebugUIMessages.getString("JDIDebugUIPlugin.{0}_contains_obsolete_methods_1"), vmName);
        Status status = new Status(2, JDIDebugUIPlugin.getUniqueIdentifier(), 2, DebugUIMessages.getString("JDIDebugUIPlugin.Stepping_may_be_hazardous_1"), null);
        String toggleMessage = DebugUIMessages.getString("JDIDebugUIPlugin.Always_alert_me_of_obsolete_methods_1");
        display.asyncExec(new Runnable((IStatus)status, toggleMessage){
            private final /* synthetic */ IStatus val$status;
            private final /* synthetic */ String val$toggleMessage;
            {
                this.val$status = iStatus;
                this.val$toggleMessage = string3;
            }

            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                Shell shell = JDIDebugUIPlugin.getActiveWorkbenchShell();
                ErrorDialogWithToggle dialog = new ErrorDialogWithToggle(shell, dialogTitle, message, this.val$status, IJDIPreferencesConstants.PREF_ALERT_OBSOLETE_METHODS, this.val$toggleMessage, JDIDebugUIPlugin.getDefault().getPreferenceStore());
                dialog.setBlockOnOpen(false);
                dialog.open();
            }
        });
    }
}

