/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import com.sun.jdi.InvocationException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IEvaluationRunnable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.DetailFormatter;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.internal.debug.ui.JavaDetailFormattersManager;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class JavaDetailFormattersManager
implements IPropertyChangeListener,
IDebugEventSetListener,
ILaunchesListener {
    private static JavaDetailFormattersManager fgDefault;
    private HashMap fDetailFormattersMap;
    private HashMap fCacheMap;

    public static JavaDetailFormattersManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new JavaDetailFormattersManager();
        }
        return fgDefault;
    }

    private JavaDetailFormattersManager() {
        this.populateDetailFormattersMap();
        JDIDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fCacheMap = new HashMap();
    }

    private void populateDetailFormattersMap() {
        String[] detailFormattersList = JavaDebugOptionsManager.parseList(JDIDebugUIPlugin.getDefault().getPreferenceStore().getString(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST));
        this.fDetailFormattersMap = new HashMap(detailFormattersList.length / 3);
        int i = 0;
        int length = detailFormattersList.length;
        while (i < length) {
            String typeName = detailFormattersList[i++];
            String snippet = detailFormattersList[i++].replace('\u0000', ',');
            boolean enabled = !"0".equals(detailFormattersList[i++]);
            this.fDetailFormattersMap.put(typeName, new DetailFormatter(typeName, snippet, enabled));
        }
    }

    public void computeValueDetail(final IJavaValue objectValue, final IJavaThread thread, final IValueDetailListener listener) {
        Runnable postEventDispatch = new Runnable(){

            public void run() {
                Runnable postEventProcess = new Runnable(this, thread, objectValue, listener){
                    private final /* synthetic */ IJavaThread val$thread;
                    private final /* synthetic */ 2 this$1;
                    private final /* synthetic */ IJavaValue val$objectValue;
                    private final /* synthetic */ IValueDetailListener val$listener;
                    {
                        this.this$1 = var1_1;
                        this.val$thread = iJavaThread;
                        this.val$objectValue = iJavaValue;
                        this.val$listener = iValueDetailListener;
                    }

                    public void run() {
                        this.val$thread.queueRunnable(new Runnable(this, this.val$objectValue, this.val$thread, this.val$listener){
                            private final /* synthetic */ IJavaValue val$objectValue;
                            private final /* synthetic */ IJavaThread val$thread;
                            private final /* synthetic */ IValueDetailListener val$listener;
                            private final /* synthetic */ 3 this$2;
                            {
                                this.this$2 = var1_1;
                                this.val$objectValue = iJavaValue;
                                this.val$thread = iJavaThread;
                                this.val$listener = iValueDetailListener;
                            }

                            public void run() {
                                JavaDetailFormattersManager.access$0(2.access$0(3.access$0(this.this$2)), this.val$objectValue, this.val$thread, this.val$listener);
                            }
                        });
                    }

                    static /* synthetic */ 2 access$0(3 var0) {
                        return var0.this$1;
                    }
                };
                JDIDebugUIPlugin.getStandardDisplay().asyncExec(postEventProcess);
            }

            static /* synthetic */ JavaDetailFormattersManager access$0(2 var0) {
                return var0.JavaDetailFormattersManager.this;
            }
        };
        DebugPlugin.getDefault().asyncExec(postEventDispatch);
    }

    private void resolveFormatter(IJavaValue value, IJavaThread thread, IValueDetailListener listener) {
        ICompiledExpression compiledExpression = null;
        EvaluationListener evaluationListener = new EvaluationListener(value, thread, listener);
        if (value instanceof IJavaObject && !(value instanceof IJavaArray)) {
            IJavaObject objectValue = (IJavaObject)value;
            IJavaProject project = this.getJavaProject(thread);
            if (project != null) {
                JDIDebugTarget debugTarget = (JDIDebugTarget)thread.getDebugTarget();
                IAstEvaluationEngine evaluationEngine = JDIDebugUIPlugin.getDefault().getEvaluationEngine(project, (IJavaDebugTarget)debugTarget);
                try {
                    compiledExpression = this.getCompiledExpression(objectValue, debugTarget, evaluationEngine);
                    if (compiledExpression != null) {
                        evaluationEngine.evaluateExpression(compiledExpression, objectValue, thread, (IEvaluationListener)evaluationListener, 128, false);
                        return;
                    }
                }
                catch (DebugException e) {
                    DebugUIPlugin.log((Throwable)e);
                    return;
                }
            }
        }
        try {
            evaluationListener.valueToString(value);
        }
        catch (DebugException e) {
            listener.detailComputed((IValue)value, e.getStatus().getMessage());
        }
    }

    private IJavaProject getJavaProject(IJavaThread thread) {
        Object sourceElement;
        ILaunch launch = thread.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        try {
            IStackFrame frame = thread.getTopStackFrame();
            if (frame == null) {
                return null;
            }
            sourceElement = locator.getSourceElement(frame);
        }
        catch (DebugException e) {
            DebugUIPlugin.log((Throwable)e);
            return null;
        }
        if (sourceElement instanceof IJavaElement) {
            return ((IJavaElement)sourceElement).getJavaProject();
        }
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        if (configuration != null) {
            try {
                return JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return null;
    }

    public boolean hasAssociatedDetailFormatter(IJavaType type) {
        return this.getAssociatedDetailFormatter(type) != null;
    }

    public DetailFormatter getAssociatedDetailFormatter(IJavaType type) {
        String typeName;
        block4: {
            try {
                while (type instanceof IJavaArrayType) {
                    type = ((IJavaArrayType)type).getComponentType();
                }
                if (type instanceof IJavaClassType) {
                    typeName = type.getName();
                    break block4;
                }
                return null;
            }
            catch (DebugException debugException) {
                return null;
            }
        }
        return (DetailFormatter)this.fDetailFormattersMap.get(typeName);
    }

    public void setAssociatedDetailFormatter(DetailFormatter detailFormatter) {
        this.fDetailFormattersMap.put(detailFormatter.getTypeName(), detailFormatter);
        this.savePreference();
    }

    private void savePreference() {
        Collection valuesList = this.fDetailFormattersMap.values();
        String[] values = new String[valuesList.size() * 3];
        int i = 0;
        Iterator iter = valuesList.iterator();
        while (iter.hasNext()) {
            DetailFormatter detailFormatter = (DetailFormatter)iter.next();
            values[i++] = detailFormatter.getTypeName();
            values[i++] = detailFormatter.getSnippet().replace(',', '\u0000');
            String string = values[i++] = detailFormatter.isEnabled() ? "1" : "0";
        }
        String pref = JavaDebugOptionsManager.serializeList(values);
        JDIDebugUIPlugin.getDefault().getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST, pref);
        JDIDebugUIPlugin.getDefault().savePluginPreferences();
    }

    private String getDetailFormatter(IJavaClassType type) throws DebugException {
        DetailFormatter detailFormatter;
        if (type == null) {
            return null;
        }
        String typeName = type.getName();
        if (this.fDetailFormattersMap.containsKey(typeName) && (detailFormatter = (DetailFormatter)this.fDetailFormattersMap.get(typeName)).isEnabled()) {
            return detailFormatter.getSnippet();
        }
        return this.getDetailFormatter(type.getSuperclass());
    }

    private ICompiledExpression getCompiledExpression(IJavaObject javaObject, JDIDebugTarget debugTarget, IAstEvaluationEngine evaluationEngine) throws DebugException {
        IJavaClassType type = (IJavaClassType)javaObject.getJavaType();
        String typeName = type.getName();
        Key key = new Key(typeName, debugTarget);
        if (this.fCacheMap.containsKey(key)) {
            return (ICompiledExpression)this.fCacheMap.get(key);
        }
        String snippet = this.getDetailFormatter(type);
        if (snippet != null) {
            ICompiledExpression res = evaluationEngine.getCompiledExpression(snippet, javaObject);
            this.fCacheMap.put(key, res);
            return res;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST)) {
            this.populateDetailFormattersMap();
            this.fCacheMap.clear();
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource() instanceof JDIDebugTarget && event.getKind() == 8) {
                this.deleteCacheForTarget((JDIDebugTarget)event.getSource());
            }
            ++i;
        }
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            IDebugTarget[] debugTargets = launch.getDebugTargets();
            int j = 0;
            while (j < debugTargets.length) {
                if (debugTargets[j] instanceof JDIDebugTarget) {
                    this.deleteCacheForTarget((JDIDebugTarget)debugTargets[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private synchronized void deleteCacheForTarget(JDIDebugTarget debugTarget) {
        Iterator iter = this.fCacheMap.keySet().iterator();
        while (iter.hasNext()) {
            Key key = (Key)iter.next();
            if (key.fDebugTarget != debugTarget) continue;
            iter.remove();
        }
    }

    static /* synthetic */ void access$0(JavaDetailFormattersManager javaDetailFormattersManager, IJavaValue iJavaValue, IJavaThread iJavaThread, IValueDetailListener iValueDetailListener) {
        javaDetailFormattersManager.resolveFormatter(iJavaValue, iJavaThread, iValueDetailListener);
    }

    private static class Key {
        private String fTypeName;
        private JDIDebugTarget fDebugTarget;

        Key(String typeName, JDIDebugTarget debugTarget) {
            this.fTypeName = typeName;
            this.fDebugTarget = debugTarget;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key key = (Key)obj;
                return this.fTypeName != null && this.fDebugTarget != null && this.fTypeName.equals(key.fTypeName) && this.fDebugTarget.equals(key.fDebugTarget);
            }
            return false;
        }

        public int hashCode() {
            return this.fTypeName.hashCode() / 2 + this.fDebugTarget.hashCode() / 2;
        }
    }

    private static class EvaluationListener
    implements IEvaluationListener {
        private static final String fgToString = "toString";
        private static final String fgToStringSignature = "()Ljava/lang/String;";
        private IJavaValue fValue;
        private IValueDetailListener fListener;
        private IJavaThread fThread;

        public EvaluationListener(IJavaValue value, IJavaThread thread, IValueDetailListener listener) {
            this.fValue = value;
            this.fThread = thread;
            this.fListener = listener;
        }

        public void evaluationComplete(IEvaluationResult result) {
            if (result.hasErrors()) {
                StringBuffer error = new StringBuffer(DebugUIMessages.getString("JavaDetailFormattersManager.Detail_formatter_error___1"));
                DebugException exception = result.getException();
                if (exception != null) {
                    Throwable throwable = exception.getStatus().getException();
                    error.append("\n\t\t");
                    if (throwable instanceof InvocationException) {
                        error.append(MessageFormat.format(DebugUIMessages.getString("JavaDetailFormattersManager.An_exception_occurred__{0}_3"), ((InvocationException)throwable).exception().referenceType().name()));
                    } else {
                        error.append(exception.getStatus().getMessage());
                    }
                } else {
                    String[] errors = result.getErrorMessages();
                    int i = 0;
                    int length = errors.length;
                    while (i < length) {
                        error.append("\n\t\t").append(errors[i]);
                        ++i;
                    }
                }
                this.fListener.detailComputed((IValue)this.fValue, error.toString());
            } else {
                try {
                    this.valueToString(result.getValue());
                }
                catch (DebugException e) {
                    this.fListener.detailComputed((IValue)this.fValue, e.getStatus().getMessage());
                }
            }
        }

        public void valueToString(IJavaValue objectValue) throws DebugException {
            IEvaluationRunnable eval = new IEvaluationRunnable(this, objectValue){
                private final /* synthetic */ IJavaValue val$objectValue;
                private final /* synthetic */ EvaluationListener this$1;
                {
                    this.this$1 = evaluationListener;
                    this.val$objectValue = iJavaValue;
                }

                public void run(IJavaThread thread, IProgressMonitor monitor) throws DebugException {
                    StringBuffer result = new StringBuffer();
                    if (this.val$objectValue.getSignature() == null) {
                        result.append(DebugUIMessages.getString("JavaDetailFormattersManager.null"));
                    } else if (this.val$objectValue instanceof IJavaPrimitiveValue) {
                        this.this$1.appendJDIPrimitiveValueString(result, this.val$objectValue);
                    } else if (EvaluationListener.access$0(this.this$1) == null || !EvaluationListener.access$0(this.this$1).isSuspended()) {
                        result.append(DebugUIMessages.getString("JavaDetailFormattersManager.no_suspended_threads"));
                        this.this$1.appendJDIValueString(result, this.val$objectValue);
                    } else if (this.val$objectValue instanceof IJavaArray) {
                        this.this$1.appendArrayDetail(result, (IJavaArray)this.val$objectValue);
                    } else if (this.val$objectValue instanceof IJavaObject) {
                        this.this$1.appendObjectDetail(result, (IJavaObject)this.val$objectValue);
                    } else {
                        this.this$1.appendJDIValueString(result, this.val$objectValue);
                    }
                    EvaluationListener.access$1(this.this$1).detailComputed((IValue)EvaluationListener.access$2(this.this$1), result.toString());
                }
            };
            this.fThread.runEvaluation(eval, null, 128, false);
        }

        protected void appendArrayDetail(StringBuffer result, IJavaArray arrayValue) throws DebugException {
            IJavaValue[] arrayValues;
            result.append('[');
            try {
                arrayValues = arrayValue.getValues();
            }
            catch (DebugException de) {
                JDIDebugUIPlugin.log(de);
                result.append(de.getStatus().getMessage());
                return;
            }
            int i = 0;
            while (i < arrayValues.length) {
                IJavaValue value = arrayValues[i];
                if (value instanceof IJavaArray) {
                    this.appendArrayDetail(result, (IJavaArray)value);
                } else if (value instanceof IJavaObject) {
                    this.appendObjectDetail(result, (IJavaObject)value);
                } else {
                    this.appendJDIValueString(result, value);
                }
                if (i < arrayValues.length - 1) {
                    result.append(',');
                    result.append(' ');
                }
                ++i;
            }
            result.append(']');
        }

        protected void appendJDIPrimitiveValueString(StringBuffer result, IJavaValue value) throws DebugException {
            result.append(value.getValueString());
        }

        protected void appendJDIValueString(StringBuffer result, IJavaValue value) throws DebugException {
            result.append(value.getValueString());
        }

        protected void appendObjectDetail(StringBuffer result, IJavaObject objectValue) throws DebugException {
            IJavaValue toStringValue = objectValue.sendMessage(fgToString, fgToStringSignature, null, this.fThread, false);
            if (toStringValue == null) {
                result.append(DebugUIMessages.getString("JavaDetailFormattersManager.<unknown>"));
            } else {
                this.appendJDIValueString(result, toStringValue);
            }
        }

        static /* synthetic */ IJavaThread access$0(EvaluationListener evaluationListener) {
            return evaluationListener.fThread;
        }

        static /* synthetic */ IValueDetailListener access$1(EvaluationListener evaluationListener) {
            return evaluationListener.fListener;
        }

        static /* synthetic */ IJavaValue access$2(EvaluationListener evaluationListener) {
            return evaluationListener.fValue;
        }
    }
}

