/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.text.MessageFormat;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavaDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPropertyChangeListener {
    private Button fSuspendButton;
    private Button fSuspendOnCompilationErrors;
    private Button fAlertHCRButton;
    private Button fAlertHCRNotSupportedButton;
    private Button fAlertObsoleteButton;
    private Button fPerformHCRWithCompilationErrors;
    private JavaDebugIntegerFieldEditor fTimeoutText;
    private JavaDebugIntegerFieldEditor fConnectionTimeoutText;

    public JavaDebugPreferencePage() {
        this.setPreferenceStore(JDIDebugUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(DebugUIMessages.getString("JavaDebugPreferencePage.description"));
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IJavaDebugHelpContextIds.JAVA_DEBUG_PREFERENCE_PAGE);
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        Composite comp = this.createGroupComposite(composite, 1, DebugUIMessages.getString("JavaDebugPreferencePage.Suspend_Execution_1"));
        this.fSuspendButton = this.createCheckButton(comp, DebugUIMessages.getString("JavaDebugPreferencePage.Suspend_&execution_on_uncaught_exceptions_1"));
        this.fSuspendOnCompilationErrors = this.createCheckButton(comp, DebugUIMessages.getString("JavaDebugPreferencePage.Suspend_execution_on_co&mpilation_errors_1"));
        this.createSpacer(composite, 1);
        comp = this.createGroupComposite(composite, 1, DebugUIMessages.getString("JavaDebugPreferencePage.Hot_Code_Replace_2"));
        this.fAlertHCRButton = this.createCheckButton(comp, DebugUIMessages.getString("JavaDebugPreferencePage.Alert_me_when_hot_code_replace_fails_1"));
        this.fAlertHCRNotSupportedButton = this.createCheckButton(comp, DebugUIMessages.getString("JavaDebugPreferencePage.Alert_me_when_hot_code_replace_is_not_supported_1"));
        this.fAlertObsoleteButton = this.createCheckButton(comp, DebugUIMessages.getString("JavaDebugPreferencePage.Alert_me_when_obsolete_methods_remain_1"));
        this.fPerformHCRWithCompilationErrors = this.createCheckButton(comp, DebugUIMessages.getString("JavaDebugPreferencePage.Replace_classfiles_containing_compilation_errors_1"));
        this.createSpacer(composite, 1);
        comp = this.createGroupComposite(composite, 1, DebugUIMessages.getString("JavaDebugPreferencePage.Communication_1"));
        Composite spacingComposite = new Composite(comp, 0);
        layout = new GridLayout();
        spacingComposite.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        spacingComposite.setLayoutData((Object)data);
        spacingComposite.setFont(font);
        IPreferenceStore store = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        this.fTimeoutText = new JavaDebugIntegerFieldEditor(JDIDebugModel.PREF_REQUEST_TIMEOUT, DebugUIMessages.getString("JavaDebugPreferencePage.Debugger_&timeout__2"), spacingComposite);
        this.fTimeoutText.setPreferenceStore(store);
        this.fTimeoutText.setPreferencePage(this);
        this.fTimeoutText.setValidateStrategy(0);
        int minValue = store.getDefaultInt(JDIDebugModel.PREF_REQUEST_TIMEOUT);
        this.fTimeoutText.setValidRange(minValue, Integer.MAX_VALUE);
        this.fTimeoutText.setErrorMessage(MessageFormat.format(DebugUIMessages.getString("JavaDebugPreferencePage.Value_must_be_a_valid_integer_greater_than_{0}_ms_1"), new Integer(minValue)));
        this.fTimeoutText.load();
        this.fTimeoutText.setPropertyChangeListener(this);
        this.fConnectionTimeoutText = new JavaDebugIntegerFieldEditor(JavaRuntime.PREF_CONNECT_TIMEOUT, DebugUIMessages.getString("JavaDebugPreferencePage.&Launch_timeout_(ms)__1"), spacingComposite);
        this.fConnectionTimeoutText.setPreferenceStore(store);
        this.fConnectionTimeoutText.setPreferencePage(this);
        this.fConnectionTimeoutText.setValidateStrategy(0);
        minValue = store.getDefaultInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
        this.fConnectionTimeoutText.setValidRange(minValue, Integer.MAX_VALUE);
        this.fConnectionTimeoutText.setErrorMessage(MessageFormat.format(DebugUIMessages.getString("JavaDebugPreferencePage.Value_must_be_a_valid_integer_greater_than_{0}_ms_1"), new Integer(minValue)));
        this.fConnectionTimeoutText.load();
        this.fConnectionTimeoutText.setPropertyChangeListener(this);
        this.setValues();
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.storeValues();
        JDIDebugUIPlugin.getDefault().savePluginPreferences();
        JDIDebugModel.savePreferences();
        JavaRuntime.savePreferences();
        return true;
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    private void setDefaultValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fSuspendButton.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS));
        this.fSuspendOnCompilationErrors.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS));
        this.fAlertHCRButton.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_FAILED));
        this.fAlertHCRNotSupportedButton.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_NOT_SUPPORTED));
        this.fAlertObsoleteButton.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_ALERT_OBSOLETE_METHODS));
        this.fPerformHCRWithCompilationErrors.setSelection(store.getDefaultBoolean(JDIDebugModel.PREF_HCR_WITH_COMPILATION_ERRORS));
        this.fTimeoutText.setStringValue(new Integer(store.getDefaultInt(JDIDebugModel.PREF_REQUEST_TIMEOUT)).toString());
        this.fConnectionTimeoutText.setStringValue(new Integer(store.getDefaultInt(JavaRuntime.PREF_CONNECT_TIMEOUT)).toString());
    }

    private Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        button.setFont(parent.getFont());
        return button;
    }

    private Composite createGroupComposite(Composite parent, int numColumns, String labelText) {
        Group comp = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        comp.setLayoutData((Object)gd);
        comp.setText(labelText);
        comp.setFont(parent.getFont());
        return comp;
    }

    private void setValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fSuspendButton.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS));
        this.fSuspendOnCompilationErrors.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS));
        this.fAlertHCRButton.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_FAILED));
        this.fAlertHCRNotSupportedButton.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_NOT_SUPPORTED));
        this.fAlertObsoleteButton.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_ALERT_OBSOLETE_METHODS));
        this.fPerformHCRWithCompilationErrors.setSelection(JDIDebugModel.getPreferences().getBoolean(JDIDebugModel.PREF_HCR_WITH_COMPILATION_ERRORS));
        this.fTimeoutText.setStringValue(new Integer(JDIDebugModel.getPreferences().getInt(JDIDebugModel.PREF_REQUEST_TIMEOUT)).toString());
        this.fConnectionTimeoutText.setStringValue(new Integer(JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT)).toString());
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS, this.fSuspendButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS, this.fSuspendOnCompilationErrors.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_ALERT_HCR_FAILED, this.fAlertHCRButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_ALERT_HCR_NOT_SUPPORTED, this.fAlertHCRNotSupportedButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_ALERT_OBSOLETE_METHODS, this.fAlertObsoleteButton.getSelection());
        JDIDebugModel.getPreferences().setValue(JDIDebugModel.PREF_HCR_WITH_COMPILATION_ERRORS, this.fPerformHCRWithCompilationErrors.getSelection());
        JDIDebugModel.getPreferences().setValue(JDIDebugModel.PREF_REQUEST_TIMEOUT, this.fTimeoutText.getIntValue());
        JavaRuntime.getPreferences().setValue(JavaRuntime.PREF_CONNECT_TIMEOUT, this.fConnectionTimeoutText.getIntValue());
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                if (this.fTimeoutText != null && event.getSource() != this.fTimeoutText) {
                    this.fTimeoutText.refreshValidState();
                }
                if (this.fConnectionTimeoutText != null && event.getSource() != this.fConnectionTimeoutText) {
                    this.fConnectionTimeoutText.refreshValidState();
                }
            }
            this.setValid(this.fTimeoutText.isValid() && this.fConnectionTimeoutText.isValid());
            this.getContainer().updateButtons();
            this.updateApplyButton();
        }
    }

    protected boolean canClearErrorMessage() {
        return this.fTimeoutText.isValid() && this.fConnectionTimeoutText.isValid();
    }

    protected class JavaDebugIntegerFieldEditor
    extends IntegerFieldEditor {
        public JavaDebugIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (JavaDebugPreferencePage.this.canClearErrorMessage()) {
                super.clearErrorMessage();
            }
        }
    }
}

