/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaWordFinder;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class JavaDebugHover
implements IJavaEditorTextHover {
    protected IEditorPart fEditor;
    static /* synthetic */ Class class$0;

    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord(textViewer.getDocument(), offset);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin == null) {
            return null;
        }
        ILaunchManager launchManager = debugPlugin.getLaunchManager();
        if (launchManager == null) {
            return null;
        }
        IDebugTarget[] targets = launchManager.getDebugTargets();
        if (targets != null && targets.length > 0) {
            try {
                IDocument document = textViewer.getDocument();
                if (document == null) {
                    return null;
                }
                String variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                ArrayList<IJavaDebugTarget> javaTargetList = new ArrayList<IJavaDebugTarget>(targets.length);
                int i = 0;
                while (i < targets.length) {
                    IJavaDebugTarget javaTarget;
                    IDebugTarget iDebugTarget = targets[i];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.jdt.debug.core.IJavaDebugTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((javaTarget = (IJavaDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null) {
                        javaTargetList.add(i, javaTarget);
                    }
                    ++i;
                }
                StringBuffer buffer = new StringBuffer();
                boolean showDebugTarget = javaTargetList.size() > 1;
                Iterator iterator = javaTargetList.iterator();
                while (iterator.hasNext()) {
                    IJavaDebugTarget javaTarget = (IJavaDebugTarget)iterator.next();
                    try {
                        IJavaVariable variable = javaTarget.findVariable(variableName);
                        if (variable == null) continue;
                        String debugTargetName = showDebugTarget ? javaTarget.getName() : null;
                        JavaDebugHover.appendVariable(buffer, (IVariable)variable, debugTargetName);
                    }
                    catch (DebugException x) {
                        JDIDebugUIPlugin.log(x);
                    }
                }
                if (buffer.length() > 0) {
                    return buffer.toString();
                }
            }
            catch (BadLocationException x) {
                JDIDebugUIPlugin.log(x);
            }
        }
        return null;
    }

    private static void appendVariable(StringBuffer buffer, IVariable variable, String debugTargetName) throws DebugException {
        buffer.append("<p>");
        if (debugTargetName != null) {
            buffer.append(String.valueOf('[') + debugTargetName + "]&nbsp;");
        }
        buffer.append(JavaDebugHover.makeHTMLSafe(variable.getName()));
        buffer.append(" =");
        String type = JavaDebugHover.getTypeName(variable);
        String value = "<b>" + JavaDebugHover.makeHTMLSafe(variable.getValue().getValueString().trim()) + "</b>";
        if (type == null) {
            buffer.append(" null");
        } else if (type.equals("java.lang.String")) {
            buffer.append(" \"");
            buffer.append(value);
            buffer.append('\"');
        } else if (type.equals("boolean")) {
            buffer.append(' ');
            buffer.append(value);
        } else {
            buffer.append(" (");
            buffer.append(JavaDebugHover.makeHTMLSafe(type));
            buffer.append(") ");
            buffer.append(value);
        }
        buffer.append("</p>");
    }

    private static String getTypeName(IVariable variable) throws DebugException {
        IValue value = variable.getValue();
        if (value instanceof IJavaValue) {
            IJavaType type = ((IJavaValue)value).getJavaType();
            if (type == null) {
                return null;
            }
            return type.getName();
        }
        return value.getReferenceTypeName();
    }

    private static String makeHTMLSafe(String string) {
        StringBuffer buffer = new StringBuffer(string.length());
        int i = 0;
        while (i != string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

