/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;

public class JDISourceViewer
extends SourceViewer {
    public JDISourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        super(parent, ruler, styles);
        StyledText text = this.getTextWidget();
        text.addBidiSegmentListener(new BidiSegmentListener(){

            public void lineGetSegments(BidiSegmentEvent event) {
                try {
                    event.segments = JDISourceViewer.this.getBidiLineSegments(event.lineOffset);
                }
                catch (BadLocationException badLocationException) {}
            }
        });
    }

    public IContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }

    protected int[] getBidiLineSegments(int lineOffset) throws BadLocationException {
        IDocument document = this.getDocument();
        if (document == null) {
            return null;
        }
        IRegion line = document.getLineInformationOfOffset(lineOffset);
        ITypedRegion[] linePartitioning = document.computePartitioning(lineOffset, line.getLength());
        ArrayList<ITypedRegion> segmentation = new ArrayList<ITypedRegion>();
        int i = 0;
        while (i < linePartitioning.length) {
            if ("__java_string".equals(linePartitioning[i].getType())) {
                segmentation.add(linePartitioning[i]);
            }
            ++i;
        }
        if (segmentation.size() == 0) {
            return null;
        }
        int size = segmentation.size();
        int[] segments = new int[size * 2 + 1];
        int j = 0;
        int i2 = 0;
        while (i2 < size) {
            int offset;
            ITypedRegion segment = (ITypedRegion)segmentation.get(i2);
            if (i2 == 0) {
                segments[j++] = 0;
            }
            if ((offset = segment.getOffset() - lineOffset) > segments[j - 1]) {
                segments[j++] = offset;
            }
            if (offset + segment.getLength() >= line.getLength()) break;
            segments[j++] = offset + segment.getLength();
            ++i2;
        }
        if (j < segments.length) {
            int[] result = new int[j];
            System.arraycopy(segments, 0, result, 0, j);
            segments = result;
        }
        return segments;
    }
}

