/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaHotCodeReplaceListener;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.internal.debug.ui.ActionFilterAdapterFactory;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.internal.debug.ui.JavaEvaluationEngineManager;
import org.eclipse.jdt.internal.debug.ui.JavaHotCodeReplaceListener;
import org.eclipse.jdt.internal.debug.ui.JavaModelListener;
import org.eclipse.jdt.internal.debug.ui.JavaSourceLocationWorkbenchAdapterFactory;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetFileDocumentProvider;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class JDIDebugUIPlugin
extends AbstractUIPlugin {
    private static JDIDebugUIPlugin fgPlugin;
    private FileDocumentProvider fSnippetDocumentProvider;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private JavaEvaluationEngineManager fEvaluationEngineManager;
    private ActionFilterAdapterFactory fActionFilterAdapterFactory;
    private JavaSourceLocationWorkbenchAdapterFactory fSourceLocationAdapterFactory;
    private IDebugModelPresentation fUtilPresentation;
    private IJavaHotCodeReplaceListener fHCRListener;
    private IElementChangedListener fJavaModelListener;
    protected Map fVmInstallTypePageMap;
    private boolean fShuttingDown = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public JDIDebugUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        JDIDebugUIPlugin.setDefault(this);
    }

    private static void setDefault(JDIDebugUIPlugin plugin) {
        fgPlugin = plugin;
    }

    public static JDIDebugUIPlugin getDefault() {
        return fgPlugin;
    }

    public static String getUniqueIdentifier() {
        if (JDIDebugUIPlugin.getDefault() == null) {
            return "org.eclipse.jdt.debug.ui";
        }
        return JDIDebugUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static void log(IStatus status) {
        JDIDebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        JDIDebugUIPlugin.log((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, message, null));
    }

    public static void log(Throwable e) {
        JDIDebugUIPlugin.log((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, DebugUIMessages.getString("JDIDebugUIPlugin.Internal_Error_1"), e));
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return JDIDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = JDIDebugUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = JDIDebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    protected ImageRegistry createImageRegistry() {
        return JavaDebugImages.getImageRegistry();
    }

    public IDocumentProvider getSnippetDocumentProvider() {
        if (this.fSnippetDocumentProvider == null) {
            this.fSnippetDocumentProvider = new SnippetFileDocumentProvider();
        }
        return this.fSnippetDocumentProvider;
    }

    public static void logDebugMessage(String message) {
        if (JDIDebugUIPlugin.getDefault().isDebugging()) {
            JDIDebugUIPlugin.log((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, "Internal message logged from JDT Debug UI: " + message, null));
        }
    }

    public static void errorDialog(String message, IStatus status) {
        JDIDebugUIPlugin.log(status);
        Shell shell = JDIDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)DebugUIMessages.getString("JDIDebugUIPlugin.Error_1"), (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        JDIDebugUIPlugin.log(t);
        Shell shell = JDIDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, "Error logged from JDT Debug UI: ", t);
            ErrorDialog.openError((Shell)shell, (String)DebugUIMessages.getString("JDIDebugUIPlugin.Error_1"), (String)message, (IStatus)status);
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        if (this.isShuttingDown()) {
            return;
        }
        store.setDefault(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS, true);
        store.setDefault(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS, true);
        store.setDefault(IJDIPreferencesConstants.PREF_ALERT_HCR_FAILED, true);
        store.setDefault(IJDIPreferencesConstants.PREF_ALERT_HCR_NOT_SUPPORTED, true);
        store.setDefault(IJDIPreferencesConstants.PREF_ALERT_OBSOLETE_METHODS, true);
        store.setDefault(IJDIPreferencesConstants.PREF_SHOW_QUALIFIED_NAMES, false);
        store.setDefault(JDIDebugModel.PREF_HCR_WITH_COMPILATION_ERRORS, true);
        store.setDefault(JDIDebugModel.PREF_REQUEST_TIMEOUT, 3000);
        store.setDefault(JavaRuntime.PREF_CONNECT_TIMEOUT, 20000);
        store.setDefault(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST, "java.lang.ClassLoader");
        store.setDefault(IJDIPreferencesConstants.PREF_INACTIVE_FILTERS_LIST, "com.ibm.*,com.sun.*,java.*,javax.*,org.omg.*,sun.*,sunw.*");
        store.setDefault(IJDIPreferencesConstants.PREF_SHOW_CONSTANTS, false);
        store.setDefault(IJDIPreferencesConstants.PREF_SHOW_STATIC_VARIALBES, false);
        store.setDefault(IJDIPreferencesConstants.PREF_SHOW_CHAR, false);
        store.setDefault(IJDIPreferencesConstants.PREF_SHOW_HEX, false);
        store.setDefault(IJDIPreferencesConstants.PREF_SHOW_UNSIGNED, false);
    }

    public void startup() throws CoreException {
        super.startup();
        JavaDebugOptionsManager.getDefault().startup();
        IAdapterManager manager = Platform.getAdapterManager();
        this.fActionFilterAdapterFactory = new ActionFilterAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fActionFilterAdapterFactory, (Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jdt.debug.core.IJavaVariable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fActionFilterAdapterFactory, (Class)clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fActionFilterAdapterFactory, (Class)clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.jdt.debug.core.IJavaThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fActionFilterAdapterFactory, (Class)clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fActionFilterAdapterFactory, (Class)clazz5);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.jdt.internal.debug.ui.JavaWatchExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fActionFilterAdapterFactory, (Class)clazz6);
        this.fSourceLocationAdapterFactory = new JavaSourceLocationWorkbenchAdapterFactory();
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.eclipse.jdt.launching.sourcelookup.IJavaSourceLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fSourceLocationAdapterFactory, (Class)clazz7);
        this.fEvaluationEngineManager = new JavaEvaluationEngineManager();
        this.fJavaModelListener = new JavaModelListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.fJavaModelListener);
        this.fHCRListener = new JavaHotCodeReplaceListener();
        JDIDebugModel.addHotCodeReplaceListener((IJavaHotCodeReplaceListener)this.fHCRListener);
    }

    public void shutdown() throws CoreException {
        this.setShuttingDown(true);
        JDIDebugModel.removeHotCodeReplaceListener((IJavaHotCodeReplaceListener)this.fHCRListener);
        JavaCore.removeElementChangedListener((IElementChangedListener)this.fJavaModelListener);
        JavaDebugOptionsManager.getDefault().shutdown();
        if (this.fImageDescriptorRegistry != null) {
            this.fImageDescriptorRegistry.dispose();
        }
        this.fEvaluationEngineManager.dispose();
        IAdapterManager manager = Platform.getAdapterManager();
        manager.unregisterAdapters((IAdapterFactory)this.fActionFilterAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fSourceLocationAdapterFactory);
        if (this.fUtilPresentation != null) {
            this.fUtilPresentation.dispose();
        }
        super.shutdown();
    }

    protected boolean isShuttingDown() {
        return this.fShuttingDown;
    }

    private void setShuttingDown(boolean value) {
        this.fShuttingDown = value;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        if (JDIDebugUIPlugin.getDefault().fImageDescriptorRegistry == null) {
            JDIDebugUIPlugin.getDefault().fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return JDIDebugUIPlugin.getDefault().fImageDescriptorRegistry;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public IAstEvaluationEngine getEvaluationEngine(IJavaProject project, IJavaDebugTarget target) {
        return this.fEvaluationEngineManager.getEvaluationEngine(project, target);
    }

    public static ElementListSelectionDialog createAllPackagesDialog(Shell shell, IJavaProject[] originals, final boolean includeDefaultPackage) throws JavaModelException {
        final ArrayList packageList = new ArrayList();
        if (originals == null) {
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            IJavaModel model = JavaCore.create((IWorkspaceRoot)wsroot);
            originals = model.getJavaProjects();
        }
        final IJavaProject[] projects = originals;
        final JavaModelException[] exception = new JavaModelException[1];
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(shell);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    HashSet<String> packageNameSet = new HashSet<String>();
                    monitor.beginTask(DebugUIMessages.getString("JDIDebugUIPlugin.Searching_1"), projects.length);
                    int i = 0;
                    while (i < projects.length) {
                        IPackageFragment[] pkgs = projects[i].getPackageFragments();
                        int j = 0;
                        while (j < pkgs.length) {
                            IPackageFragment pkg = pkgs[j];
                            if (pkg.hasChildren() || pkg.getNonJavaResources().length <= 0) {
                                String pkgName = pkg.getElementName();
                                if ((includeDefaultPackage || pkgName.length() != 0) && packageNameSet.add(pkgName)) {
                                    packageList.add(pkg);
                                }
                            }
                            ++j;
                        }
                        monitor.worked(1);
                        ++i;
                    }
                    monitor.done();
                }
                catch (JavaModelException jme) {
                    exception[0] = jme;
                }
            }
        };
        try {
            monitor.run(false, false, r);
        }
        catch (InvocationTargetException e) {
            JDIDebugUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            JDIDebugUIPlugin.log(e);
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        int flags = JavaElementLabelProvider.SHOW_DEFAULT;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(flags));
        dialog.setIgnoreCase(false);
        dialog.setElements(packageList.toArray());
        return dialog;
    }

    public ILaunchConfigurationTab getVMInstallTypePage(String vmInstallTypeID) {
        if (this.fVmInstallTypePageMap == null) {
            this.initializeVMInstallTypePageMap();
        }
        IConfigurationElement configElement = (IConfigurationElement)this.fVmInstallTypePageMap.get(vmInstallTypeID);
        ILaunchConfigurationTab tab = null;
        if (configElement != null) {
            try {
                tab = (ILaunchConfigurationTab)configElement.createExecutableExtension("class");
            }
            catch (CoreException ce) {
                JDIDebugUIPlugin.log((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, DebugUIMessages.getString("JDIDebugUIPlugin.An_error_occurred_retrieving_a_VMInstallType_page_1"), (Throwable)ce));
            }
        }
        return tab;
    }

    protected void initializeVMInstallTypePageMap() {
        this.fVmInstallTypePageMap = new HashMap(10);
        IPluginDescriptor descriptor = JDIDebugUIPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("vmInstallTypePage");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            String id = infos[i].getAttribute("vmInstallTypeID");
            this.fVmInstallTypePageMap.put(id, infos[i]);
            ++i;
        }
    }

    public IDebugModelPresentation getModelPresentation() {
        if (this.fUtilPresentation == null) {
            this.fUtilPresentation = DebugUITools.newDebugModelPresentation((String)JDIDebugModel.getPluginIdentifier());
        }
        return this.fUtilPresentation;
    }
}

