/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookLauncher;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EvaluationContextManager
implements IWindowListener,
IPageListener,
ISelectionListener,
IPartListener2 {
    private static EvaluationContextManager fgManager;
    private Map fContextsByPage = null;
    static /* synthetic */ Class class$0;

    private EvaluationContextManager() {
    }

    public static void startup() {
        Runnable r = new Runnable(){

            public void run() {
                if (fgManager == null) {
                    fgManager = new EvaluationContextManager(null);
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        fgManager.windowOpened(windows[i]);
                        ++i;
                    }
                    workbench.addWindowListener((IWindowListener)fgManager);
                }
            }
        };
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(r);
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.windowOpened(window);
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.removePageListener((IPageListener)this);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        IWorkbenchPage[] pages = window.getPages();
        int i = 0;
        while (i < pages.length) {
            window.addPageListener((IPageListener)this);
            this.pageOpened(pages[i]);
            ++i;
        }
    }

    public void pageActivated(IWorkbenchPage page) {
        this.pageOpened(page);
    }

    public void pageClosed(IWorkbenchPage page) {
        page.removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        page.removePartListener((IPartListener2)this);
    }

    public void pageOpened(IWorkbenchPage page) {
        page.addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        page.addPartListener((IPartListener2)this);
        IWorkbenchPartReference ref = page.getActivePartReference();
        if (ref != null) {
            this.partActivated(ref);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object element;
        IStructuredSelection ss;
        IWorkbenchPage page = part.getSite().getPage();
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IAdaptable) {
            IJavaStackFrame frame;
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((frame = (IJavaStackFrame)iAdaptable.getAdapter((Class)clazz)) != null && frame.getLaunch().getAttribute(ScrapbookLauncher.SCRAPBOOK_LAUNCH) == null) {
                this.setContext(page, frame);
                return;
            }
        }
        this.removeContext(page);
    }

    private void setContext(IWorkbenchPage page, IJavaStackFrame frame) {
        if (this.fContextsByPage == null) {
            this.fContextsByPage = new HashMap();
        }
        this.fContextsByPage.put(page, frame);
        System.setProperty(String.valueOf(JDIDebugUIPlugin.getUniqueIdentifier()) + ".debuggerActive", "true");
    }

    private void removeContext(IWorkbenchPage page) {
        if (this.fContextsByPage != null) {
            this.fContextsByPage.remove(page);
            if (this.fContextsByPage.isEmpty()) {
                System.setProperty(String.valueOf(JDIDebugUIPlugin.getUniqueIdentifier()) + ".debuggerActive", "false");
            }
        }
    }

    private static IJavaStackFrame getContext(IWorkbenchPage page) {
        if (fgManager != null && EvaluationContextManager.fgManager.fContextsByPage != null) {
            return (IJavaStackFrame)EvaluationContextManager.fgManager.fContextsByPage.get(page);
        }
        return null;
    }

    public static IJavaStackFrame getEvaluationContext(IWorkbenchPart part) {
        IWorkbenchPage page = part.getSite().getPage();
        IJavaStackFrame frame = EvaluationContextManager.getContext(page);
        if (frame == null) {
            return EvaluationContextManager.getEvaluationContext(page.getWorkbenchWindow());
        }
        return frame;
    }

    public static IJavaStackFrame getEvaluationContext(IWorkbenchWindow window) {
        ArrayList alreadyVisited = new ArrayList();
        return EvaluationContextManager.getEvaluationContext(window, alreadyVisited);
    }

    private static IJavaStackFrame getEvaluationContext(IWorkbenchWindow window, List alreadyVisited) {
        IWorkbenchPage activePage = window.getActivePage();
        IJavaStackFrame frame = null;
        if (activePage != null) {
            frame = EvaluationContextManager.getContext(activePage);
        }
        if (frame == null) {
            IWorkbenchPage[] pages = window.getPages();
            int i = 0;
            while (i < pages.length) {
                if (activePage != pages[i] && (frame = EvaluationContextManager.getContext(pages[i])) != null) {
                    return frame;
                }
                ++i;
            }
            alreadyVisited.add(window);
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i2 = 0;
            while (i2 < windows.length) {
                if (!alreadyVisited.contains(windows[i2]) && (frame = EvaluationContextManager.getEvaluationContext(windows[i2], alreadyVisited)) != null) {
                    return frame;
                }
                ++i2;
            }
            return null;
        }
        return frame;
    }

    public void partActivated(IWorkbenchPartReference ref) {
        if ("org.eclipse.jdt.debug.ui.SnippetEditor".equals(ref.getId())) {
            System.setProperty(String.valueOf(JDIDebugUIPlugin.getUniqueIdentifier()) + ".scrapbookActive", "true");
        } else {
            System.setProperty(String.valueOf(JDIDebugUIPlugin.getUniqueIdentifier()) + ".scrapbookActive", "false");
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference ref) {
    }

    public void partClosed(IWorkbenchPartReference ref) {
        if (ref.getId().equals("org.eclipse.debug.ui.DebugView")) {
            this.removeContext(ref.getPage());
        }
    }

    public void partDeactivated(IWorkbenchPartReference ref) {
    }

    public void partOpened(IWorkbenchPartReference ref) {
    }

    public void partHidden(IWorkbenchPartReference ref) {
    }

    public void partVisible(IWorkbenchPartReference ref) {
    }

    public void partInputChanged(IWorkbenchPartReference ref) {
    }

    /* synthetic */ EvaluationContextManager(EvaluationContextManager evaluationContextManager) {
        this();
    }
}

