/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ErrorDialogWithToggle
extends ErrorDialog {
    private String fPreferenceKey = null;
    private String fToggleMessage = null;
    private Button fToggleButton = null;
    IPreferenceStore fStore = null;

    public ErrorDialogWithToggle(Shell parentShell, String dialogTitle, String message, IStatus status, String preferenceKey, String toggleMessage, IPreferenceStore store) {
        super(parentShell, dialogTitle, message, status, 7);
        this.fStore = store;
        this.fPreferenceKey = preferenceKey;
        this.fToggleMessage = toggleMessage;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setFont(parent.getFont());
        this.setToggleButton(this.createCheckButton(dialogArea, this.fToggleMessage));
        this.getToggleButton().setSelection(this.fStore.getBoolean(this.fPreferenceKey));
        Dialog.applyDialogFont((Control)dialogArea);
        return dialogArea;
    }

    private Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        GridData data = new GridData(0);
        data.horizontalSpan = 2;
        data.horizontalAlignment = 2;
        button.setLayoutData((Object)data);
        button.setFont(parent.getFont());
        return button;
    }

    protected void buttonPressed(int id) {
        if (id == 0) {
            this.storePreference();
        }
        super.buttonPressed(id);
    }

    private void storePreference() {
        this.fStore.setValue(this.fPreferenceKey, this.getToggleButton().getSelection());
    }

    protected Button getToggleButton() {
        return this.fToggleButton;
    }

    protected void setToggleButton(Button button) {
        this.fToggleButton = button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setFocus();
    }
}

