/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodFinder;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavaMainTab
extends JavaLaunchConfigurationTab {
    protected Label fProjLabel;
    protected Text fProjText;
    protected Button fProjButton;
    protected Label fMainLabel;
    protected Text fMainText;
    protected Button fSearchButton;
    protected Button fSearchExternalJarsCheckButton;
    protected Button fStopInMainCheckButton;
    protected static final String EMPTY_STRING = "";
    public static final String ATTR_INCLUDE_EXTERNAL_JARS = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".INCLUDE_EXTERNAL_JARS";

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_MAIN_TAB);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        Composite projComp = new Composite(comp, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        projComp.setLayoutData((Object)gd);
        projComp.setFont(font);
        this.fProjLabel = new Label(projComp, 0);
        this.fProjLabel.setText(LauncherMessages.getString("JavaMainTab.&Project__2"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProjLabel.setLayoutData((Object)gd);
        this.fProjLabel.setFont(font);
        this.fProjText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JavaMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProjButton = this.createPushButton(projComp, LauncherMessages.getString("JavaMainTab.&Browse_3"), null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaMainTab.this.handleProjectButtonSelected();
            }
        });
        this.createVerticalSpacer(comp, 1);
        Composite mainComp = new Composite(comp, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 2;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        gd = new GridData(768);
        mainComp.setLayoutData((Object)gd);
        mainComp.setFont(font);
        this.fMainLabel = new Label(mainComp, 0);
        this.fMainLabel.setText(LauncherMessages.getString("JavaMainTab.Main_cla&ss__4"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fMainLabel.setLayoutData((Object)gd);
        this.fMainLabel.setFont(font);
        this.fMainText = new Text(mainComp, 2052);
        gd = new GridData(768);
        this.fMainText.setLayoutData((Object)gd);
        this.fMainText.setFont(font);
        this.fMainText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JavaMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSearchButton = this.createPushButton(mainComp, LauncherMessages.getString("JavaMainTab.Searc&h_5"), null);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaMainTab.this.handleSearchButtonSelected();
            }
        });
        this.fSearchExternalJarsCheckButton = new Button(mainComp, 32);
        this.fSearchExternalJarsCheckButton.setText(LauncherMessages.getString("JavaMainTab.E&xt._jars_6"));
        this.fSearchExternalJarsCheckButton.setFont(font);
        this.fSearchExternalJarsCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fStopInMainCheckButton = new Button(comp, 32);
        this.fStopInMainCheckButton.setText(LauncherMessages.getString("JavaMainTab.St&op_in_main_1"));
        this.fStopInMainCheckButton.setFont(font);
        this.fStopInMainCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateProjectFromConfig(config);
        this.updateMainTypeFromConfig(config);
        this.updateStopInMainFromConfig(config);
        this.updateExternalJars(config);
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = EMPTY_STRING;
        try {
            projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.fProjText.setText(projectName);
    }

    protected void updateMainTypeFromConfig(ILaunchConfiguration config) {
        String mainTypeName = EMPTY_STRING;
        try {
            mainTypeName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, EMPTY_STRING);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.fMainText.setText(mainTypeName);
    }

    protected void updateStopInMainFromConfig(ILaunchConfiguration configuration) {
        boolean stop = false;
        try {
            stop = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        this.fStopInMainCheckButton.setSelection(stop);
    }

    protected void updateExternalJars(ILaunchConfiguration configuration) {
        boolean search = false;
        try {
            search = configuration.getAttribute(ATTR_INCLUDE_EXTERNAL_JARS, false);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        this.fSearchExternalJarsCheckButton.setSelection(search);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fMainText.getText());
        if (this.fStopInMainCheckButton.getSelection()) {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, true);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, null);
        }
        if (this.fSearchExternalJarsCheckButton.getSelection()) {
            config.setAttribute(ATTR_INCLUDE_EXTERNAL_JARS, true);
        } else {
            config.setAttribute(ATTR_INCLUDE_EXTERNAL_JARS, null);
        }
    }

    public void dispose() {
    }

    protected void handleSearchButtonSelected() {
        IJavaProject javaProject = this.getJavaProject();
        IJavaSearchScope searchScope = null;
        searchScope = javaProject == null || !javaProject.exists() ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject}, (boolean)false);
        int constraints = 8;
        if (this.fSearchExternalJarsCheckButton.getSelection()) {
            constraints |= 0x10;
        }
        Shell shell = this.getShell();
        SelectionDialog dialog = JavaUI.createMainTypeDialog((Shell)shell, (IRunnableContext)this.getLaunchConfigurationDialog(), (IJavaSearchScope)searchScope, (int)constraints, (boolean)false, (String)this.fMainText.getText());
        dialog.setTitle(LauncherMessages.getString("JavaMainTab.Choose_Main_Type_11"));
        dialog.setMessage(LauncherMessages.getString("JavaMainTab.Choose_a_main_&type_to_launch__12"));
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        IType type = (IType)results[0];
        if (type != null) {
            this.fMainText.setText(type.getFullyQualifiedName());
            javaProject = type.getJavaProject();
            this.fProjText.setText(javaProject.getElementName());
        }
    }

    protected void handleProjectButtonSelected() {
        IJavaProject project = this.chooseJavaProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
    }

    protected IJavaProject chooseJavaProject() {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(LauncherMessages.getString("JavaMainTab.Project_Selection_13"));
        dialog.setMessage(LauncherMessages.getString("JavaMainTab.Choose_a_&project_to_constrain_the_search_for_main_types__14"));
        dialog.setElements(projects);
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    protected IJavaProject getJavaProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0 && !ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
            this.setErrorMessage(LauncherMessages.getString("JavaMainTab.Project_does_not_exist_15"));
            return false;
        }
        name = this.fMainText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(LauncherMessages.getString("JavaMainTab.Main_type_not_specified_16"));
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        }
        this.initializeMainTypeAndName(javaElement, config);
    }

    protected void initializeMainTypeAndName(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        String name = null;
        if (javaElement instanceof IMember) {
            IMember member = (IMember)javaElement;
            javaElement = member.isBinary() ? member.getClassFile() : member.getCompilationUnit();
        }
        if (javaElement instanceof ICompilationUnit || javaElement instanceof IClassFile) {
            try {
                IType[] types = MainMethodFinder.findTargets((IRunnableContext)new BusyIndicatorRunnableContext(), new Object[]{javaElement});
                if (types != null && types.length > 0) {
                    name = types[0].getFullyQualifiedName();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        if (name == null) {
            name = EMPTY_STRING;
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, name);
        if (name.length() > 0) {
            int index = name.lastIndexOf(46);
            if (index > 0) {
                name = name.substring(index + 1);
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
        }
    }

    public String getName() {
        return LauncherMessages.getString("JavaMainTab.&Main_19");
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
    }
}

