/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.AddVMDialog;
import org.eclipse.jdt.internal.debug.ui.launcher.IAddVMDialogRequestor;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavaJRETab
extends JavaLaunchConfigurationTab
implements IAddVMDialogRequestor {
    protected Label fJRELabel;
    protected Combo fJRECombo;
    protected Button fJREAddButton;
    protected String fUnknownVMType;
    protected String fUnknownVMName;
    protected boolean fOkToClearUnknownVM = true;
    protected IVMInstallType[] fVMTypes;
    protected List fVMStandins;
    protected ILaunchConfigurationTab fDynamicTab;
    protected Composite fDynamicTabHolder;
    protected boolean fUseDynamicArea = true;
    protected ILaunchConfigurationWorkingCopy fWorkingCopy;
    protected ILaunchConfiguration fLaunchConfiguration;
    protected boolean fIsInitializing = false;
    protected static final String DEFAULT_JRE_NAME_PREFIX = LauncherMessages.getString("JavaJRETab.Default_1");
    protected static final String EMPTY_STRING = "";
    protected String fDefaultVMName;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite topComp = new Composite(parent, 0);
        this.setControl((Control)topComp);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_JRE_TAB);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        topComp.setLayout((Layout)topLayout);
        GridData gd = new GridData(768);
        topComp.setLayoutData((Object)gd);
        topComp.setFont(font);
        this.createVerticalSpacer(topComp, 2);
        this.fJRELabel = new Label(topComp, 0);
        this.fJRELabel.setText(LauncherMessages.getString("JavaJRETab.Run_with_JRE__1"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fJRELabel.setLayoutData((Object)gd);
        this.fJRELabel.setFont(font);
        this.fJRECombo = new Combo(topComp, 8);
        gd = new GridData(768);
        this.fJRECombo.setLayoutData((Object)gd);
        this.fJRECombo.setFont(font);
        this.initializeJREComboBox();
        this.fJRECombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JavaJRETab.this.handleJREComboBoxModified();
            }
        });
        this.fJREAddButton = this.createPushButton(topComp, LauncherMessages.getString("JavaJRETab.Add"), null);
        this.fJREAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaJRETab.this.handleJREAddButtonSelected();
            }
        });
        Composite dynTabComp = new Composite(topComp, 0);
        dynTabComp.setFont(font);
        this.setDynamicTabHolder(dynTabComp);
        GridLayout tabHolderLayout = new GridLayout();
        tabHolderLayout.marginHeight = 0;
        tabHolderLayout.marginWidth = 0;
        tabHolderLayout.numColumns = 1;
        this.getDynamicTabHolder().setLayout((Layout)tabHolderLayout);
        gd = new GridData(1808);
        this.getDynamicTabHolder().setLayoutData((Object)gd);
    }

    protected void setDynamicTabHolder(Composite tabHolder) {
        this.fDynamicTabHolder = tabHolder;
    }

    protected Composite getDynamicTabHolder() {
        return this.fDynamicTabHolder;
    }

    protected void setDynamicTab(ILaunchConfigurationTab tab) {
        this.fDynamicTab = tab;
    }

    protected ILaunchConfigurationTab getDynamicTab() {
        return this.fDynamicTab;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.setLaunchConfigurationWorkingCopy(config);
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.setDefaults(config);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fIsInitializing = true;
        this.fOkToClearUnknownVM = false;
        if (this.getLaunchConfiguration() != null && !configuration.equals(this.getLaunchConfiguration())) {
            this.fUnknownVMName = null;
            this.fUnknownVMType = null;
        }
        this.setLaunchConfiguration(configuration);
        this.updateJREFromConfig(configuration);
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.initializeFrom(configuration);
        }
        this.fOkToClearUnknownVM = true;
        this.fIsInitializing = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fUnknownVMName == null) {
            ILaunchConfigurationTab dynamicTab;
            int selectedIndex = this.fJRECombo.getSelectionIndex();
            if (selectedIndex > -1) {
                String selectedVMName = this.fJRECombo.getItem(selectedIndex);
                VMStandin vmStandin = this.getVMStandin(selectedVMName);
                String vmName = null;
                String vmTypeID = null;
                if (vmStandin != null) {
                    vmName = vmStandin.getName();
                    vmTypeID = vmStandin.getVMInstallType().getId();
                }
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vmName);
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, vmTypeID);
            }
            if ((dynamicTab = this.getDynamicTab()) == null) {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
            } else {
                dynamicTab.performApply(configuration);
            }
        }
    }

    private VMStandin getVMStandin(String vmName) {
        if (vmName.equals(this.fDefaultVMName)) {
            return null;
        }
        Iterator iterator = this.fVMStandins.iterator();
        while (iterator.hasNext()) {
            VMStandin vmStandin = (VMStandin)iterator.next();
            if (!vmStandin.getName().equals(vmName)) continue;
            return vmStandin;
        }
        return null;
    }

    public boolean isValid(ILaunchConfiguration config) {
        ILaunchConfigurationTab dynamicTab;
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fUnknownVMName != null) {
            this.setErrorMessage(MessageFormat.format(LauncherMessages.getString("JavaJRETab.Configuration_specifies_undefined_JRE_-_{0}_1"), this.fUnknownVMName));
            return false;
        }
        int selectedIndex = this.fJRECombo.getSelectionIndex();
        if (selectedIndex > 0) {
            VMStandin vmStandin = (VMStandin)this.fVMStandins.get(selectedIndex - 1);
            IVMInstall vm = vmStandin.convertToRealVM();
            File location = vm.getInstallLocation();
            if (location == null) {
                this.setErrorMessage(LauncherMessages.getString("JavaJRETab.JRE_home_directory_not_specified_36"));
                return false;
            }
            if (!location.exists()) {
                this.setErrorMessage(LauncherMessages.getString("JavaJRETab.JRE_home_directory_does_not_exist_37"));
                return false;
            }
        } else if (selectedIndex < 0) {
            this.setErrorMessage(LauncherMessages.getString("JavaJRETab.JRE_not_specified_38"));
            return false;
        }
        if ((dynamicTab = this.getDynamicTab()) != null) {
            return dynamicTab.isValid(config);
        }
        return true;
    }

    public String getName() {
        return LauncherMessages.getString("JavaJRETab.&JRE_1");
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.library_obj.gif");
    }

    public boolean isDuplicateName(String name) {
        if (name.equals(this.fDefaultVMName)) {
            return true;
        }
        int i = 0;
        while (i < this.fVMStandins.size()) {
            IVMInstall vm = (IVMInstall)this.fVMStandins.get(i);
            if (vm.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void vmAdded(IVMInstall vm) {
        ((VMStandin)vm).convertToRealVM();
        try {
            JavaRuntime.saveVMConfiguration();
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        this.fVMStandins.add(vm);
        this.populateJREComboBox();
        this.selectJREComboBoxEntry(vm.getVMInstallType().getId(), vm.getName());
    }

    protected void updateJREFromConfig(ILaunchConfiguration config) {
        String vmName = null;
        String vmTypeID = null;
        try {
            vmTypeID = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
            vmName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.populateJREComboBox();
        this.selectJREComboBoxEntry(vmTypeID, vmName);
    }

    protected void initializeJREComboBox() {
        this.fVMTypes = JavaRuntime.getVMInstallTypes();
        this.fVMStandins = this.createFakeVMInstalls(this.fVMTypes);
        this.populateJREComboBox();
    }

    protected void handleJREComboBoxModified() {
        if (this.fOkToClearUnknownVM) {
            this.fUnknownVMName = null;
            this.fUnknownVMType = null;
        }
        this.loadDynamicJREArea();
        ILaunchConfigurationWorkingCopy wc = this.getLaunchConfigurationWorkingCopy();
        if (this.getDynamicTab() == null) {
            if (wc == null && this.getLaunchConfiguration().isWorkingCopy()) {
                wc = (ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration();
            }
            if (!this.fIsInitializing && wc != null) {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
            }
        } else {
            if (wc == null) {
                try {
                    wc = this.getLaunchConfiguration().isWorkingCopy() ? ((ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration()).getOriginal().getWorkingCopy() : this.getLaunchConfiguration().getWorkingCopy();
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.errorDialog(LauncherMessages.getString("JavaJRETab.Unable_to_initialize_defaults_for_selected_JRE_1"), e);
                    return;
                }
            }
            if (!this.fIsInitializing) {
                this.getDynamicTab().setDefaults(wc);
                this.getDynamicTab().initializeFrom((ILaunchConfiguration)wc);
            }
        }
        this.updateLaunchConfigurationDialog();
    }

    protected void handleJREAddButtonSelected() {
        AddVMDialog dialog = new AddVMDialog(this, this.getShell(), this.fVMTypes, null);
        dialog.setTitle(LauncherMessages.getString("vmPreferencePage.addJRE.title"));
        if (dialog.open() != 0) {
            return;
        }
    }

    protected void populateJREComboBox() {
        ILaunchConfiguration config = this.getLaunchConfiguration();
        IVMInstall defaultVM = null;
        if (config != null) {
            try {
                defaultVM = JavaRuntime.computeVMInstall((ILaunchConfiguration)config);
            }
            catch (CoreException coreException) {}
        }
        if (defaultVM == null) {
            defaultVM = JavaRuntime.getDefaultVMInstall();
        }
        int numVMs = this.fVMStandins.size();
        if (defaultVM != null) {
            ++numVMs;
        }
        ArrayList<String> vmNames = new ArrayList<String>(numVMs);
        Iterator iterator = this.fVMStandins.iterator();
        while (iterator.hasNext()) {
            VMStandin standin = (VMStandin)iterator.next();
            String vmName = standin.getName();
            vmNames.add(vmName);
        }
        Collections.sort(vmNames);
        if (defaultVM != null) {
            this.fDefaultVMName = this.constructDefaultJREName(defaultVM);
            vmNames.add(0, this.fDefaultVMName);
        }
        this.fJRECombo.setItems(vmNames.toArray(new String[vmNames.size()]));
    }

    protected String constructDefaultJREName(IVMInstall defaultVM) {
        String defaultVMName = defaultVM.getName();
        return String.valueOf(DEFAULT_JRE_NAME_PREFIX) + " (" + defaultVMName + ')';
    }

    protected void selectJREComboBoxEntry_OLD(String typeID, String vmName) {
        int index = 0;
        int offset = 0;
        if (this.fDefaultVMName != null) {
            ++offset;
        }
        if (typeID != null && vmName != null) {
            boolean found = false;
            int i = 0;
            while (i < this.fVMStandins.size()) {
                VMStandin vmStandin = (VMStandin)this.fVMStandins.get(i);
                if (vmStandin.getVMInstallType().getId().equals(typeID) && vmStandin.getName().equals(vmName)) {
                    index = i + offset;
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                this.fUnknownVMName = vmName;
                this.fUnknownVMType = typeID;
            }
        }
        this.fJRECombo.select(index);
    }

    protected void selectJREComboBoxEntry(String typeID, String vmName) {
        int index;
        boolean alreadyTriedDefault = false;
        String searchName = vmName;
        if (searchName == null || typeID == null) {
            searchName = this.fDefaultVMName;
            alreadyTriedDefault = true;
        }
        if ((index = this.getVMNameIndex(searchName)) == -1) {
            this.fUnknownVMName = vmName;
            this.fUnknownVMType = typeID;
            if (!alreadyTriedDefault) {
                index = this.getVMNameIndex(this.fDefaultVMName);
                if (index == -1) {
                    index = 0;
                }
            } else {
                index = 0;
            }
        }
        this.fJRECombo.select(index);
    }

    protected int getVMNameIndex(String searchVMName) {
        String[] vmNames = this.fJRECombo.getItems();
        int i = 0;
        while (i < vmNames.length) {
            if (vmNames[i].equals(searchVMName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void clearJREComboBoxEntry() {
        this.fJRECombo.deselectAll();
    }

    private List createFakeVMInstalls(IVMInstallType[] vmTypes) {
        ArrayList<VMStandin> vms = new ArrayList<VMStandin>();
        int i = 0;
        while (i < vmTypes.length) {
            IVMInstall[] vmInstalls = vmTypes[i].getVMInstalls();
            int j = 0;
            while (j < vmInstalls.length) {
                vms.add(new VMStandin(vmInstalls[j]));
                ++j;
            }
            ++i;
        }
        return vms;
    }

    protected ILaunchConfigurationTab getTabForCurrentJRE() {
        VMStandin vmStandin;
        int selectedIndex = this.fJRECombo.getSelectionIndex();
        if (selectedIndex > 0 && (vmStandin = this.getVMStandin(this.fJRECombo.getText())) != null) {
            String vmInstallTypeID = vmStandin.getVMInstallType().getId();
            return JDIDebugUIPlugin.getDefault().getVMInstallTypePage(vmInstallTypeID);
        }
        return null;
    }

    protected void loadDynamicJREArea() {
        Control[] children = this.getDynamicTabHolder().getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        if (this.isUseDynamicJREArea()) {
            this.setDynamicTab(this.getTabForCurrentJRE());
            if (this.getDynamicTab() == null) {
                return;
            }
            this.getDynamicTab().setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
            this.getDynamicTab().createControl(this.getDynamicTabHolder());
            this.getDynamicTabHolder().layout();
        }
    }

    protected ILaunchConfigurationWorkingCopy getLaunchConfigurationWorkingCopy() {
        return this.fWorkingCopy;
    }

    public String getErrorMessage() {
        ILaunchConfigurationTab tab = this.getDynamicTab();
        if (super.getErrorMessage() != null || tab == null) {
            return super.getErrorMessage();
        }
        return tab.getErrorMessage();
    }

    protected void setLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fWorkingCopy = workingCopy;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        this.fLaunchConfiguration = launchConfiguration;
    }

    public void setVMSpecificArgumentsVisible(boolean visible) {
        this.fUseDynamicArea = visible;
    }

    protected boolean isUseDynamicJREArea() {
        return this.fUseDynamicArea;
    }
}

