/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.AddAdvancedAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddExternalFolderAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddExternalJarAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddFolderAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddJarAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddProjectAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddVariableAction;
import org.eclipse.jdt.internal.debug.ui.actions.AttachSourceAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveDownAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveUpAction;
import org.eclipse.jdt.internal.debug.ui.actions.RemoveAction;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.RuntimeClasspathViewer;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavaClasspathTab
extends JavaLaunchConfigurationTab {
    protected TabFolder fPathTabFolder;
    protected TabItem fBootPathTabItem;
    protected TabItem fClassPathTabItem;
    protected RuntimeClasspathViewer fClasspathViewer;
    protected RuntimeClasspathViewer fBootpathViewer;
    protected Button fClassPathDefaultButton;
    protected List fActions = new ArrayList(10);
    protected Image fImage = null;
    protected static final String DIALOG_SETTINGS_PREFIX = "JavaClasspathTab";
    protected ILaunchConfiguration fLaunchConfiguration;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_CLASSPATH_TAB);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 2);
        this.fPathTabFolder = new TabFolder(comp, 0);
        GridData gd = new GridData(1808);
        this.fPathTabFolder.setLayoutData((Object)gd);
        this.fPathTabFolder.setFont(font);
        this.fPathTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabItem[] tabs = JavaClasspathTab.this.fPathTabFolder.getSelection();
                if (tabs.length == 1) {
                    RuntimeClasspathViewer data = (RuntimeClasspathViewer)((Object)tabs[0].getData());
                    JavaClasspathTab.this.retargetActions(data);
                }
            }
        });
        this.fClasspathViewer = new RuntimeClasspathViewer((Composite)this.fPathTabFolder);
        this.fClasspathViewer.addEntriesChangedListener(this);
        this.fClasspathViewer.getControl().setFont(font);
        this.fClassPathTabItem = new TabItem(this.fPathTabFolder, 0, 0);
        this.fClassPathTabItem.setText(LauncherMessages.getString("JavaClasspathTab.Us&er_classes_1"));
        this.fClassPathTabItem.setControl(this.fClasspathViewer.getControl());
        this.fClassPathTabItem.setData((Object)this.fClasspathViewer);
        this.fBootpathViewer = new RuntimeClasspathViewer((Composite)this.fPathTabFolder);
        this.fBootpathViewer.addEntriesChangedListener(this);
        this.fBootpathViewer.getControl().setFont(font);
        this.fBootPathTabItem = new TabItem(this.fPathTabFolder, 0, 1);
        this.fBootPathTabItem.setText(LauncherMessages.getString("JavaClasspathTab.&Bootstrap_classes_2"));
        this.fBootPathTabItem.setControl(this.fBootpathViewer.getControl());
        this.fBootPathTabItem.setData((Object)this.fBootpathViewer);
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.createVerticalSpacer(comp, 2);
        this.fClassPathDefaultButton = new Button(comp, 32);
        this.fClassPathDefaultButton.setText(LauncherMessages.getString("JavaEnvironmentTab.Use_defau&lt_classpath_10"));
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fClassPathDefaultButton.setLayoutData((Object)gd);
        this.fClassPathDefaultButton.setFont(font);
        this.fClassPathDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaClasspathTab.this.handleClasspathDefaultButtonSelected();
            }
        });
        this.createVerticalSpacer(pathButtonComp, 1);
        ArrayList<RuntimeClasspathAction> advancedActions = new ArrayList<RuntimeClasspathAction>(5);
        RuntimeClasspathAction action = new MoveUpAction(null);
        Button button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        this.addAction(action);
        action = new MoveDownAction(null);
        button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        this.addAction(action);
        action = new RemoveAction(null);
        button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        this.addAction(action);
        action = new AddProjectAction(null);
        button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        this.addAction(action);
        action = new AddJarAction(null);
        button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        this.addAction(action);
        action = new AddExternalJarAction(null, DIALOG_SETTINGS_PREFIX);
        button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        this.addAction(action);
        action = new AddFolderAction(null);
        advancedActions.add(action);
        action = new AddExternalFolderAction(null, DIALOG_SETTINGS_PREFIX);
        advancedActions.add(action);
        action = new AddVariableAction(null);
        advancedActions.add(action);
        action = new AttachSourceAction(null);
        advancedActions.add(action);
        IAction[] adv = advancedActions.toArray(new IAction[advancedActions.size()]);
        action = new AddAdvancedAction(null, adv);
        button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        this.addAction(action);
        this.retargetActions(this.fClasspathViewer);
    }

    protected void handleClasspathDefaultButtonSelected() {
        boolean useDefault = this.fClassPathDefaultButton.getSelection();
        this.fClassPathDefaultButton.setSelection(useDefault);
        if (useDefault) {
            this.displayDefaultClasspath();
        }
        this.fClasspathViewer.setEnabled(!useDefault);
        this.fBootpathViewer.setEnabled(!useDefault);
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        boolean useDefault;
        block5: {
            useDefault = true;
            try {
                useDefault = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
            if (configuration == this.getLaunchConfiguration() && !useDefault && !this.fClassPathDefaultButton.getSelection()) {
                this.setDirty(false);
                return;
            }
            this.setLaunchConfiguration(configuration);
            this.fClassPathDefaultButton.setSelection(useDefault);
            try {
                this.setClasspathEntries(JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration));
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 107) break block5;
                JDIDebugUIPlugin.log(e);
            }
        }
        this.fClasspathViewer.setEnabled(!useDefault);
        this.fBootpathViewer.setEnabled(!useDefault);
        this.fClasspathViewer.setLaunchConfiguration(configuration);
        this.fBootpathViewer.setLaunchConfiguration(configuration);
        this.setDirty(false);
    }

    protected void displayDefaultClasspath() {
        ILaunchConfiguration config = this.getLaunchConfiguration();
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            wc = config.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)config : config.getWorkingCopy();
            this.performApply(wc);
            this.setClasspathEntries(JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)wc));
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    protected void setClasspathEntries(IRuntimeClasspathEntry[] entries) {
        ArrayList<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>(entries.length);
        ArrayList<IRuntimeClasspathEntry> bp = new ArrayList<IRuntimeClasspathEntry>(entries.length);
        int i = 0;
        while (i < entries.length) {
            switch (entries[i].getClasspathProperty()) {
                case 3: {
                    cp.add(entries[i]);
                    break;
                }
                default: {
                    bp.add(entries[i]);
                }
            }
            ++i;
        }
        this.fClasspathViewer.setEntries(cp.toArray(new IRuntimeClasspathEntry[cp.size()]));
        this.fBootpathViewer.setEntries(bp.toArray(new IRuntimeClasspathEntry[bp.size()]));
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isDirty()) {
            boolean def = this.fClassPathDefaultButton.getSelection();
            if (def) {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, null);
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, null);
            } else {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
                try {
                    IRuntimeClasspathEntry[] boot = this.fBootpathViewer.getEntries();
                    IRuntimeClasspathEntry[] user = this.fClasspathViewer.getEntries();
                    ArrayList<String> mementos = new ArrayList<String>(boot.length + user.length);
                    int i = 0;
                    while (i < boot.length) {
                        boot[i].setClasspathProperty(2);
                        mementos.add(boot[i].getMemento());
                        ++i;
                    }
                    i = 0;
                    while (i < user.length) {
                        user[i].setClasspathProperty(3);
                        mementos.add(user[i].getMemento());
                        ++i;
                    }
                    configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.errorDialog(LauncherMessages.getString("JavaClasspathTab.Unable_to_save_classpath_1"), e);
                }
            }
        }
    }

    public String getName() {
        return LauncherMessages.getString("JavaClasspathTab.Cla&ss_path_3");
    }

    public Image getImage() {
        if (this.fImage == null) {
            this.fImage = JavaPluginImages.DESC_TOOL_CLASSPATH_ORDER.createImage();
        }
        return this.fImage;
    }

    protected void setLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfiguration = config;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected void addAction(RuntimeClasspathAction action) {
        this.fActions.add(action);
    }

    protected void retargetActions(RuntimeClasspathViewer viewer) {
        Iterator actions = this.fActions.iterator();
        while (actions.hasNext()) {
            RuntimeClasspathAction action = (RuntimeClasspathAction)((Object)actions.next());
            action.setViewer(viewer);
        }
    }

    public void dispose() {
        if (this.fClasspathViewer != null) {
            this.fClasspathViewer.removeEntriesChangedListener(this);
            this.fBootpathViewer.removeEntriesChangedListener(this);
        }
        if (this.fImage != null) {
            this.fImage.dispose();
        }
        super.dispose();
    }
}

