/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.viewdesigner.wizards.refactor;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.refactoring.MDORefactoringTask;
import com.sap.ide.metamodel.general.refactoring.RefactoringRequest;
import com.sap.ide.metamodel.webdynpro.WebDynproMDOEnum;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.webdynpro.generation.eclipse.deletion.DeletionService;
import com.sap.ide.webdynpro.service.controllereditor.NamingService;
import com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService;
import com.sap.ide.webdynpro.service.controllereditor.implementation.AmbiguousImportsException;
import com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameContentProvider;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardData;
import com.sap.ide.webdynpro.service.viewdesigner.ServiceViewDesignerPlugin;
import com.sap.ide.webdynpro.service.viewdesigner.ServicesCreation;
import com.sap.ide.webdynpro.service.viewdesigner.TextPool;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;

public class RenameViewWizard
extends RenameWizard {
    private static final TextPool mTPool = TextPool.getInstance();
    private static final CoreTextPool mCPool = CoreTextPool.getInstance();

    public RenameViewWizard(View view) {
        super((DevelopmentObject)view);
    }

    public RenameViewWizard(View view, String newName, String newPackage) {
        super((DevelopmentObject)view, newName, newPackage);
    }

    protected IStatus doSpecialRefactoringPreparation(RefactoringRequest request, DevelopmentObject developmentObject, String newName, String newPackage, SourcePathIdentifier identifier) {
        String pluginID = ServiceViewDesignerPlugin.getDefault().getDescriptor().getUniqueIdentifier();
        if (developmentObject instanceof View) {
            Controller viewController = ((View)developmentObject).getViewController();
            MDORefactoringTask viewControllerTask = (MDORefactoringTask)request.createRefactoringTask((DevelopmentObject)viewController);
            viewControllerTask.setNewSourcePathIdentifier(identifier);
            try {
                viewControllerTask.setNewName(newName);
                viewControllerTask.setNewPackage(newPackage);
            }
            catch (RuntimeException e) {
                return new Status(4, pluginID, 4, mCPool.getText(36), (Throwable)e);
            }
        }
        return new Status(0, pluginID, 0, "", null);
    }

    protected String verifyDevelopmentobjectName(String nameInput, String packageInput) {
        RenameWizardData mRenameWizardData = this.getWizardData();
        View view = null;
        Component parentComponent = null;
        DevelopmentObject developmentObject = mRenameWizardData.getObjectToRefactor();
        if (!(developmentObject instanceof View)) {
            return "Not a View";
        }
        view = (View)developmentObject;
        parentComponent = view.getComponent();
        if (parentComponent == null) {
            return "Parent Component not found";
        }
        if (!parentComponent.hasView(packageInput, nameInput)) {
            boolean viewExists = parentComponent.getRoot().getMetamodel().objectExists(packageInput, nameInput, WebDynproMDOEnum.VIEW);
            if (viewExists) {
                return mTPool.getText(8, nameInput, packageInput);
            }
            if (!nameInput.equalsIgnoreCase(parentComponent.getName() + "Interface") && !nameInput.equalsIgnoreCase(CoreTextPool.getInstance().getText(142))) {
                String viewControllerName = NamingService.getViewControllerName((String)nameInput);
                boolean controllerExists = ControllerService.doesAnyControllerExist((Component)parentComponent, (String)viewControllerName);
                if (!controllerExists) {
                    IStatus status = ServicesCreation.isValidViewCreationPath(mRenameWizardData.getObjectToRefactor().getMetamodel(), nameInput, packageInput, mRenameWizardData.getTemporarySourcePathIdentifier());
                    if (status.getSeverity() == 0) {
                        return null;
                    }
                    return status.getMessage();
                }
                return mCPool.getText(41, (Object)nameInput);
            }
            return mTPool.getText(2, nameInput);
        }
        return mTPool.getText(6, nameInput, parentComponent.getName());
    }

    protected IStructuredContentProvider getContentProvider() {
        return new RenameContentProvider();
    }

    protected void deleteImplementation(DevelopmentObject developmentObject) {
        if (developmentObject instanceof View) {
            Controller controller = ((View)developmentObject).getViewController();
            DeletionService deletionService = new DeletionService(this.getWizardData().getEclipseProject());
            deletionService.deleteController(controller, false);
        }
    }

    protected void generateImplementation(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
        if (developmentObject instanceof View) {
            Controller controller = ((View)developmentObject).getViewController();
            ControllerService.createControllerImplementation((Controller)controller, (ProgressMonitorDialog)dialog);
        }
    }

    protected void organizeImports(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
        Controller controller;
        if (developmentObject instanceof View && (controller = ((View)developmentObject).getViewController()).getCodeBody() != null) {
            dialog.getProgressMonitor().setTaskName(CoreTextPool.getInstance().getText(214));
            ImplementationService implService = new ImplementationService(controller);
            this.doOrganizeImports(implService, dialog.getProgressMonitor());
        }
    }

    private void doOrganizeImports(ImplementationService implService, IProgressMonitor monitor) {
        try {
            implService.organizeImports(true, monitor);
        }
        catch (AmbiguousImportsException ambiguousImportsException) {
            // empty catch block
        }
    }
}

