/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.viewdesigner.wizards;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.services.GenerationPathManager;
import com.sap.ide.metamodel.webdynpro.services.ServicesEclipse;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class ViewWizardData {
    private String mViewName = "";
    private String mViewPackage = "";
    private Component mComponent = null;
    private IPackageFragmentRoot[] mAllValidRoots = null;
    private IPackageFragmentRoot mSelectedRoot = null;
    private SourcePathIdentifier mSelectedSourcePathId = null;
    private IPackageFragmentRoot mTemporaryRoot = null;
    private SourcePathIdentifier mTemporarySourcePathId = null;

    ViewWizardData(Component component) {
        this.mComponent = component;
        this.initializeData();
    }

    private void initializeData() {
        String sourceText = "";
        IProject eclipseProject = com.sap.ide.metamodel.core.services.ServicesEclipse.getEclipseProject((DevelopmentObject)this.mComponent);
        IPackageFragmentRoot[] allValidRoots = GenerationPathManager.getValidSourceRoots((IProject)eclipseProject);
        this.setAllValidRoots(allValidRoots);
        IPackageFragmentRoot componentSourceRoot = ServicesEclipse.getMDOSourceRoot((MainDevelopmentObject)this.mComponent);
        this.setSelectedRoot(componentSourceRoot);
        this.setTemporaryRoot(componentSourceRoot);
        this.setViewPackage(this.mComponent.getPackage());
    }

    public String getViewName() {
        return this.mViewName;
    }

    public void setViewName(String name) {
        this.mViewName = name;
    }

    public String getViewPackage() {
        return this.mViewPackage;
    }

    public void setViewPackage(String viewPackage) {
        this.mViewPackage = viewPackage.toLowerCase();
    }

    public void setAllValidRoots(IPackageFragmentRoot[] allValidRoots) {
        this.mAllValidRoots = allValidRoots;
    }

    public IPackageFragmentRoot[] getAllValidRoots() {
        return this.mAllValidRoots;
    }

    public void setSelectedRoot(IPackageFragmentRoot selectedRoot) {
        this.mSelectedRoot = selectedRoot;
        MetamodelManager manager = MetamodelManager.getMetamodelManager((String)this.mComponent.getRoot().getMetamodel().getName());
        IPath sourcePath = manager.makePathAbsolute(this.mSelectedRoot.getPath());
        this.mSelectedSourcePathId = manager.getSourcePathIdentifier(sourcePath);
    }

    public IPackageFragmentRoot getSelectedRoot() {
        return this.mSelectedRoot;
    }

    public SourcePathIdentifier getSelectedSourcePathIdentifier() {
        return this.mSelectedSourcePathId;
    }

    public void setTemporaryRoot(IPackageFragmentRoot temporaryRoot) {
        this.mTemporaryRoot = temporaryRoot;
        MetamodelManager manager = MetamodelManager.getMetamodelManager((String)this.mComponent.getMetamodel().getName());
        IPath sourcePath = manager.makePathAbsolute(this.mTemporaryRoot.getPath());
        this.mTemporarySourcePathId = manager.getSourcePathIdentifier(sourcePath);
    }

    public IPackageFragmentRoot getTemporaryRoot() {
        return this.mTemporaryRoot;
    }

    public SourcePathIdentifier getTemporarySourcePathIdentifier() {
        return this.mTemporarySourcePathId;
    }
}

