/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.viewdesigner.wizards;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.webdynpro.service.viewdesigner.ServiceViewDesignerPlugin;
import com.sap.ide.webdynpro.service.viewdesigner.ServicesCreation;
import com.sap.ide.webdynpro.service.viewdesigner.TextPool;
import com.sap.ide.webdynpro.service.viewdesigner.wizards.ViewWizardData;
import com.sap.ide.webdynpro.service.viewdesigner.wizards.ViewWizardPage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ViewWizard
extends Wizard
implements INewWizard {
    private final TextPool mTPool = TextPool.getInstance();
    private final String VIEWWIZARD = this.mTPool.getText(800);
    private ViewWizardData mViewWizardData = null;
    private ViewWizardPage mViewWizardPage = null;
    private View mView = null;
    private Component mComponent = null;

    public ViewWizard(Component component) {
        this.mViewWizardData = new ViewWizardData(component);
        this.mComponent = component;
    }

    public ViewWizardData getViewWizardData() {
        return this.mViewWizardData;
    }

    public boolean performFinish() {
        try {
            WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
            String viewPackage = this.mViewWizardData.getViewPackage();
            String viewName = this.mViewWizardData.getViewName();
            IPackageFragmentRoot packageFragmentRoot = this.mViewWizardData.getSelectedRoot();
            MetamodelManager manager = MetamodelManager.getMetamodelManager((String)this.mComponent.getRoot().getMetamodel().getName());
            IPath sourcePath = manager.makePathAbsolute(packageFragmentRoot.getPath());
            SourcePathIdentifier identifier = manager.getSourcePathIdentifier(sourcePath);
            IStatus status = ServicesCreation.isValidViewCreationPath(this.mComponent.getMetamodel(), viewName, viewPackage, identifier);
            if (status.getSeverity() == 4) {
                page.setErrorMessage(status.getMessage());
                return false;
            }
            String error = ServicesCreation.checkViewOnFileSystem(viewName, viewPackage, this.mComponent.getRoot().getMetamodel());
            if (error != null) {
                page.setErrorMessage(error);
                return false;
            }
            this.mView = ServicesCreation.createView(this.mComponent, viewPackage, viewName, identifier);
            if (this.mView != null) {
                return true;
            }
            ServiceViewDesignerPlugin.internalError(((Object)((Object)this)).getClass(), "performFinish()", "Errors ocurred during View creation. Quit wizard.", null, false);
            return false;
        }
        catch (Throwable e) {
            ServiceViewDesignerPlugin.internalError(((Object)((Object)this)).getClass(), "performFinish", "Exception occured", e, false);
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(this.mTPool.getText(303));
    }

    public void addPages() {
        this.mViewWizardPage = new ViewWizardPage(this.mViewWizardData, this.mComponent);
        this.addPage((IWizardPage)this.mViewWizardPage);
    }

    public View getView() {
        return this.mView;
    }
}

