/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.viewdesigner.repair;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.view.UIElementContextBinding;
import com.sap.ide.metamodel.webdynpro.component.view.UIElementEventBinding;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Group;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.TabStrip;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Table;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Tray;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElementContainer;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ViewContainerUIElement;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ViewElement;
import com.sap.ide.metamodel.webdynpro.framework.uielib.UIElementDefinition;
import com.sap.ide.metamodel.webdynpro.framework.uielib.UIElementLibrary;
import com.sap.ide.metamodel.webdynpro.framework.uielib.ViewElementDefinition;
import com.sap.ide.webdynpro.checklayer.RepairResult;
import com.sap.ide.webdynpro.service.viewdesigner.ServiceViewDesignerPlugin;
import com.sap.ide.webdynpro.service.viewdesigner.repair.GroupRepairer;
import com.sap.ide.webdynpro.service.viewdesigner.repair.TabStripRepairer;
import com.sap.ide.webdynpro.service.viewdesigner.repair.TableRepairer;
import com.sap.ide.webdynpro.service.viewdesigner.repair.TrayRepairer;
import com.sap.ide.webdynpro.service.viewdesigner.repair.UIElementContainerRepairer;
import com.sap.ide.webdynpro.service.viewdesigner.repair.ViewContainerUIElementRepairer;
import java.util.Vector;

public class ViewElementRepairer {
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$viewdesigner$repair$ViewElementRepairer;

    public static void repair(ViewElement element, Vector libraries, RepairResult repairResult) {
        ViewElementDefinition definition = null;
        if (element == null) {
            return;
        }
        definition = ViewElementRepairer.getDefinition(element);
        if (definition == null) {
            return;
        }
        if (!libraries.contains(definition.getParent())) {
            ViewElementRepairer.repairLibrary(element, (UIElementLibrary)definition.getParent(), repairResult);
        }
        if (element != null) {
            ViewElementRepairer.repairBindings(element, repairResult);
        }
        if (element != null) {
            ViewElementRepairer.repairEvents(element, repairResult);
        }
        if (element instanceof UIElementContainer) {
            UIElementContainerRepairer.repair((UIElementContainer)element, libraries, repairResult);
        }
        if (element instanceof Tray) {
            TrayRepairer.repair((Tray)element, repairResult);
        }
        if (element instanceof Group) {
            GroupRepairer.repair((Group)element, repairResult);
        }
        if (element instanceof TabStrip) {
            TabStripRepairer.repair((TabStrip)element, libraries, repairResult);
        }
        if (element instanceof Table) {
            TableRepairer.repair((Table)element, libraries, repairResult);
        }
        if (element instanceof ViewContainerUIElement) {
            ViewContainerUIElementRepairer.repair(element, repairResult);
        }
    }

    private static void repairBindings(ViewElement element, RepairResult repairResult) {
        UIElementContextBinding[] bindings = element.getContextBindings();
        int i = 0;
        while (i < bindings.length) {
            if (bindings[i].getBoundContextElement() == null) {
                try {
                    bindings[i].delete();
                    repairResult.addEntry((DevelopmentObject)element, true, "Context element not valid");
                }
                catch (DeleteException e) {
                    ServiceViewDesignerPlugin.internalError(class$com$sap$ide$webdynpro$service$viewdesigner$repair$ViewElementRepairer == null ? ViewElementRepairer.class$("com.sap.ide.webdynpro.service.viewdesigner.repair.ViewElementRepairer") : class$com$sap$ide$webdynpro$service$viewdesigner$repair$ViewElementRepairer, "repairBindings", "An error ocurred. See error log for more details.", e, false);
                }
            }
            if (bindings[i].getUIElementProperty() == null) {
                try {
                    bindings[i].delete();
                    repairResult.addEntry((DevelopmentObject)element, true, "UIElementProperty not valid");
                }
                catch (DeleteException e) {
                    ServiceViewDesignerPlugin.internalError(class$com$sap$ide$webdynpro$service$viewdesigner$repair$ViewElementRepairer == null ? ViewElementRepairer.class$("com.sap.ide.webdynpro.service.viewdesigner.repair.ViewElementRepairer") : class$com$sap$ide$webdynpro$service$viewdesigner$repair$ViewElementRepairer, "repairBindings", "An error ocurred. See error log for more details.", e, false);
                }
            }
            ++i;
        }
    }

    private static void repairEvents(ViewElement element, RepairResult repairResult) {
        UIElementEventBinding[] actions = element.getEventBindings();
        int i = 0;
        while (i < actions.length) {
            if (actions[i].getBoundAction() == null) {
                try {
                    actions[i].delete();
                    repairResult.addEntry((DevelopmentObject)element, true, "Action not valid");
                }
                catch (DeleteException e) {
                    ServiceViewDesignerPlugin.internalError(class$com$sap$ide$webdynpro$service$viewdesigner$repair$ViewElementRepairer == null ? ViewElementRepairer.class$("com.sap.ide.webdynpro.service.viewdesigner.repair.ViewElementRepairer") : class$com$sap$ide$webdynpro$service$viewdesigner$repair$ViewElementRepairer, "repairEvents", "An error ocurred. See error log for more details.", e, false);
                }
            }
            if (actions[i].getUIElementEvent() == null) {
                try {
                    actions[i].delete();
                    repairResult.addEntry((DevelopmentObject)element, true, "UIElementEvent not valid");
                }
                catch (DeleteException e) {
                    ServiceViewDesignerPlugin.internalError(class$com$sap$ide$webdynpro$service$viewdesigner$repair$ViewElementRepairer == null ? ViewElementRepairer.class$("com.sap.ide.webdynpro.service.viewdesigner.repair.ViewElementRepairer") : class$com$sap$ide$webdynpro$service$viewdesigner$repair$ViewElementRepairer, "repairEvents", "An error ocurred. See error log for more details.", e, false);
                }
            }
            ++i;
        }
    }

    private static void repairLibrary(ViewElement element, UIElementLibrary library, RepairResult repairResult) {
        Component component = (Component)element.getMDO().getParent();
        component.addUsedUIELibrary(library);
        repairResult.addEntry((DevelopmentObject)element, true, "UIElement Library " + library.getName() + " not used");
    }

    private static ViewElementDefinition getDefinition(ViewElement element) {
        if (element == null) {
            return null;
        }
        if (element.getDefinition() != null) {
            return element.getDefinition();
        }
        String elementClass = element.getMetaClass().getName();
        elementClass = elementClass.substring(elementClass.lastIndexOf(".") + 1, elementClass.length());
        Root root = element.getRoot();
        UIElementDefinition definition = null;
        if (root instanceof WebDynproRoot) {
            WebDynproRoot webDynproRoot = (WebDynproRoot)root;
            try {
                UIElementLibrary[] libraries = webDynproRoot.getUIElementLibraries();
                int j = 0;
                while (j < libraries.length) {
                    UIElementDefinition[] definitions = libraries[j].getViewElementDefinitions();
                    definition = libraries[j].getViewElementDefinition(elementClass);
                    if (definition == null && (definition = libraries[j].getUIElementDefinition(elementClass)) == null && (definition = libraries[j].getUIElementContainerDefinition(elementClass)) == null && (definition = libraries[j].getLayoutDefinition(elementClass)) == null) {
                        ++j;
                        continue;
                    }
                    break;
                }
            }
            catch (LoadException e) {
                ServiceViewDesignerPlugin.internalError(class$com$sap$ide$webdynpro$service$viewdesigner$repair$ViewElementRepairer == null ? (class$com$sap$ide$webdynpro$service$viewdesigner$repair$ViewElementRepairer = ViewElementRepairer.class$("com.sap.ide.webdynpro.service.viewdesigner.repair.ViewElementRepairer")) : class$com$sap$ide$webdynpro$service$viewdesigner$repair$ViewElementRepairer, "getDefinition", "An error ocurred. See error log for more details.", e, false);
            }
        }
        return definition;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

