/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.viewdesigner.repair;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.FlowData;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.FlowLayout;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.GridData;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.GridLayout;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Layout;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.LayoutData;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElement;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElementContainer;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ViewElement;
import com.sap.ide.metamodel.webdynpro.framework.uielib.LayoutDataDefinition;
import com.sap.ide.metamodel.webdynpro.framework.uielib.LayoutDefinition;
import com.sap.ide.metamodel.webdynpro.framework.uielib.UIElementLibrary;
import com.sap.ide.metamodel.webdynpro.framework.uielib.ViewElementDefinition;
import com.sap.ide.webdynpro.checklayer.RepairResult;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.viewdesigner.ServiceViewDesignerPlugin;
import com.sap.ide.webdynpro.service.viewdesigner.repair.ViewElementRepairer;
import java.util.Vector;

public class UIElementContainerRepairer {
    public static final int GRIDLAYOUT = 1;
    public static final int FLOWLAYOUT = 2;
    public static final int GRIDDATA = 3;
    public static final int FLOWDATA = 4;
    public static final int RASTERLAYOUT = 5;
    public static final int RASTERDATA = 6;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer;

    static void repair(UIElementContainer container, Vector libraries, RepairResult repairResult) {
        if (container.getLayout() == null) {
            try {
                container.createLayoutAsFlowLayout();
                repairResult.addEntry((DevelopmentObject)container, true, "Container does not have a layout.");
            }
            catch (CreateException e) {
                ServiceViewDesignerPlugin.internalError(class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer == null ? (class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer = UIElementContainerRepairer.class$("com.sap.ide.webdynpro.service.viewdesigner.repair.UIElementContainerRepairer")) : class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer, "repair", "An error ocurred. See error log for more details.", e, false);
            }
        }
        UIElement[] elements = container.getChildren();
        Layout layout = container.getLayout();
        int i = 0;
        while (i < elements.length) {
            ViewElementRepairer.repair((ViewElement)elements[i], libraries, repairResult);
            LayoutData data = elements[i].getLayoutData();
            if (data != null && layout != null) {
                ViewElementDefinition definition;
                if (data instanceof GridData && !(layout instanceof GridLayout)) {
                    definition = MetamodelServices.getViewElementDefinition((String)container.getRoot().getMetamodel().getName(), (String)"Standard", (String)"FlowData");
                    if (definition instanceof LayoutDataDefinition) {
                        UIElementContainerRepairer.changeData(elements[i], (LayoutDataDefinition)definition, true);
                    }
                    repairResult.addEntry((DevelopmentObject)elements[i], true, "GridData differs from LayoutManager");
                }
                if (data instanceof FlowData && !(layout instanceof FlowLayout)) {
                    definition = MetamodelServices.getViewElementDefinition((String)container.getRoot().getMetamodel().getName(), (String)"Standard", (String)"GridData");
                    if (definition instanceof LayoutDataDefinition) {
                        UIElementContainerRepairer.changeData(elements[i], (LayoutDataDefinition)definition, true);
                    }
                    repairResult.addEntry((DevelopmentObject)elements[i], true, "FlowData differs from LayoutManager");
                }
            }
            ++i;
        }
    }

    public static void changeLayout(UIElementContainer container, String layout) {
        int i;
        if (container.getLayout() != null) {
            try {
                container.getLayout().delete();
            }
            catch (DeleteException e) {
                ServiceViewDesignerPlugin.internalError(class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer == null ? (class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer = UIElementContainerRepairer.class$("com.sap.ide.webdynpro.service.viewdesigner.repair.UIElementContainerRepairer")) : class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer, "changeLayout", "An error ocurred. See error log for more details.", e, false);
            }
        }
        UIElementLibrary[] lLibraries = MetamodelServices.getLibraries((String)container.getRoot().getMetamodel().getName());
        LayoutDefinition lLayout = null;
        int j = 0;
        while (j < lLibraries.length) {
            LayoutDefinition[] lElements = lLibraries[j].getLayoutDefinitions();
            i = 0;
            while (i < lElements.length) {
                if (lElements[i].getName().equals(layout)) {
                    lLayout = lElements[i];
                    break;
                }
                ++i;
            }
            ++j;
        }
        if (lLayout != null) {
            try {
                if (lLayout.getName().equals("GridLayout")) {
                    container.createLayoutAsGridLayout(container.getName() + "_layout");
                } else if (lLayout.getName().equals("FlowLayout")) {
                    container.createLayoutAsFlowLayout(container.getName() + "_layout");
                } else if (lLayout.getName().equals("RasterLayout")) {
                    container.createLayoutAsRasterLayout(container.getName() + "_layout");
                } else {
                    container.createLayoutAsLayout(container.getName() + "_layout").setDefinition((ViewElementDefinition)lLayout);
                }
                UIElement[] children = container.getChildren();
                i = 0;
                while (i < children.length) {
                    LayoutData layoutData = children[i].getLayoutData();
                    if (layoutData != null && children[i].getLayoutData() != null) {
                        try {
                            children[i].getLayoutData().delete();
                        }
                        catch (DeleteException e) {
                            ServiceViewDesignerPlugin.internalError(class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer == null ? UIElementContainerRepairer.class$("com.sap.ide.webdynpro.service.viewdesigner.repair.UIElementContainerRepairer") : class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer, "changeLayout", "An error ocurred. See error log for more details.", e, false);
                        }
                    }
                    UIElementContainerRepairer.changeData(children[i], lLayout, false);
                    ++i;
                }
            }
            catch (CreateException e) {
                ServiceViewDesignerPlugin.internalError(class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer == null ? (class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer = UIElementContainerRepairer.class$("com.sap.ide.webdynpro.service.viewdesigner.repair.UIElementContainerRepairer")) : class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer, "changeLayout", "An error ocurred. See error log for more details.", e, false);
            }
        }
    }

    public static void changeData(UIElement element, LayoutDefinition layout, boolean always) {
        if (element != null && layout != null) {
            LayoutDataDefinition layoutDefinition = layout.getDefaultDataDefinition();
            UIElementContainerRepairer.changeData(element, layoutDefinition, always);
        }
    }

    private static void deleteOldLayoutData(UIElement element) {
        if (element.getLayoutData() != null) {
            try {
                element.getLayoutData().delete();
            }
            catch (DeleteException e) {
                ServiceViewDesignerPlugin.internalError(class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer == null ? (class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer = UIElementContainerRepairer.class$("com.sap.ide.webdynpro.service.viewdesigner.repair.UIElementContainerRepairer")) : class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer, "deleteOldLayoutData", "An error ocurred. See error log for more details.", e, false);
            }
        }
    }

    private static boolean isInherited(UIElement element, LayoutDataDefinition layoutData) {
        ViewElementDefinition oldLayoutData = null;
        if (element.getLayoutData() instanceof GridData) {
            oldLayoutData = MetamodelServices.getViewElementDefinition((String)element.getRoot().getMetamodel().getName(), (String)"Standard", (String)"GridData");
        } else if (element.getLayoutData() instanceof FlowData) {
            oldLayoutData = MetamodelServices.getViewElementDefinition((String)element.getRoot().getMetamodel().getName(), (String)"Standard", (String)"FlowData");
        } else if (element.getLayoutData() != null) {
            oldLayoutData = element.getLayoutData().getDefinition();
        }
        while (oldLayoutData != null) {
            if (oldLayoutData == layoutData) {
                return true;
            }
            oldLayoutData = (ViewElementDefinition)oldLayoutData.getSuperClass();
        }
        return false;
    }

    public static void changeData(UIElement element, LayoutDataDefinition layoutData, boolean always) {
        if (!always && UIElementContainerRepairer.isInherited(element, layoutData)) {
            return;
        }
        UIElementContainerRepairer.deleteOldLayoutData(element);
        if (element != null && layoutData != null) {
            try {
                if (layoutData.getName().equals("GridData")) {
                    element.createLayoutDataAsGridData(element.getName() + "_layoutdata");
                } else if (layoutData.getName().equals("FlowData")) {
                    element.createLayoutDataAsFlowData(element.getName() + "_layoutdata");
                } else if (layoutData.getName().equals("RasterData")) {
                    element.createLayoutDataAsRasterData(element.getName() + "_layoutdata");
                } else {
                    element.createLayoutDataAsLayoutData(element.getName() + "_layoutdata").setDefinition((ViewElementDefinition)layoutData);
                }
            }
            catch (CreateException e) {
                ServiceViewDesignerPlugin.internalError(class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer == null ? (class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer = UIElementContainerRepairer.class$("com.sap.ide.webdynpro.service.viewdesigner.repair.UIElementContainerRepairer")) : class$com$sap$ide$webdynpro$service$viewdesigner$repair$UIElementContainerRepairer, "changeData", "An error ocurred. See error log for more details.", e, false);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

