/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.viewdesigner.paste;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.webdynpro.service.controllereditor.NamingService;
import com.sap.ide.webdynpro.service.core.paste.IPasteHandler;
import com.sap.ide.webdynpro.service.core.paste.IPasteManager;
import com.sap.ide.webdynpro.service.core.paste.PasteHandlerException;
import com.sap.ide.webdynpro.service.core.paste.WebDynproObjectPasteHandler;
import com.sap.ide.webdynpro.service.viewdesigner.ServiceWithUI;
import com.sap.ide.webdynpro.service.viewdesigner.WDCopyViewDialog;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class ViewPasteHandler
extends WebDynproObjectPasteHandler {
    public MainDevelopmentObject[] getAffectedMDOs(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        if (newParent instanceof Component) {
            return new MainDevelopmentObject[]{(Component)newParent};
        }
        return super.getAffectedMDOs(clipboardObjects, newParent, scope, pasteManager);
    }

    public boolean refactorBeforeExecution(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) throws PasteHandlerException {
        if (clipboardObjects == null || clipboardObjects.length == 0) {
            return true;
        }
        if (clipboardObjects.length == 2 && clipboardObjects[0].getType() == WebDynproDevelopmentObjectEnum.VIEW && clipboardObjects[1].getType() == WebDynproDevelopmentObjectEnum.CONTROLLER) {
            WDCopyViewDialog dialog;
            String packageName = this.getPreselectedPackage(clipboardObjects[0], newParent);
            SourcePathIdentifier identifier = pasteManager.getSourcePathIdentifier();
            IPackageFragmentRoot preselectedSourceRoot = this.getPreselectedSourceRoot(identifier, newParent);
            IPackageFragmentRoot[] allRoots = this.getSourceRootsForTarget(newParent);
            ClipboardObject[] clipboardObjectHistory = pasteManager.getClipboardObjectsHistory();
            Component newComponent = null;
            if (newParent instanceof Component) {
                newComponent = (Component)newParent;
            }
            if ((dialog = ServiceWithUI.displayCopyViewDialog(allRoots, preselectedSourceRoot, this.getNewMetamodel(newParent), newComponent, clipboardObjects[0].getNewName(), packageName, clipboardObjectHistory, this.isSourceRootListEnabled(identifier, newParent))) == null) {
                return false;
            }
            String newName = dialog.getName();
            String newPackage = dialog.getPackage();
            IPackageFragmentRoot newRoot = dialog.getSourceRoot();
            clipboardObjects[0].setNewName(newName);
            clipboardObjects[0].setNewPackage(newPackage);
            newName = NamingService.getViewControllerName((String)newName);
            clipboardObjects[1].setNewName(newName);
            clipboardObjects[1].setNewPackage(newPackage);
            if (dialog.getSourceRoot() != null) {
                this.setPasteProcessSourcePathIdentifier(pasteManager, dialog.getSourceRoot(), newParent);
            }
            this.storeMapping(clipboardObjects[1], newName, newPackage, newRoot, pasteManager);
            this.addToClipboardObjectsHistory(clipboardObjects, pasteManager);
            IPasteHandler handler = pasteManager.getPasteHandler(clipboardObjects[1]);
            if (handler != null) {
                boolean cancelled;
                boolean bl = cancelled = !handler.refactorBeforeExecution(new ClipboardObject[]{clipboardObjects[1]}, newParent, scope, pasteManager);
                if (cancelled) {
                    return false;
                }
            }
        } else {
            throw new PasteHandlerException();
        }
        return true;
    }

    public void refactorAfterExecution(DevelopmentObject[] newObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        IPasteHandler handler;
        if (newObjects == null || newObjects.length == 0) {
            return;
        }
        if (newObjects.length == 2 && newObjects[0] instanceof View && newObjects[1] instanceof Controller && (handler = pasteManager.getPasteHandler(newObjects[1])) != null) {
            handler.refactorAfterExecution(new DevelopmentObject[]{newObjects[1]}, newParent, scope, pasteManager);
        }
    }
}

