/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.viewdesigner.paste;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterface;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.webdynpro.service.controllereditor.NamingService;
import com.sap.ide.webdynpro.service.core.paste.IPasteHandler;
import com.sap.ide.webdynpro.service.core.paste.IPasteManager;
import com.sap.ide.webdynpro.service.core.paste.OriginalObjectNotExistingException;
import com.sap.ide.webdynpro.service.core.paste.PasteHandlerException;
import com.sap.ide.webdynpro.service.core.paste.WebDynproObjectPasteHandler;
import com.sap.ide.webdynpro.service.viewdesigner.CopyInterfaceViewDialog;
import com.sap.ide.webdynpro.service.viewdesigner.ServiceWithUI;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class InterfaceViewPasteHandler
extends WebDynproObjectPasteHandler {
    public MainDevelopmentObject[] getAffectedMDOs(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        if (newParent instanceof Component) {
            return new MainDevelopmentObject[]{(Component)newParent};
        }
        return super.getAffectedMDOs(clipboardObjects, newParent, scope, pasteManager);
    }

    public boolean refactorBeforeExecution(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) throws PasteHandlerException {
        if (clipboardObjects == null || clipboardObjects.length == 0) {
            return true;
        }
        if (clipboardObjects.length == 2 && clipboardObjects[0].getType() == WebDynproDevelopmentObjectEnum.INTERFACEVIEW && clipboardObjects[1].getType() == WebDynproDevelopmentObjectEnum.CONTROLLER) {
            ClipboardObject interfaceViewObject = clipboardObjects[0];
            ClipboardObject controllerObject = clipboardObjects[1];
            DevelopmentObject originalIfViewObject = pasteManager.getClipboard().getSourceMetamodel().getObjectFromKey(interfaceViewObject.getOriginalKey());
            if (originalIfViewObject == null) {
                throw new OriginalObjectNotExistingException(interfaceViewObject);
            }
            String newName = null;
            String newPackage = null;
            IPackageFragmentRoot newRoot = null;
            ComponentInterface compInterface = (ComponentInterface)originalIfViewObject.getParent();
            if (!(compInterface instanceof ComponentInterfaceImplementation)) {
                if (compInterface instanceof ComponentInterfaceDefinition) {
                    CopyInterfaceViewDialog dialog;
                    ComponentInterfaceDefinition parentCID = (ComponentInterfaceDefinition)compInterface;
                    SourcePathIdentifier identifier = pasteManager.getSourcePathIdentifier();
                    IPackageFragmentRoot preselectedSourceRoot = this.getPreselectedSourceRoot(identifier, newParent);
                    IPackageFragmentRoot[] allRoots = this.getSourceRootsForTarget(newParent);
                    String packageSuggestion = this.getPreselectedPackage(interfaceViewObject, newParent, originalIfViewObject);
                    ClipboardObject[] clipboardObjectHistory = pasteManager.getClipboardObjectsHistory();
                    ComponentInterfaceDefinition newCID = null;
                    if (newParent instanceof ComponentInterfaceDefinition) {
                        newCID = (ComponentInterfaceDefinition)newParent;
                    }
                    if ((dialog = ServiceWithUI.displayCopyInterfaceViewDialog(allRoots, preselectedSourceRoot, this.getNewMetamodel(newParent), newCID, interfaceViewObject.getNewName(), packageSuggestion, clipboardObjectHistory, this.isSourceRootListEnabled(identifier, newParent))) == null) {
                        return false;
                    }
                    newName = dialog.getName();
                    newPackage = dialog.getPackage();
                    newRoot = dialog.getSourceRoot();
                    interfaceViewObject.setNewName(newName);
                    interfaceViewObject.setNewPackage(newPackage);
                    newName = NamingService.getInterfaceViewControllerName((String)interfaceViewObject.getNewName());
                    newPackage = interfaceViewObject.getNewPackage();
                    controllerObject.setNewName(newName);
                    controllerObject.setNewPackage(newPackage);
                    this.storeMapping(controllerObject, newName, newPackage, newRoot, pasteManager);
                    if (newRoot != null) {
                        this.setPasteProcessSourcePathIdentifier(pasteManager, newRoot, newParent);
                    }
                } else {
                    throw new PasteHandlerException();
                }
            }
            this.addToClipboardObjectsHistory(clipboardObjects, pasteManager);
            IPasteHandler handler = pasteManager.getPasteHandler(controllerObject);
            if (handler != null) {
                boolean cancelled;
                boolean bl = cancelled = !handler.refactorBeforeExecution(new ClipboardObject[]{controllerObject}, newParent, scope, pasteManager);
                if (cancelled) {
                    return false;
                }
            }
        }
        return true;
    }

    public void refactorAfterExecution(DevelopmentObject[] newObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        IPasteHandler handler;
        if (newObjects != null && newObjects.length == 2 && newObjects[0] instanceof InterfaceView && newObjects[1] instanceof Controller && (handler = pasteManager.getPasteHandler(newObjects[1])) != null) {
            handler.refactorAfterExecution(new DevelopmentObject[]{newObjects[1]}, newParent, scope, pasteManager);
        }
    }
}

