/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.viewdesigner;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.services.MMCCheckServices;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.WebDynproMDOEnum;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.webdynpro.service.controllereditor.NamingService;
import com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.refac.RefactoringServices;
import com.sap.ide.webdynpro.service.viewdesigner.ServicesCreation;
import com.sap.ide.webdynpro.ui.dialog.WDCopyDialog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WDCopyViewDialog
extends WDCopyDialog {
    private static final CoreTextPool mCPool = CoreTextPool.getInstance();
    private static final String VIEW = mCPool.getText(104);
    private static final String COPY_VIEW = mCPool.getText(155, (Object)VIEW);
    private Metamodel mMetamodel = null;
    private String mViewName = null;
    private String mViewPackage = null;
    private IPackageFragmentRoot mPreselectedRoot = null;
    private boolean mEnableSourceFolderList = true;
    private ClipboardObject[] mClipboardObjects = null;
    private Component mNewComponent = null;
    private boolean mDeleteNameMessage = true;
    private boolean mDeletePackageMessage = true;

    public WDCopyViewDialog(IPackageFragmentRoot[] allValidRoots, IPackageFragmentRoot preselectedRoot, Metamodel metamodel, Component newComponent, String viewName, String viewPackage, ClipboardObject[] clipboardObjects, boolean enableSourceFolderList) {
        super(allValidRoots, COPY_VIEW, "");
        this.mPreselectedRoot = preselectedRoot;
        this.mMetamodel = metamodel;
        this.mNewComponent = newComponent;
        this.mViewName = viewName;
        this.mViewPackage = viewPackage;
        this.mClipboardObjects = clipboardObjects;
        this.mEnableSourceFolderList = enableSourceFolderList;
    }

    protected void initializeListeners() {
        this.getNameField().addModifyListener((ModifyListener)new ViewNameModifyListener());
        this.getPackageField().addModifyListener((ModifyListener)new ViewPackageModifyListener());
        this.getBrowsePackageButton().addSelectionListener((SelectionListener)new BrowseViewPackageButtonListener());
        this.getSourcePathListField().addSelectionListener((SelectionListener)new ViewSourceSelectionListener());
    }

    protected void initializeFields() {
        if (this.mViewName != null) {
            String oldName = this.mViewName;
            String searchName = this.mViewName;
            int nr = 0;
            while (this.mMetamodel.objectExists(this.mViewPackage, searchName, WebDynproMDOEnum.CONTROLLER) || ControllerService.isNewControllerNameValid((String)searchName, (String)this.mViewPackage, (Metamodel)this.mMetamodel, (MainDevelopmentObject)this.mNewComponent) != null) {
                String number = "_" + nr++;
                if (nr == 1) {
                    number = "";
                }
                searchName = "Copy" + number + "_of_" + oldName;
                this.setMessage(mCPool.getText(310));
            }
            this.getNameField().setText(searchName);
            this.getNameField().setSelection(0, searchName.length() + 8);
            this.setName(this.getNameField().getText());
        }
        if (this.mViewPackage != null) {
            this.getPackageField().setText(this.mViewPackage);
            this.setPackage(this.mViewPackage);
        }
        int preselectionIndex = 0;
        IPackageFragmentRoot[] roots = this.getAllValidRoots();
        if (roots == null || roots.length <= 0) {
            return;
        }
        int i = 0;
        while (i < roots.length) {
            if (this.mPreselectedRoot != null && roots[i].equals(this.mPreselectedRoot)) {
                preselectionIndex = i;
            }
            ++i;
        }
        this.getSourcePathListField().setSelection(preselectionIndex);
        this.setSourceRoot(roots[preselectionIndex]);
        this.getSourcePathListField().setEnabled(this.mEnableSourceFolderList);
    }

    public void handlePageCompletion() {
        if (this.mDeleteNameMessage && this.mDeletePackageMessage) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        this.setPageComplete(true);
        this.setName(this.getNameField().getText());
        this.setPackage(this.getPackageField().getText());
    }

    private boolean isValidNameField() {
        this.mDeleteNameMessage = true;
        String nameInput = this.getNameField().getText();
        String packageInput = this.getPackageField().getText();
        nameInput = CheckServices.checkFirstCharacter((Text)this.getNameField());
        if (nameInput.length() <= 0) {
            this.setErrorMessage(mCPool.getText(20, (Object)VIEW));
            return false;
        }
        MMCCheckServices.CheckResult checkResult = MMCCheckServices.isValidMDOName((String)nameInput);
        if (!checkResult.isOk()) {
            this.setErrorMessage(checkResult.getMessage());
            return false;
        }
        IStatus lengthStatus = MMCCheckServices.isValidMDONameLength((String)nameInput);
        if (lengthStatus.getSeverity() == 2) {
            this.setMessage(lengthStatus.getMessage(), 2);
            this.mDeleteNameMessage = false;
        } else if (lengthStatus.getSeverity() == 4) {
            this.setErrorMessage(lengthStatus.getMessage());
            return false;
        }
        char c = nameInput.charAt(0);
        if (!Character.isUpperCase(c)) {
            this.setErrorMessage(mCPool.getText(17, (Object)nameInput));
            return false;
        }
        boolean existsInClip = RefactoringServices.nameExistsInClipboard((String)nameInput, (String)packageInput, (DevelopmentObjectEnum)WebDynproDevelopmentObjectEnum.VIEW, (ClipboardObject[])this.mClipboardObjects);
        if (existsInClip) {
            this.setErrorMessage(mCPool.getText(33, (Object)nameInput, (Object)packageInput));
            return false;
        }
        String viewControllerName = NamingService.getViewControllerName((String)nameInput);
        boolean controllerExists = ControllerService.doesAnyControllerExist((Component)this.mNewComponent, (String)viewControllerName);
        if (controllerExists) {
            this.setErrorMessage(mCPool.getText(41, (Object)nameInput));
            return false;
        }
        return true;
    }

    private boolean isValidPackageField() {
        this.mDeletePackageMessage = true;
        String packageInput = CheckServices.convertToLowerCase((Text)this.getPackageField());
        IStatus validatedStatus = CheckServices.isValidPackage((String)packageInput);
        if (validatedStatus.getSeverity() == 2) {
            this.setMessage(validatedStatus.getMessage(), 2);
            this.mDeletePackageMessage = false;
        } else if (validatedStatus.getSeverity() == 4) {
            this.setErrorMessage(validatedStatus.getMessage());
            return false;
        }
        return true;
    }

    protected void okPressed() {
        MetamodelManager manager = MetamodelManager.getMetamodelManager((String)this.mMetamodel.getName());
        IPath sourcePath = manager.makePathAbsolute(this.getSourceRoot().getPath());
        SourcePathIdentifier identifier = manager.getSourcePathIdentifier(sourcePath);
        IStatus status = ServicesCreation.isValidViewCreationPath(this.mMetamodel, this.getNameField().getText(), this.getPackageField().getText(), identifier);
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
            return;
        }
        String error = ServicesCreation.checkViewOnFileSystem(this.getNameField().getText(), this.getPackageField().getText(), this.mMetamodel);
        if (error != null) {
            this.setErrorMessage(error);
            this.setPageComplete(false);
            return;
        }
        if (status.getSeverity() == 0 && error == null) {
            super.okPressed();
        }
    }

    class BrowseViewPackageButtonListener
    extends SelectionAdapter {
        BrowseViewPackageButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IPackageFragment packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)WDCopyViewDialog.this.getSourceRoot(), (Shell)WDCopyViewDialog.this.getShell());
            if (packageFragment != null) {
                WDCopyViewDialog.this.getPackageField().setText(packageFragment.getElementName());
            }
            if (WDCopyViewDialog.this.isValidPackageField() && WDCopyViewDialog.this.isValidNameField() && WDCopyViewDialog.this.getSourcePathListField().getItemCount() > 0) {
                WDCopyViewDialog.this.handlePageCompletion();
            } else {
                WDCopyViewDialog.this.setPageComplete(false);
            }
        }
    }

    class ViewSourceSelectionListener
    implements SelectionListener {
        ViewSourceSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int selectionIndex = WDCopyViewDialog.this.getSourcePathListField().getSelectionIndex();
            if (selectionIndex >= 0) {
                IPackageFragmentRoot selectedRoot = WDCopyViewDialog.this.getAllValidRoots()[selectionIndex];
                WDCopyViewDialog.this.setSourceRoot(selectedRoot);
            }
        }
    }

    class ViewPackageModifyListener
    implements ModifyListener {
        ViewPackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (WDCopyViewDialog.this.isValidPackageField() && WDCopyViewDialog.this.isValidNameField() && WDCopyViewDialog.this.getSourcePathListField().getItemCount() > 0) {
                WDCopyViewDialog.this.handlePageCompletion();
            } else {
                WDCopyViewDialog.this.setPageComplete(false);
            }
        }
    }

    class ViewNameModifyListener
    implements ModifyListener {
        ViewNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (WDCopyViewDialog.this.isValidNameField() && WDCopyViewDialog.this.isValidPackageField() && WDCopyViewDialog.this.getSourcePathListField().getItemCount() > 0) {
                WDCopyViewDialog.this.handlePageCompletion();
            } else {
                WDCopyViewDialog.this.setPageComplete(false);
            }
        }
    }
}

