/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.eclipse.marker;

import com.sap.tc.logging.Location;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class GenerationMarker {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$generationfwk$eclipse$marker$GenerationMarker == null ? (class$com$sap$ide$generationfwk$eclipse$marker$GenerationMarker = GenerationMarker.class$("com.sap.ide.generationfwk.eclipse.marker.GenerationMarker")) : class$com$sap$ide$generationfwk$eclipse$marker$GenerationMarker).getName());
    public static final String GENERATION_MARKER_ID = "com.sap.ide.generationfwk.generationMarker";
    public static final String MARKER_ATTRIBUTE_GENERATOR_ID = "generatorId";
    static /* synthetic */ Class class$com$sap$ide$generationfwk$eclipse$marker$GenerationMarker;

    private GenerationMarker() {
    }

    public static final void createMarker(String generatorId, IResource resource, int severity, String messageText) {
        try {
            IMarker lMarker = null;
            lMarker = resource == null ? ResourcesPlugin.getWorkspace().getRoot().createMarker(GENERATION_MARKER_ID) : resource.createMarker(GENERATION_MARKER_ID);
            lMarker.setAttribute("message", (Object)messageText);
            lMarker.setAttribute("severity", severity);
            lMarker.setAttribute("location", (Object)"");
            lMarker.setAttribute(MARKER_ATTRIBUTE_GENERATOR_ID, (Object)generatorId);
        }
        catch (CoreException ex) {
            TRACE_LOCATION.errorT("Generation marker for " + resource.getName() + " could not be created (" + ((Object)((Object)ex)).getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
        }
    }

    public static final boolean hasMarkers(String generatorId) {
        try {
            IMarker[] lMarkers = ResourcesPlugin.getWorkspace().getRoot().findMarkers(GENERATION_MARKER_ID, false, 2);
            int i = 0;
            while (i < lMarkers.length) {
                if (lMarkers[i].getAttribute(MARKER_ATTRIBUTE_GENERATOR_ID, "").equals(generatorId)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Evaluation of generation markers fail (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
        }
        return false;
    }

    public static final boolean hasMarkers(String generatorId, IResource resource) {
        if (resource == null) {
            return false;
        }
        try {
            IMarker[] lMarkers = resource.findMarkers(GENERATION_MARKER_ID, true, 0);
            int i = 0;
            while (i < lMarkers.length) {
                if (lMarkers[i].getAttribute(MARKER_ATTRIBUTE_GENERATOR_ID, "").equals(generatorId)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Evaluation of generation markers fail (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
        }
        return false;
    }

    public static final boolean hasMarkers(String generatorId, IProject project) {
        if (project == null) {
            return false;
        }
        try {
            IMarker[] lMarkers = project.findMarkers(GENERATION_MARKER_ID, true, 2);
            int i = 0;
            while (i < lMarkers.length) {
                if (lMarkers[i].getAttribute(MARKER_ATTRIBUTE_GENERATOR_ID, "").equals(generatorId)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Evaluation of generation markers fail (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
        }
        return false;
    }

    public static final boolean hasMarkers(IProject project) {
        if (project == null) {
            return false;
        }
        try {
            IMarker[] lMarkers = project.findMarkers(GENERATION_MARKER_ID, true, 2);
            if (lMarkers.length > 0) {
                return true;
            }
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Evaluation of generation markers fail (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
        }
        return false;
    }

    public static final void deleteProblemMarkers(String generatorId, IProject project) {
        if (project == null) {
            return;
        }
        try {
            IMarker[] lMarkers = project.findMarkers(GENERATION_MARKER_ID, true, 2);
            int i = 0;
            while (i < lMarkers.length) {
                if (lMarkers[i].getAttribute(MARKER_ATTRIBUTE_GENERATOR_ID, "").equals(generatorId)) {
                    lMarkers[i].delete();
                }
                ++i;
            }
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Deletion of generation marker " + project.getName() + " fails (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
        }
    }

    public static final void deleteProblemMarkers(IProject project) {
        if (project == null) {
            return;
        }
        try {
            IMarker[] lMarkers = project.findMarkers(GENERATION_MARKER_ID, true, 2);
            int i = 0;
            while (i < lMarkers.length) {
                lMarkers[i].delete();
                ++i;
            }
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Deletion of generation marker " + project.getName() + " fails (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
        }
    }

    public static final void deleteProblemMarkers(String generatorId, IResource resource) {
        if (resource == null) {
            return;
        }
        try {
            IMarker[] lMarkers = resource.findMarkers(GENERATION_MARKER_ID, true, 0);
            int i = 0;
            while (i < lMarkers.length) {
                if (lMarkers[i].getAttribute(MARKER_ATTRIBUTE_GENERATOR_ID, "").equals(generatorId)) {
                    lMarkers[i].delete();
                }
                ++i;
            }
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Deletion of generation marker " + resource.getName() + " fails (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

