/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.eclipse.configuration;

import com.sap.ide.generationfwk.configuration.GenerationConfigurationBase;
import com.sap.ide.generationfwk.configuration.IGenerationUnit;
import com.sap.ide.generationfwk.eclipse.IGenerationPluginDataProvider;
import com.sap.ide.generationfwk.eclipse.configuration.method.Method;
import com.sap.ide.generationfwk.eclipse.configuration.template.Template;
import com.sap.ide.generationfwk.logging.ILogging;
import com.sap.tc.logging.Location;

public class GenerationConfiguration
extends GenerationConfigurationBase {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$generationfwk$eclipse$configuration$GenerationConfiguration == null ? (class$com$sap$ide$generationfwk$eclipse$configuration$GenerationConfiguration = GenerationConfiguration.class$("com.sap.ide.generationfwk.eclipse.configuration.GenerationConfiguration")) : class$com$sap$ide$generationfwk$eclipse$configuration$GenerationConfiguration).getName());
    private IGenerationPluginDataProvider mPluginDataProvider = null;
    static /* synthetic */ Class class$com$sap$ide$generationfwk$eclipse$configuration$GenerationConfiguration;

    public GenerationConfiguration(String templateConfigurationFile, IGenerationPluginDataProvider pluginDataProvider, ILogging logging) {
        super(templateConfigurationFile, logging);
        this.setPluginDataProvider(pluginDataProvider);
    }

    public GenerationConfiguration(IGenerationPluginDataProvider pluginDataProvider, ILogging logging) {
        super(logging);
        this.setPluginDataProvider(pluginDataProvider);
    }

    public final void refresh() {
        String lConfigurationFilePath = this.findConfigurationFile(this.getConfigurationFile());
        try {
            this.getConfiguration(this.parseConfigurationFile(lConfigurationFilePath));
        }
        catch (Throwable th) {
            TRACE_LOCATION.errorT("Configuration file " + lConfigurationFilePath + " could not be parsed (" + th.getClass().getName() + ": " + th.getMessage() + ")", new Object[]{th});
        }
    }

    protected final String findConfigurationFile(String configurationFile) {
        String lFileName = "";
        lFileName = this.getPluginDataProvider().getGenerationConfigurationFile();
        this.setConfigurationFileInternal(lFileName);
        return lFileName;
    }

    public final IGenerationUnit createGenerationUnitForMethod(String id, String methodName, String methodClassName, boolean isStatic, String outputEncoding) {
        return new Method(id, methodName, methodClassName, isStatic, outputEncoding, this.getPluginDataProvider());
    }

    public final IGenerationUnit createGenerationUnitForTemplate(String id, String path, String sourceType, String helperClassName, String templateEncoding, String outputEncoding) {
        return new Template(id, path, sourceType, helperClassName, templateEncoding, outputEncoding, this.getPluginDataProvider());
    }

    protected final String getTemplatePath(String templateName) {
        return this.getPluginDataProvider().getTemplatePath(templateName);
    }

    private IGenerationPluginDataProvider getPluginDataProvider() {
        return this.mPluginDataProvider;
    }

    private void setPluginDataProvider(IGenerationPluginDataProvider pluginDataProvider) {
        this.mPluginDataProvider = pluginDataProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

