/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.plug;

import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.metamodel.webdynpro.component.navigation.OutboundPlug;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParametersWizardPage;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParametersWizardTableModel;
import com.sap.ide.webdynpro.controllereditor.wizards.plug.CreateOutboundPlugWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.plug.CreateOutboundPlugWizardPropertiesPage;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterPlaceholder;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterService;
import com.sap.ide.webdynpro.service.controllereditor.plug.PlugService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateOutboundPlugWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String TITLE = mTextPool.getText(506);
    private CreateOutboundPlugWizardData mData = null;
    private CreateOutboundPlugWizardPropertiesPage mPropertiesPage = null;
    private CreateParametersWizardPage mParametersPage = null;
    private AbstractView mAbstractView = null;

    public CreateOutboundPlugWizard(AbstractView abstractView) {
        this(abstractView, new CreateOutboundPlugWizardData());
    }

    public CreateOutboundPlugWizard(AbstractView abstractView, CreateOutboundPlugWizardData data) {
        this.mData = data;
        this.mAbstractView = abstractView;
        this.setWindowTitle(mTextPool.getText(604));
    }

    public boolean performFinish() {
        String error = PlugService.isNewOutboundPlugNameValid((String)this.mData.getName(), (AbstractView)this.mAbstractView);
        if (error != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        error = PlugService.createOutboundPlugInternal((AbstractView)this.mAbstractView, (String)this.mData.getName(), (boolean)this.mData.getExitPlug());
        if (error != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        OutboundPlug plug = this.mAbstractView.getOutboundPlug(this.mData.getName());
        if (plug != null && (error = ParameterService.createParameters((ParameterizedFeature)plug, (ParameterPlaceholder[])this.mParametersPage.getParameters())) != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(TITLE);
    }

    public void addPages() {
        this.mPropertiesPage = new CreateOutboundPlugWizardPropertiesPage(this.mData, this.mAbstractView);
        this.addPage((IWizardPage)this.mPropertiesPage);
        CreateParametersWizardTableModel parametersTableModel = new CreateParametersWizardTableModel(this.mAbstractView.getViewController(), null, true);
        this.mParametersPage = new CreateParametersWizardPage(parametersTableModel, this.mAbstractView.getViewController(), null);
        this.addPage((IWizardPage)this.mParametersPage);
    }

    public CreateOutboundPlugWizardData getData() {
        return this.mData;
    }
}

